/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview.toolkit;

import android.widget.ListView;
import de.codecrafters.tableview.listeners.OnScrollListener;

public abstract class EndlessOnScrollListener
implements OnScrollListener {
    private static final int DEFAULT_THRESHOLD = 5;
    private final int rowThreshold;
    private int previousTotal = 0;
    private boolean loading = true;

    public EndlessOnScrollListener() {
        this(5);
    }

    public EndlessOnScrollListener(int rowThreshold) {
        this.rowThreshold = rowThreshold;
    }

    @Override
    public void onScroll(ListView tableDataView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (this.loading && totalItemCount > this.previousTotal) {
            this.loading = false;
            this.previousTotal = totalItemCount;
        }
        if (!this.loading && totalItemCount - visibleItemCount <= firstVisibleItem + this.rowThreshold) {
            this.onReloadingTriggered(firstVisibleItem, visibleItemCount, totalItemCount);
            this.loading = true;
        }
    }

    @Override
    public void onScrollStateChanged(ListView view, OnScrollListener.ScrollState scrollState) {
    }

    public abstract void onReloadingTriggered(int var1, int var2, int var3);
}

