/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview.toolkit;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import de.codecrafters.tableview.TableDataAdapter;
import de.codecrafters.tableview.TableView;
import de.codecrafters.tableview.listeners.TableDataClickListener;
import de.codecrafters.tableview.listeners.TableDataLongClickListener;
import java.util.List;

public abstract class LongPressAwareTableDataAdapter<T>
extends TableDataAdapter<T> {
    private int expandedRow = -1;

    public LongPressAwareTableDataAdapter(Context context, List<T> data, TableView<T> tableView) {
        super(context, data);
        tableView.addDataClickListener(new InternalDataClickListener());
        tableView.addDataLongClickListener(new InternalDataLongClickListener());
    }

    @Override
    public final View getCellView(int rowIndex, int columnIndex, ViewGroup parentView) {
        View view = rowIndex == this.expandedRow ? this.getLongPressCellView(rowIndex, columnIndex, parentView) : this.getDefaultCellView(rowIndex, columnIndex, parentView);
        return view;
    }

    public abstract View getDefaultCellView(int var1, int var2, ViewGroup var3);

    public abstract View getLongPressCellView(int var1, int var2, ViewGroup var3);

    private class InternalDataClickListener
    implements TableDataClickListener<T> {
        private InternalDataClickListener() {
        }

        @Override
        public void onDataClicked(int rowIndex, T clickedData) {
            LongPressAwareTableDataAdapter.this.expandedRow = -1;
            LongPressAwareTableDataAdapter.this.notifyDataSetChanged();
        }
    }

    private class InternalDataLongClickListener
    implements TableDataLongClickListener<T> {
        private InternalDataLongClickListener() {
        }

        @Override
        public boolean onDataLongClicked(int rowIndex, T clickedData) {
            LongPressAwareTableDataAdapter.this.expandedRow = rowIndex;
            LongPressAwareTableDataAdapter.this.notifyDataSetChanged();
            return true;
        }
    }
}

