/*
 * Decompiled with CFR 0.152.
 */
package com.example.item.weight;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.example.item.R;
import com.example.item.util.ScreenUtils;

public class TitleView
extends RelativeLayout {
    public TextView mTvBack;
    public TextView mTvCenter;
    public TextView mTvSure;
    public ViewGroup mViewRoot;
    private boolean mBackIsFinish;
    private OnBackViewClickListener onBackViewClickListener;
    private OnTitleViewClickListener onTitleViewClickListener;
    private OnSureViewClickListener onSureViewClickListener;

    public void setOnBackViewClickListener(OnBackViewClickListener onBackViewClickListener) {
        this.onBackViewClickListener = onBackViewClickListener;
    }

    public void setOnTitleViewClickListener(OnTitleViewClickListener onTitleViewClickListener) {
        this.onTitleViewClickListener = onTitleViewClickListener;
    }

    public void setOnSureViewClickListener(OnSureViewClickListener onSureViewClickListener) {
        this.onSureViewClickListener = onSureViewClickListener;
    }

    public TitleView(Context context) {
        this(context, null);
    }

    public TitleView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
        this.initAttrs(attrs);
        this.initEvent();
    }

    private void initView() {
        View inflate = View.inflate((Context)this.getContext(), (int)R.layout.view_title, (ViewGroup)this);
        this.mViewRoot = (ViewGroup)inflate.findViewById(R.id.root_view);
        this.mTvBack = (TextView)inflate.findViewById(R.id.tv_back);
        this.mTvCenter = (TextView)inflate.findViewById(R.id.tv_center);
        this.mTvSure = (TextView)inflate.findViewById(R.id.tv_sure);
    }

    private void initAttrs(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleView);
        if (typedArray != null && typedArray.getIndexCount() > 0) {
            this.mViewRoot.setBackgroundColor(typedArray.getColor(R.styleable.TitleView_group_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.color00000000)));
            this.mTvBack.setText((CharSequence)typedArray.getString(R.styleable.TitleView_back_data));
            this.mBackIsFinish = typedArray.getBoolean(R.styleable.TitleView_back_click_is_finish, true);
            this.mTvBack.setCompoundDrawablesWithIntrinsicBounds(typedArray.getDrawable(R.styleable.TitleView_back_left_drawable), typedArray.getDrawable(R.styleable.TitleView_back_top_drawable), typedArray.getDrawable(R.styleable.TitleView_back_right_drawable), typedArray.getDrawable(R.styleable.TitleView_back_bottom_drawable));
            this.mTvBack.setCompoundDrawablePadding(R.styleable.TitleView_back_drawable_padding);
            this.mTvBack.setPadding(typedArray.getDimensionPixelSize(R.styleable.TitleView_back_text_padding_left, 0), typedArray.getDimensionPixelSize(R.styleable.TitleView_back_text_padding_top, 0), typedArray.getDimensionPixelSize(R.styleable.TitleView_back_text_padding_right, 0), typedArray.getDimensionPixelSize(R.styleable.TitleView_back_text_padding_bottom, 0));
            this.mTvBack.setTextSize(0, (float)typedArray.getDimensionPixelSize(R.styleable.TitleView_back_text_size, (int)this.mTvBack.getTextSize()));
            this.mTvBack.setTextColor(typedArray.getColor(R.styleable.TitleView_back_text_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorFFEFEFEF)));
            this.mTvCenter.setText((CharSequence)typedArray.getString(R.styleable.TitleView_center_data));
            this.mTvCenter.setTextColor(typedArray.getColor(R.styleable.TitleView_center_text_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorFFFFFFFF)));
            this.mTvCenter.setTextSize(0, (float)typedArray.getDimensionPixelSize(R.styleable.TitleView_center_text_size, (int)this.mTvCenter.getTextSize()));
            this.mTvSure.setText((CharSequence)typedArray.getString(R.styleable.TitleView_sure_data));
            this.mTvSure.setCompoundDrawablesWithIntrinsicBounds(typedArray.getDrawable(R.styleable.TitleView_sure_left_drawable), typedArray.getDrawable(R.styleable.TitleView_sure_top_drawable), typedArray.getDrawable(R.styleable.TitleView_sure_right_drawable), typedArray.getDrawable(R.styleable.TitleView_sure_bottom_drawable));
            this.mTvSure.setTextSize(0, (float)typedArray.getDimensionPixelSize(R.styleable.TitleView_sure_text_size, (int)this.mTvSure.getTextSize()));
            this.mTvSure.setTextColor(typedArray.getColor(R.styleable.TitleView_sure_text_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.colorFFE1E1E1)));
            this.mTvSure.setCompoundDrawablePadding(R.styleable.TitleView_sure_drawable_padding);
            this.mTvSure.setPadding(typedArray.getDimensionPixelSize(R.styleable.TitleView_sure_text_padding_left, 0), typedArray.getDimensionPixelSize(R.styleable.TitleView_sure_text_padding_top, 0), typedArray.getDimensionPixelSize(R.styleable.TitleView_sure_text_padding_right, 0), typedArray.getDimensionPixelSize(R.styleable.TitleView_sure_text_padding_bottom, 0));
            typedArray.recycle();
        }
    }

    private void initEvent() {
        this.mTvBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TitleView.this.onTitleViewClickListener != null) {
                    TitleView.this.onTitleViewClickListener.onBackClick(v);
                }
                if (TitleView.this.onBackViewClickListener != null) {
                    TitleView.this.onBackViewClickListener.onBackClick(v);
                }
                if (TitleView.this.mBackIsFinish && TitleView.this.getContext() instanceof Activity) {
                    ((Activity)TitleView.this.getContext()).finish();
                }
            }
        });
        this.mTvSure.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TitleView.this.onTitleViewClickListener != null) {
                    TitleView.this.onTitleViewClickListener.onSureClick(v);
                }
                if (TitleView.this.onSureViewClickListener != null) {
                    TitleView.this.onSureViewClickListener.onSureClick(v);
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightMeasureMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightMeasureSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int resultHeightSize = ScreenUtils.dp2px(this.getContext(), 45.0f);
        switch (heightMeasureMode) {
            case 0: {
                ScreenUtils.setDefaultRootViewSize(this.getContext(), this.mViewRoot);
                break;
            }
            case -2147483648: {
                ScreenUtils.setDefaultRootViewSize(this.getContext(), this.mViewRoot);
                break;
            }
            case 0x40000000: {
                resultHeightSize = heightMeasureSize;
                break;
            }
        }
        this.setMeasuredDimension(widthMeasureSpec, resultHeightSize);
    }

    public static interface OnSureViewClickListener {
        public void onSureClick(@NonNull View var1);
    }

    public static interface OnBackViewClickListener {
        public void onBackClick(@NonNull View var1);
    }

    public static interface OnTitleViewClickListener {
        public void onBackClick(@NonNull View var1);

        public void onSureClick(@NonNull View var1);
    }
}

