/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Polynomial;
import com.pdfjet.QRCode;
import com.pdfjet.QRMath;

class QRUtil {
    private static final int G15 = 1335;
    private static final int G15_MASK = 21522;

    QRUtil() {
    }

    protected static Polynomial getErrorCorrectPolynomial(int n) {
        Polynomial polynomial = new Polynomial(new int[]{1});
        for (int i = 0; i < n; ++i) {
            polynomial = polynomial.multiply(new Polynomial(new int[]{1, QRMath.gexp(i)}));
        }
        return polynomial;
    }

    protected static boolean getMask(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                return (n2 + n3) % 2 == 0;
            }
            case 1: {
                return n2 % 2 == 0;
            }
            case 2: {
                return n3 % 3 == 0;
            }
            case 3: {
                return (n2 + n3) % 3 == 0;
            }
            case 4: {
                return (n2 / 2 + n3 / 3) % 2 == 0;
            }
            case 5: {
                return n2 * n3 % 2 + n2 * n3 % 3 == 0;
            }
            case 6: {
                return (n2 * n3 % 2 + n2 * n3 % 3) % 2 == 0;
            }
            case 7: {
                return (n2 * n3 % 3 + (n2 + n3) % 2) % 2 == 0;
            }
        }
        throw new IllegalArgumentException("mask: " + n);
    }

    protected static int getLostPoint(QRCode qRCode) {
        int n;
        int n2;
        int n3;
        int n4 = qRCode.getModuleCount();
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = 0;
                boolean bl = qRCode.isDark(n3, n2);
                for (int i = -1; i <= 1; ++i) {
                    if (n3 + i < 0 || n4 <= n3 + i) continue;
                    for (int j = -1; j <= 1; ++j) {
                        if (n2 + j < 0 || n4 <= n2 + j || i == 0 && j == 0 || bl != qRCode.isDark(n3 + i, n2 + j)) continue;
                        ++n;
                    }
                }
                if (n <= 5) continue;
                n5 += 3 + n - 5;
            }
        }
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            for (n2 = 0; n2 < n4 - 1; ++n2) {
                n = 0;
                if (qRCode.isDark(n3, n2)) {
                    ++n;
                }
                if (qRCode.isDark(n3 + 1, n2)) {
                    ++n;
                }
                if (qRCode.isDark(n3, n2 + 1)) {
                    ++n;
                }
                if (qRCode.isDark(n3 + 1, n2 + 1)) {
                    ++n;
                }
                if (n != 0 && n != 4) continue;
                n5 += 3;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4 - 6; ++n2) {
                if (!qRCode.isDark(n3, n2) || qRCode.isDark(n3, n2 + 1) || !qRCode.isDark(n3, n2 + 2) || !qRCode.isDark(n3, n2 + 3) || !qRCode.isDark(n3, n2 + 4) || qRCode.isDark(n3, n2 + 5) || !qRCode.isDark(n3, n2 + 6)) continue;
                n5 += 40;
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n4 - 6; ++n2) {
                if (!qRCode.isDark(n2, n3) || qRCode.isDark(n2 + 1, n3) || !qRCode.isDark(n2 + 2, n3) || !qRCode.isDark(n2 + 3, n3) || !qRCode.isDark(n2 + 4, n3) || qRCode.isDark(n2 + 5, n3) || !qRCode.isDark(n2 + 6, n3)) continue;
                n5 += 40;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n4; ++n) {
                if (!qRCode.isDark(n, n2)) continue;
                ++n3;
            }
        }
        n2 = Math.abs(100 * n3 / n4 / n4 - 50) / 5;
        return n5 += n2 * 10;
    }

    public static int getBCHTypeInfo(int n) {
        int n2 = n << 10;
        while (QRUtil.getBCHDigit(n2) - QRUtil.getBCHDigit(1335) >= 0) {
            n2 ^= 1335 << QRUtil.getBCHDigit(n2) - QRUtil.getBCHDigit(1335);
        }
        return (n << 10 | n2) ^ 0x5412;
    }

    private static int getBCHDigit(int n) {
        int n2 = 0;
        while (n != 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }
}

