/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Destination;
import com.pdfjet.Font;
import com.pdfjet.Operation;
import com.pdfjet.PDF;
import com.pdfjet.Point;
import com.pdfjet.State;
import com.pdfjet.StructElem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page {
    protected PDF pdf;
    protected int objNumber;
    protected ByteArrayOutputStream buf;
    protected float[] tm = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
    protected int renderingMode = 0;
    protected float width;
    protected float height;
    protected List<Integer> contents;
    protected List<Annotation> annots;
    protected List<Destination> destinations;
    protected float[] cropBox = null;
    protected float[] bleedBox = null;
    protected float[] trimBox = null;
    protected float[] artBox = null;
    protected List<StructElem> structures = new ArrayList<StructElem>();
    private float[] pen = new float[]{0.0f, 0.0f, 0.0f};
    private float[] brush = new float[]{0.0f, 0.0f, 0.0f};
    private float pen_width = -1.0f;
    private int line_cap_style = 0;
    private int line_join_style = 0;
    private String linePattern = "[] 0";
    private Font font;
    private List<State> savedStates = new ArrayList<State>();
    private int mcid = 0;

    public Page(PDF pDF, float[] fArray) throws Exception {
        this(pDF, fArray, true);
    }

    public Page(PDF pDF, float[] fArray, boolean bl) throws Exception {
        this.pdf = pDF;
        this.contents = new ArrayList<Integer>();
        this.annots = new ArrayList<Annotation>();
        this.destinations = new ArrayList<Destination>();
        this.width = fArray[0];
        this.height = fArray[1];
        this.buf = new ByteArrayOutputStream(8192);
        if (bl) {
            pDF.addPage(this);
        }
    }

    public byte[] getContent() {
        return this.buf.toByteArray();
    }

    public void addDestination(String string, float f) {
        this.destinations.add(new Destination(string, this.height - f));
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void drawLine(double d, double d2, double d3, double d4) throws IOException {
        this.drawLine((float)d, (float)d2, (float)d3, (float)d4);
    }

    public void drawLine(float f, float f2, float f3, float f4) throws IOException {
        this.moveTo(f, f2);
        this.lineTo(f3, f4);
        this.strokePath();
    }

    public void drawString(Font font, Font font2, String string, float f, float f2) throws IOException {
        if (font2 == null) {
            this.drawString(font, string, f, f2);
        } else {
            Font font3 = font;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                String string2;
                char c = string.charAt(i);
                if (font.isCJK && c >= '\u4e00' && c <= '\u9fcc' || !font.isCJK && font.unicodeToGID[c] != 0) {
                    if (font != font3) {
                        string2 = stringBuilder.toString();
                        this.drawString(font3, string2, f, f2);
                        f += font3.stringWidth(string2);
                        stringBuilder.setLength(0);
                        font3 = font;
                    }
                } else if (font2 != font3) {
                    string2 = stringBuilder.toString();
                    this.drawString(font3, string2, f, f2);
                    f += font3.stringWidth(string2);
                    stringBuilder.setLength(0);
                    font3 = font2;
                }
                stringBuilder.append(c);
            }
            this.drawString(font3, stringBuilder.toString(), f, f2);
        }
    }

    public void drawString(Font font, String string, double d, double d2) throws IOException {
        this.drawString(font, string, (float)d, (float)d2);
    }

    public void drawString(Font font, String string, float f, float f2) throws IOException {
        if (string == null || string.equals("")) {
            return;
        }
        this.append("BT\n");
        if (font.fontID == null) {
            this.setTextFont(font);
        } else {
            this.append('/');
            this.append(font.fontID);
            this.append(' ');
            this.append(font.size);
            this.append(" Tf\n");
        }
        if (this.renderingMode != 0) {
            this.append(this.renderingMode);
            this.append(" Tr\n");
        }
        float f3 = 0.0f;
        if (font.skew15 && this.tm[0] == 1.0f && this.tm[1] == 0.0f && this.tm[2] == 0.0f && this.tm[3] == 1.0f) {
            f3 = 0.26f;
        }
        this.append(this.tm[0]);
        this.append(' ');
        this.append(this.tm[1]);
        this.append(' ');
        this.append(this.tm[2] + f3);
        this.append(' ');
        this.append(this.tm[3]);
        this.append(' ');
        this.append(f);
        this.append(' ');
        this.append(this.height - f2);
        this.append(" Tm\n");
        this.append("[ (");
        this.drawString(font, string);
        this.append(") ] TJ\n");
        this.append("ET\n");
    }

    private void drawString(Font font, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (font.isComposite) {
                this.drawTwoByteChar(c, font);
                continue;
            }
            this.drawOneByteChar(c, font, string, i);
        }
    }

    private void drawTwoByteChar(int n, Font font) throws IOException {
        if (n < font.firstChar || n > font.lastChar) {
            if (font.isCJK) {
                this.append((byte)0);
                this.append((byte)32);
            } else {
                this.append((byte)font.unicodeToGID[0]);
                this.append((byte)font.unicodeToGID[32]);
            }
        } else {
            byte by;
            byte by2;
            if (font.isCJK) {
                by2 = (byte)(n >> 8);
                by = (byte)n;
            } else {
                int n2 = font.unicodeToGID[n];
                by2 = (byte)(n2 >> 8);
                by = (byte)n2;
            }
            if (by2 == 40 || by2 == 41 || by2 == 92) {
                this.append((byte)92);
            }
            this.append(by2);
            if (by == 13) {
                this.append("\\015");
            } else {
                if (by == 40 || by == 41 || by == 92) {
                    this.append((byte)92);
                }
                this.append(by);
            }
        }
    }

    private void drawOneByteChar(int n, Font font, String string, int n2) throws IOException {
        if (n < font.firstChar || n > font.lastChar) {
            n = font.mapUnicodeChar(n);
        }
        if (n == 40 || n == 41 || n == 92) {
            this.append((byte)92);
        }
        this.append((byte)n);
        if (font.isStandard && font.kernPairs && n2 < string.length() - 1) {
            n -= 32;
            int n3 = string.charAt(n2 + 1);
            if (n3 < font.firstChar || n3 > font.lastChar) {
                n3 = 32;
            }
            for (int i = 2; i < font.metrics[n].length; i += 2) {
                if (font.metrics[n][i] != n3) continue;
                this.append(") ");
                this.append(-font.metrics[n][i + 1]);
                this.append(" (");
                break;
            }
        }
    }

    public void setPenColor(double d, double d2, double d3) throws IOException {
        this.setPenColor((float)d, (float)d2, (float)d3);
    }

    public void setPenColor(float f, float f2, float f3) throws IOException {
        if (this.pen[0] != f || this.pen[1] != f2 || this.pen[2] != f3) {
            this.setColor(f, f2, f3);
            this.append(" RG\n");
            this.pen[0] = f;
            this.pen[1] = f2;
            this.pen[2] = f3;
        }
    }

    public void setBrushColor(double d, double d2, double d3) throws IOException {
        this.setBrushColor((float)d, (float)d2, (float)d3);
    }

    public void setBrushColor(float f, float f2, float f3) throws IOException {
        if (this.brush[0] != f || this.brush[1] != f2 || this.brush[2] != f3) {
            this.setColor(f, f2, f3);
            this.append(" rg\n");
            this.brush[0] = f;
            this.brush[1] = f2;
            this.brush[2] = f3;
        }
    }

    public void setBrushColor(float[] fArray) throws IOException {
        this.setBrushColor(fArray[0], fArray[1], fArray[2]);
    }

    public float[] getBrushColor() {
        return this.brush;
    }

    private void setColor(float f, float f2, float f3) throws IOException {
        this.append(f);
        this.append(' ');
        this.append(f2);
        this.append(' ');
        this.append(f3);
    }

    public void setPenColor(int n) throws IOException {
        float f = (float)(n >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(n & 0xFF) / 255.0f;
        this.setPenColor(f, f2, f3);
    }

    public void setBrushColor(int n) throws IOException {
        float f = (float)(n >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(n >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(n & 0xFF) / 255.0f;
        this.setBrushColor(f, f2, f3);
    }

    public void setDefaultLineWidth() throws IOException {
        if (this.pen_width != 0.0f) {
            this.pen_width = 0.0f;
            this.append(this.pen_width);
            this.append(" w\n");
        }
    }

    public void setLinePattern(String string) throws IOException {
        if (!string.equals(this.linePattern)) {
            this.linePattern = string;
            this.append(this.linePattern);
            this.append(" d\n");
        }
    }

    public void setDefaultLinePattern() throws IOException {
        this.append("[] 0");
        this.append(" d\n");
    }

    public void setPenWidth(double d) throws IOException {
        this.setPenWidth((float)d);
    }

    public void setPenWidth(float f) throws IOException {
        if (this.pen_width != f) {
            this.pen_width = f;
            this.append(this.pen_width);
            this.append(" w\n");
        }
    }

    public void setLineCapStyle(int n) throws IOException {
        if (this.line_cap_style != n) {
            this.line_cap_style = n;
            this.append(this.line_cap_style);
            this.append(" J\n");
        }
    }

    public void setLineJoinStyle(int n) throws IOException {
        if (this.line_join_style != n) {
            this.line_join_style = n;
            this.append(this.line_join_style);
            this.append(" j\n");
        }
    }

    public void moveTo(double d, double d2) throws IOException {
        this.moveTo((float)d, (float)d2);
    }

    public void moveTo(float f, float f2) throws IOException {
        this.append(f);
        this.append(' ');
        this.append(this.height - f2);
        this.append(" m\n");
    }

    public void lineTo(double d, double d2) throws IOException {
        this.lineTo((float)d, (float)d2);
    }

    public void lineTo(float f, float f2) throws IOException {
        this.append(f);
        this.append(' ');
        this.append(this.height - f2);
        this.append(" l\n");
    }

    public void strokePath() throws IOException {
        this.append("S\n");
    }

    public void closePath() throws IOException {
        this.append("s\n");
    }

    public void fillPath() throws IOException {
        this.append("f\n");
    }

    public void drawRect(double d, double d2, double d3, double d4) throws IOException {
        this.drawRect((float)d, (float)d2, (float)d3, (float)d4);
    }

    public void drawRect(float f, float f2, float f3, float f4) throws IOException {
        this.moveTo(f, f2);
        this.lineTo(f + f3, f2);
        this.lineTo(f + f3, f2 + f4);
        this.lineTo(f, f2 + f4);
        this.closePath();
    }

    public void fillRect(double d, double d2, double d3, double d4) throws IOException {
        this.fillRect((float)d, (float)d2, (float)d3, (float)d4);
    }

    public void fillRect(float f, float f2, float f3, float f4) throws IOException {
        this.moveTo(f, f2);
        this.lineTo(f + f3, f2);
        this.lineTo(f + f3, f2 + f4);
        this.lineTo(f, f2 + f4);
        this.fillPath();
    }

    public void drawPath(List<Point> list, char c) throws Exception {
        if (list.size() < 2) {
            throw new Exception("The Path object must contain at least 2 points");
        }
        Point point = list.get(0);
        this.moveTo(point.x, point.y);
        boolean bl = false;
        for (int i = 1; i < list.size(); ++i) {
            point = list.get(i);
            if (point.isControlPoint) {
                bl = true;
                this.append(point);
                continue;
            }
            if (bl) {
                bl = false;
                this.append(point);
                this.append("c\n");
                continue;
            }
            this.lineTo(point.x, point.y);
        }
        this.append(c);
        this.append('\n');
    }

    public void drawCircle(double d, double d2, double d3) throws Exception {
        this.drawEllipse((float)d, (float)d2, (float)d3, (float)d3, Operation.STROKE);
    }

    public void drawCircle(float f, float f2, float f3) throws Exception {
        this.drawEllipse(f, f2, f3, f3, Operation.STROKE);
    }

    public void drawCircle(double d, double d2, double d3, char c) throws Exception {
        this.drawEllipse((float)d, (float)d2, (float)d3, (float)d3, c);
    }

    public void drawEllipse(double d, double d2, double d3, double d4) throws Exception {
        this.drawEllipse((float)d, (float)d2, (float)d3, (float)d4, Operation.STROKE);
    }

    public void drawEllipse(float f, float f2, float f3, float f4) throws Exception {
        this.drawEllipse(f, f2, f3, f4, Operation.STROKE);
    }

    public void fillEllipse(double d, double d2, double d3, double d4) throws Exception {
        this.drawEllipse((float)d, (float)d2, (float)d3, (float)d4, Operation.FILL);
    }

    public void fillEllipse(float f, float f2, float f3, float f4) throws Exception {
        this.drawEllipse(f, f2, f3, f4, Operation.FILL);
    }

    private void drawEllipse(float f, float f2, float f3, float f4, char c) throws Exception {
        float f5 = 0.551784f;
        this.moveTo(f, f2 - f4);
        this.appendPointXY(f + f5 * f3, f2 - f4);
        this.appendPointXY(f + f3, f2 - f5 * f4);
        this.appendPointXY(f + f3, f2);
        this.append("c\n");
        this.appendPointXY(f + f3, f2 + f5 * f4);
        this.appendPointXY(f + f5 * f3, f2 + f4);
        this.appendPointXY(f, f2 + f4);
        this.append("c\n");
        this.appendPointXY(f - f5 * f3, f2 + f4);
        this.appendPointXY(f - f3, f2 + f5 * f4);
        this.appendPointXY(f - f3, f2);
        this.append("c\n");
        this.appendPointXY(f - f3, f2 - f5 * f4);
        this.appendPointXY(f - f5 * f3, f2 - f4);
        this.appendPointXY(f, f2 - f4);
        this.append("c\n");
        this.append(c);
        this.append('\n');
    }

    public void drawPoint(Point point) throws Exception {
        if (point.shape != -1) {
            if (point.shape == 0) {
                if (point.fillShape) {
                    this.drawCircle(point.x, point.y, point.r, 'f');
                } else {
                    this.drawCircle(point.x, point.y, point.r, 'S');
                }
            } else if (point.shape == 1) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(new Point(point.x, point.y - point.r));
                arrayList.add(new Point(point.x + point.r, point.y));
                arrayList.add(new Point(point.x, point.y + point.r));
                arrayList.add(new Point(point.x - point.r, point.y));
                if (point.fillShape) {
                    this.drawPath(arrayList, 'f');
                } else {
                    this.drawPath(arrayList, 's');
                }
            } else if (point.shape == 2) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(new Point(point.x - point.r, point.y - point.r));
                arrayList.add(new Point(point.x + point.r, point.y - point.r));
                arrayList.add(new Point(point.x + point.r, point.y + point.r));
                arrayList.add(new Point(point.x - point.r, point.y + point.r));
                if (point.fillShape) {
                    this.drawPath(arrayList, 'f');
                } else {
                    this.drawPath(arrayList, 's');
                }
            } else if (point.shape == 3) {
                this.drawLine(point.x - point.r, point.y, point.x + point.r, point.y);
                this.drawLine(point.x, point.y - point.r, point.x, point.y + point.r);
            } else if (point.shape == 9) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(new Point(point.x, point.y - point.r));
                arrayList.add(new Point(point.x + point.r, point.y + point.r));
                arrayList.add(new Point(point.x - point.r, point.y + point.r));
                if (point.fillShape) {
                    this.drawPath(arrayList, 'f');
                } else {
                    this.drawPath(arrayList, 's');
                }
            } else if (point.shape == 10) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(new Point(point.x - point.r, point.y - point.r));
                arrayList.add(new Point(point.x + point.r, point.y - point.r));
                arrayList.add(new Point(point.x, point.y + point.r));
                if (point.fillShape) {
                    this.drawPath(arrayList, 'f');
                } else {
                    this.drawPath(arrayList, 's');
                }
            } else if (point.shape == 11) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(new Point(point.x + point.r, point.y + point.r));
                arrayList.add(new Point(point.x - point.r, point.y));
                arrayList.add(new Point(point.x + point.r, point.y - point.r));
                if (point.fillShape) {
                    this.drawPath(arrayList, 'f');
                } else {
                    this.drawPath(arrayList, 's');
                }
            } else if (point.shape == 12) {
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(new Point(point.x - point.r, point.y - point.r));
                arrayList.add(new Point(point.x + point.r, point.y));
                arrayList.add(new Point(point.x - point.r, point.y + point.r));
                if (point.fillShape) {
                    this.drawPath(arrayList, 'f');
                } else {
                    this.drawPath(arrayList, 's');
                }
            } else if (point.shape == 4) {
                this.drawLine(point.x - point.r, point.y, point.x + point.r, point.y);
            } else if (point.shape == 5) {
                this.drawLine(point.x, point.y - point.r, point.x, point.y + point.r);
            } else if (point.shape == 8) {
                this.drawLine(point.x - point.r, point.y - point.r, point.x + point.r, point.y + point.r);
                this.drawLine(point.x - point.r, point.y + point.r, point.x + point.r, point.y - point.r);
            } else if (point.shape == 6) {
                this.drawLine(point.x - point.r, point.y - point.r, point.x + point.r, point.y + point.r);
                this.drawLine(point.x - point.r, point.y + point.r, point.x + point.r, point.y - point.r);
                this.drawLine(point.x - point.r, point.y, point.x + point.r, point.y);
                this.drawLine(point.x, point.y - point.r, point.x, point.y + point.r);
            } else if (point.shape == 7) {
                float f = 0.31415927f;
                float f2 = (float)Math.sin(f);
                float f3 = (float)Math.cos(f);
                float f4 = point.r * f3;
                float f5 = point.r * f2;
                float f6 = 2.0f * f4 * f2;
                float f7 = 2.0f * f4 * f3 - point.r;
                ArrayList<Point> arrayList = new ArrayList<Point>();
                arrayList.add(new Point(point.x, point.y - point.r));
                arrayList.add(new Point(point.x + f6, point.y + f7));
                arrayList.add(new Point(point.x - f4, point.y - f5));
                arrayList.add(new Point(point.x + f4, point.y - f5));
                arrayList.add(new Point(point.x - f6, point.y + f7));
                if (point.fillShape) {
                    this.drawPath(arrayList, 'f');
                } else {
                    this.drawPath(arrayList, 's');
                }
            }
        }
    }

    public void setTextRenderingMode(int n) throws Exception {
        if (n < 0 || n > 7) {
            throw new Exception("Invalid text rendering mode: " + n);
        }
        this.renderingMode = n;
    }

    public void setTextDirection(int n) throws Exception {
        if (n > 360) {
            n %= 360;
        }
        if (n == 0) {
            this.tm = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        } else if (n == 90) {
            this.tm = new float[]{0.0f, 1.0f, -1.0f, 0.0f};
        } else if (n == 180) {
            this.tm = new float[]{-1.0f, 0.0f, 0.0f, -1.0f};
        } else if (n == 270) {
            this.tm = new float[]{0.0f, -1.0f, 1.0f, 0.0f};
        } else if (n == 360) {
            this.tm = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        } else {
            float f = (float)Math.sin((double)n * (Math.PI / 180));
            float f2 = (float)Math.cos((double)n * (Math.PI / 180));
            this.tm = new float[]{f2, f, -f, f2};
        }
    }

    public void bezierCurveTo(Point point, Point point2, Point point3) throws IOException {
        this.append(point);
        this.append(point2);
        this.append(point3);
        this.append("c\n");
    }

    public void setTextStart() throws IOException {
        this.append("BT\n");
    }

    public void setTextLocation(float f, float f2) throws IOException {
        this.append(f);
        this.append(' ');
        this.append(this.height - f2);
        this.append(" Td\n");
    }

    public void setTextBegin(float f, float f2) throws IOException {
        this.append("BT\n");
        this.append(f);
        this.append(' ');
        this.append(this.height - f2);
        this.append(" Td\n");
    }

    public void setTextLeading(float f) throws IOException {
        this.append(f);
        this.append(" TL\n");
    }

    public void setCharSpacing(float f) throws IOException {
        this.append(f);
        this.append(" Tc\n");
    }

    public void setWordSpacing(float f) throws IOException {
        this.append(f);
        this.append(" Tw\n");
    }

    public void setTextScaling(float f) throws IOException {
        this.append(f);
        this.append(" Tz\n");
    }

    public void setTextRise(float f) throws IOException {
        this.append(f);
        this.append(" Ts\n");
    }

    public void setTextFont(Font font) throws IOException {
        this.font = font;
        this.append("/F");
        this.append(font.objNumber);
        this.append(' ');
        this.append(font.size);
        this.append(" Tf\n");
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void print(String string) throws IOException {
        this.append('(');
        if (this.font != null && this.font.isComposite) {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                this.drawTwoByteChar(c, this.font);
            }
        } else {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '(' || c == ')' || c == '\\') {
                    this.append('\\');
                    this.append((byte)c);
                    continue;
                }
                if (c == '\t') {
                    this.append(' ');
                    this.append(' ');
                    this.append(' ');
                    this.append(' ');
                    continue;
                }
                this.append((byte)c);
            }
        }
        this.append(") Tj\n");
    }

    public void println() throws IOException {
        this.append("T*\n");
    }

    public void setTextEnd() throws IOException {
        this.append("ET\n");
    }

    public void drawRectRoundCorners(float f, float f2, float f3, float f4, float f5, float f6, char c) throws Exception {
        float f7 = 0.551784f;
        ArrayList<Point> arrayList = new ArrayList<Point>();
        arrayList.add(new Point(f + f3 - f5, f2));
        arrayList.add(new Point(f + f3 - f5 + f7 * f5, f2, true));
        arrayList.add(new Point(f + f3, f2 + f6 - f7 * f6, true));
        arrayList.add(new Point(f + f3, f2 + f6));
        arrayList.add(new Point(f + f3, f2 + f4 - f6));
        arrayList.add(new Point(f + f3, f2 + f4 - f6 + f7 * f6, true));
        arrayList.add(new Point(f + f3 - f7 * f5, f2 + f4, true));
        arrayList.add(new Point(f + f3 - f5, f2 + f4));
        arrayList.add(new Point(f + f5, f2 + f4));
        arrayList.add(new Point(f + f5 - f7 * f5, f2 + f4, true));
        arrayList.add(new Point(f, f2 + f4 - f7 * f6, true));
        arrayList.add(new Point(f, f2 + f4 - f6));
        arrayList.add(new Point(f, f2 + f6));
        arrayList.add(new Point(f, f2 + f6 - f7 * f6, true));
        arrayList.add(new Point(f + f7 * f5, f2, true));
        arrayList.add(new Point(f + f5, f2));
        arrayList.add(new Point(f + f3 - f5, f2));
        this.drawPath(arrayList, c);
    }

    public void clipPath() throws IOException {
        this.append("W\n");
        this.append("n\n");
    }

    public void clipRect(float f, float f2, float f3, float f4) throws IOException {
        this.moveTo(f, f2);
        this.lineTo(f + f3, f2);
        this.lineTo(f + f3, f2 + f4);
        this.lineTo(f, f2 + f4);
        this.clipPath();
    }

    public void save() throws IOException {
        this.append("q\n");
        this.savedStates.add(new State(this.pen, this.brush, this.pen_width, this.line_cap_style, this.line_join_style, this.linePattern));
    }

    public void restore() throws IOException {
        this.append("Q\n");
        if (this.savedStates.size() > 0) {
            State state = this.savedStates.remove(this.savedStates.size() - 1);
            this.pen = state.getPen();
            this.brush = state.getBrush();
            this.pen_width = state.getPenWidth();
            this.line_cap_style = state.getLineCapStyle();
            this.line_join_style = state.getLineJoinStyle();
            this.linePattern = state.getLinePattern();
        }
    }

    public void setCropBox(float f, float f2, float f3, float f4) {
        this.cropBox = new float[]{f, f2, f3, f4};
    }

    public void setBleedBox(float f, float f2, float f3, float f4) {
        this.bleedBox = new float[]{f, f2, f3, f4};
    }

    public void setTrimBox(float f, float f2, float f3, float f4) {
        this.trimBox = new float[]{f, f2, f3, f4};
    }

    public void setArtBox(float f, float f2, float f3, float f4) {
        this.artBox = new float[]{f, f2, f3, f4};
    }

    private void appendPointXY(float f, float f2) throws IOException {
        this.append(f);
        this.append(' ');
        this.append(this.height - f2);
        this.append(' ');
    }

    private void append(Point point) throws IOException {
        this.append(point.x);
        this.append(' ');
        this.append(this.height - point.y);
        this.append(' ');
    }

    protected void append(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.buf.write((byte)string.charAt(i));
        }
    }

    protected void append(int n) throws IOException {
        this.append(Integer.toString(n));
    }

    protected void append(float f) throws IOException {
        this.append(PDF.df.format(f));
    }

    protected void append(char c) throws IOException {
        this.buf.write((byte)c);
    }

    protected void append(byte by) throws IOException {
        this.buf.write(by);
    }

    public void append(byte[] byArray) throws IOException {
        this.buf.write(byArray);
    }

    protected void drawString(Font font, String string, float f, float f2, Map<String, Integer> map) throws Exception {
        this.setTextBegin(f, f2);
        this.setTextFont(font);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                this.printBuffer(stringBuilder2, map);
                stringBuilder.append(c);
                continue;
            }
            this.printBuffer(stringBuilder, map);
            stringBuilder2.append(c);
        }
        this.printBuffer(stringBuilder, map);
        this.printBuffer(stringBuilder2, map);
        this.setTextEnd();
    }

    private void printBuffer(StringBuilder stringBuilder, Map<String, Integer> map) throws Exception {
        String string = stringBuilder.toString();
        if (string.length() > 0) {
            if (map.containsKey(string)) {
                this.setBrushColor(map.get(string));
            } else {
                this.setBrushColor(0);
            }
        }
        this.print(string);
        stringBuilder.setLength(0);
    }

    protected void setStructElementsPageObjNumber(int n) throws Exception {
        for (StructElem structElem : this.structures) {
            structElem.pageObjNumber = n;
        }
    }

    public void addBMC(String string, String string2, String string3) throws Exception {
        this.addBMC(string, null, string2, string3);
    }

    public void addBMC(String string, String string2, String string3, String string4) throws Exception {
        if (this.pdf.compliance == 2) {
            StructElem structElem = new StructElem();
            structElem.structure = string;
            structElem.mcid = this.mcid;
            structElem.language = string2;
            structElem.altDescription = string3;
            structElem.actualText = string4;
            this.structures.add(structElem);
            this.append("/");
            this.append(string);
            this.append(" <</MCID ");
            this.append(this.mcid++);
            this.append(">>\n");
            this.append("BDC\n");
        }
    }

    public void addEMC() throws Exception {
        if (this.pdf.compliance == 2) {
            this.append("EMC\n");
        }
    }

    protected void addAnnotation(Annotation annotation) {
        this.annots.add(annotation);
        if (this.pdf.compliance == 2) {
            StructElem structElem = new StructElem();
            structElem.structure = "Link";
            structElem.language = annotation.language;
            structElem.altDescription = annotation.altDescription;
            structElem.actualText = annotation.actualText;
            structElem.annotation = annotation;
            this.structures.add(structElem);
        }
    }
}

