/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.CP1250;
import com.pdfjet.CP1251;
import com.pdfjet.CP1252;
import com.pdfjet.CP1253;
import com.pdfjet.CP1254;
import com.pdfjet.CP1257;
import com.pdfjet.Font;
import com.pdfjet.OTF;
import com.pdfjet.PDF;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OpenTypeFont {
    protected OTF otf = null;

    OpenTypeFont() {
    }

    protected void registerAsSimple(PDF pDF, Font font, InputStream inputStream, int n, boolean bl) throws Exception {
        this.otf = new OTF(inputStream);
        if (bl) {
            this.embedFontFile(pDF, font, this.otf, true);
        }
        this.addFontDescriptorObject(pDF, font, this.otf, bl);
        this.addWidthsArrayObject(pDF, font, this.otf, n);
        this.addEncodingObject(pDF, font, n);
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Font\n");
        if (this.otf.cff) {
            pDF.append("/Subtype /Type1\n");
        } else {
            pDF.append("/Subtype /TrueType\n");
        }
        pDF.append("/BaseFont /");
        pDF.append(this.otf.fontName);
        pDF.append('\n');
        pDF.append("/FirstChar ");
        pDF.append(this.otf.firstChar);
        pDF.append('\n');
        pDF.append("/LastChar ");
        pDF.append(255);
        pDF.append('\n');
        pDF.append("/Encoding ");
        pDF.append(font.getEncodingObjNumber());
        pDF.append(" 0 R\n");
        pDF.append("/Widths ");
        pDF.append(font.getWidthsArrayObjNumber());
        pDF.append(" 0 R\n");
        pDF.append("/FontDescriptor ");
        pDF.append(font.getFontDescriptorObjNumber());
        pDF.append(" 0 R\n");
        pDF.append(">>\n");
        pDF.endobj();
        font.objNumber = pDF.objNumber;
    }

    protected void registerAsComposite(PDF pDF, Font font, InputStream inputStream, boolean bl) throws Exception {
        this.otf = new OTF(inputStream);
        if (bl) {
            this.embedFontFile(pDF, font, this.otf, false);
        }
        this.addFontDescriptorObject(pDF, font, this.otf, bl);
        this.addCIDFontDictionaryObject(pDF, font, this.otf);
        this.addToUnicodeCMapObject(pDF, font, this.otf);
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Font\n");
        pDF.append("/Subtype /Type0\n");
        pDF.append("/BaseFont /");
        pDF.append(this.otf.fontName);
        pDF.append('\n');
        pDF.append("/Encoding /Identity-H\n");
        pDF.append("/DescendantFonts [");
        pDF.append(font.getCidFontDictObjNumber());
        pDF.append(" 0 R]\n");
        pDF.append("/ToUnicode ");
        pDF.append(font.getToUnicodeCMapObjNumber());
        pDF.append(" 0 R\n");
        pDF.append(">>\n");
        pDF.endobj();
        font.objNumber = pDF.objNumber;
    }

    private void embedFontFile(PDF pDF, Font font, OTF oTF, boolean bl) throws Exception {
        int n;
        for (n = 0; n < pDF.fonts.size(); ++n) {
            Font font2 = pDF.fonts.get(n);
            if (!font2.name.equals(oTF.fontName) || font2.fileObjNumber == -1) continue;
            font.fileObjNumber = font2.fileObjNumber;
            return;
        }
        n = -1;
        if (oTF.fontName.toLowerCase().indexOf("droid") != -1 || oTF.fontName.toLowerCase().indexOf("roboto") != -1) {
            n = pDF.addMetadataObject("\n-----------------------------------------------------------------------------\nThe following PDF object stream contains font from The Android Open Source\nProject:\n\n    http://developer.android.com/index.html\n\nThe font was compressed using the RFC 1951 DEFLATE algorithm and it is\nstill licensed under its original Apache License, Version 2.0:\n-----------------------------------------------------------------------------\n\n   Copyright (c) 2005-2008, The Android Open Source Project\n\n   Licensed under the Apache License, Version 2.0 (the \"License\");\n   you may not use this file except in compliance with the License.\n\n   Unless required by applicable law or agreed to in writing, software\n   distributed under the License is distributed on an \"AS IS\" BASIS,\n   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n   See the License for the specific language governing permissions and\n   limitations under the License.\n\n\n                                 Apache License\n                           Version 2.0, January 2004\n                        http://www.apache.org/licenses/\n\n   TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION\n\n   1. Definitions.\n\n      \"License\" shall mean the terms and conditions for use, reproduction,\n      and distribution as defined by Sections 1 through 9 of this document.\n\n      \"Licensor\" shall mean the copyright owner or entity authorized by\n      the copyright owner that is granting the License.\n\n      \"Legal Entity\" shall mean the union of the acting entity and all\n      other entities that control, are controlled by, or are under common\n      control with that entity. For the purposes of this definition,\n      \"control\" means (i) the power, direct or indirect, to cause the\n      direction or management of such entity, whether by contract or\n      otherwise, or (ii) ownership of fifty percent (50%) or more of the\n      outstanding shares, or (iii) beneficial ownership of such entity.\n\n      \"You\" (or \"Your\") shall mean an individual or Legal Entity\n      exercising permissions granted by this License.\n\n      \"Source\" form shall mean the preferred form for making modifications,\n      including but not limited to software source code, documentation\n      source, and configuration files.\n\n      \"Object\" form shall mean any form resulting from mechanical\n      transformation or translation of a Source form, including but\n      not limited to compiled object code, generated documentation,\n      and conversions to other media types.\n\n      \"Work\" shall mean the work of authorship, whether in Source or\n      Object form, made available under the License, as indicated by a\n      copyright notice that is included in or attached to the work\n      (an example is provided in the Appendix below).\n\n      \"Derivative Works\" shall mean any work, whether in Source or Object\n      form, that is based on (or derived from) the Work and for which the\n      editorial revisions, annotations, elaborations, or other modifications\n      represent, as a whole, an original work of authorship. For the purposes\n      of this License, Derivative Works shall not include works that remain\n      separable from, or merely link (or bind by name) to the interfaces of,\n      the Work and Derivative Works thereof.\n\n      \"Contribution\" shall mean any work of authorship, including\n      the original version of the Work and any modifications or additions\n      to that Work or Derivative Works thereof, that is intentionally\n      submitted to Licensor for inclusion in the Work by the copyright owner\n      or by an individual or Legal Entity authorized to submit on behalf of\n      the copyright owner. For the purposes of this definition, \"submitted\"\n      means any form of electronic, verbal, or written communication sent\n      to the Licensor or its representatives, including but not limited to\n      communication on electronic mailing lists, source code control systems,\n      and issue tracking systems that are managed by, or on behalf of, the\n      Licensor for the purpose of discussing and improving the Work, but\n      excluding communication that is conspicuously marked or otherwise\n      designated in writing by the copyright owner as \"Not a Contribution.\"\n\n      \"Contributor\" shall mean Licensor and any individual or Legal Entity\n      on behalf of whom a Contribution has been received by Licensor and\n      subsequently incorporated within the Work.\n\n   2. Grant of Copyright License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      copyright license to reproduce, prepare Derivative Works of,\n      publicly display, publicly perform, sublicense, and distribute the\n      Work and such Derivative Works in Source or Object form.\n\n   3. Grant of Patent License. Subject to the terms and conditions of\n      this License, each Contributor hereby grants to You a perpetual,\n      worldwide, non-exclusive, no-charge, royalty-free, irrevocable\n      (except as stated in this section) patent license to make, have made,\n      use, offer to sell, sell, import, and otherwise transfer the Work,\n      where such license applies only to those patent claims licensable\n      by such Contributor that are necessarily infringed by their\n      Contribution(s) alone or by combination of their Contribution(s)\n      with the Work to which such Contribution(s) was submitted. If You\n      institute patent litigation against any entity (including a\n      cross-claim or counterclaim in a lawsuit) alleging that the Work\n      or a Contribution incorporated within the Work constitutes direct\n      or contributory patent infringement, then any patent licenses\n      granted to You under this License for that Work shall terminate\n      as of the date such litigation is filed.\n\n   4. Redistribution. You may reproduce and distribute copies of the\n      Work or Derivative Works thereof in any medium, with or without\n      modifications, and in Source or Object form, provided that You\n      meet the following conditions:\n\n      (a) You must give any other recipients of the Work or\n          Derivative Works a copy of this License; and\n\n      (b) You must cause any modified files to carry prominent notices\n          stating that You changed the files; and\n\n      (c) You must retain, in the Source form of any Derivative Works\n          that You distribute, all copyright, patent, trademark, and\n          attribution notices from the Source form of the Work,\n          excluding those notices that do not pertain to any part of\n          the Derivative Works; and\n\n      (d) If the Work includes a \"NOTICE\" text file as part of its\n          distribution, then any Derivative Works that You distribute must\n          include a readable copy of the attribution notices contained\n          within such NOTICE file, excluding those notices that do not\n          pertain to any part of the Derivative Works, in at least one\n          of the following places: within a NOTICE text file distributed\n          as part of the Derivative Works; within the Source form or\n          documentation, if provided along with the Derivative Works; or,\n          within a display generated by the Derivative Works, if and\n          wherever such third-party notices normally appear. The contents\n          of the NOTICE file are for informational purposes only and\n          do not modify the License. You may add Your own attribution\n          notices within Derivative Works that You distribute, alongside\n          or as an addendum to the NOTICE text from the Work, provided\n          that such additional attribution notices cannot be construed\n          as modifying the License.\n\n      You may add Your own copyright statement to Your modifications and\n      may provide additional or different license terms and conditions\n      for use, reproduction, or distribution of Your modifications, or\n      for any such Derivative Works as a whole, provided Your use,\n      reproduction, and distribution of the Work otherwise complies with\n      the conditions stated in this License.\n\n   5. Submission of Contributions. Unless You explicitly state otherwise,\n      any Contribution intentionally submitted for inclusion in the Work\n      by You to the Licensor shall be under the terms and conditions of\n      this License, without any additional terms or conditions.\n      Notwithstanding the above, nothing herein shall supersede or modify\n      the terms of any separate license agreement you may have executed\n      with Licensor regarding such Contributions.\n\n   6. Trademarks. This License does not grant permission to use the trade\n      names, trademarks, service marks, or product names of the Licensor,\n      except as required for reasonable and customary use in describing the\n      origin of the Work and reproducing the content of the NOTICE file.\n\n   7. Disclaimer of Warranty. Unless required by applicable law or\n      agreed to in writing, Licensor provides the Work (and each\n      Contributor provides its Contributions) on an \"AS IS\" BASIS,\n      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or\n      implied, including, without limitation, any warranties or conditions\n      of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A\n      PARTICULAR PURPOSE. You are solely responsible for determining the\n      appropriateness of using or redistributing the Work and assume any\n      risks associated with Your exercise of permissions under this License.\n\n   8. Limitation of Liability. In no event and under no legal theory,\n      whether in tort (including negligence), contract, or otherwise,\n      unless required by applicable law (such as deliberate and grossly\n      negligent acts) or agreed to in writing, shall any Contributor be\n      liable to You for damages, including any direct, indirect, special,\n      incidental, or consequential damages of any character arising as a\n      result of this License or out of the use or inability to use the\n      Work (including but not limited to damages for loss of goodwill,\n      work stoppage, computer failure or malfunction, or any and all\n      other commercial damages or losses), even if such Contributor\n      has been advised of the possibility of such damages.\n\n   9. Accepting Warranty or Additional Liability. While redistributing\n      the Work or Derivative Works thereof, You may choose to offer,\n      and charge a fee for, acceptance of support, warranty, indemnity,\n      or other liability obligations and/or rights consistent with this\n      License. However, in accepting such obligations, You may act only\n      on Your own behalf and on Your sole responsibility, not on behalf\n      of any other Contributor, and only if You agree to indemnify,\n      defend, and hold each Contributor harmless for any liability\n      incurred by, or claims asserted against, such Contributor by reason\n      of your accepting any such warranty or additional liability.\n\n   END OF TERMS AND CONDITIONS\n\n-----------------------------------------------------------------------------\n", true);
        }
        pDF.newobj();
        pDF.append("<<\n");
        if (oTF.cff) {
            if (bl) {
                pDF.append("/Subtype /Type1C\n");
            } else {
                pDF.append("/Subtype /CIDFontType0C\n");
            }
        }
        pDF.append("/Filter /FlateDecode\n");
        pDF.append("/Length ");
        pDF.append(oTF.baos.size());
        pDF.append("\n");
        if (!oTF.cff) {
            pDF.append("/Length1 ");
            pDF.append(oTF.buf.length);
            pDF.append('\n');
        }
        if (n != -1) {
            pDF.append("/Metadata ");
            pDF.append(n);
            pDF.append(" 0 R\n");
        }
        pDF.append(">>\n");
        pDF.append("stream\n");
        pDF.append(oTF.baos);
        pDF.append("\nendstream\n");
        pDF.endobj();
        font.fileObjNumber = pDF.objNumber;
    }

    private void addFontDescriptorObject(PDF pDF, Font font, OTF oTF, boolean bl) throws Exception {
        float f = 1000.0f / (float)oTF.unitsPerEm;
        for (int i = 0; i < pDF.fonts.size(); ++i) {
            Font font2 = pDF.fonts.get(i);
            if (!font2.name.equals(oTF.fontName) || font2.getFontDescriptorObjNumber() == -1) continue;
            font.setFontDescriptorObjNumber(font2.getFontDescriptorObjNumber());
            return;
        }
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /FontDescriptor\n");
        pDF.append("/FontName /");
        pDF.append(oTF.fontName);
        pDF.append('\n');
        if (bl) {
            if (oTF.cff) {
                pDF.append("/FontFile3 ");
            } else {
                pDF.append("/FontFile2 ");
            }
            pDF.append(font.fileObjNumber);
            pDF.append(" 0 R\n");
        }
        pDF.append("/Flags 32\n");
        pDF.append("/FontBBox [");
        pDF.append((float)oTF.bBoxLLx * f);
        pDF.append(' ');
        pDF.append((float)oTF.bBoxLLy * f);
        pDF.append(' ');
        pDF.append((float)oTF.bBoxURx * f);
        pDF.append(' ');
        pDF.append((float)oTF.bBoxURy * f);
        pDF.append("]\n");
        pDF.append("/Ascent ");
        pDF.append((float)oTF.ascent * f);
        pDF.append('\n');
        pDF.append("/Descent ");
        pDF.append((float)oTF.descent * f);
        pDF.append('\n');
        pDF.append("/ItalicAngle 0\n");
        pDF.append("/CapHeight ");
        pDF.append((float)oTF.capHeight * f);
        pDF.append('\n');
        pDF.append("/StemV 79\n");
        pDF.append(">>\n");
        pDF.endobj();
        font.setFontDescriptorObjNumber(pDF.objNumber);
    }

    private void addWidthsArrayObject(PDF pDF, Font font, OTF oTF, int n) throws Exception {
        pDF.newobj();
        pDF.append("[ ");
        int n2 = 1;
        for (int i = oTF.firstChar; i < 256; ++i) {
            if (i < 127) {
                pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.glyphWidth[i]));
            } else if (n == 0) {
                pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.glyphWidth[CP1250.codes[i - 127]]));
            } else if (n == 1) {
                pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.glyphWidth[CP1251.codes[i - 127]]));
            } else if (n == 2) {
                pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.glyphWidth[CP1252.codes[i - 127]]));
            } else if (n == 3) {
                pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.glyphWidth[CP1253.codes[i - 127]]));
            } else if (n == 4) {
                pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.glyphWidth[CP1254.codes[i - 127]]));
            } else if (n == 7) {
                pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.glyphWidth[CP1257.codes[i - 127]]));
            }
            if (n2 < 10) {
                pDF.append(' ');
                ++n2;
                continue;
            }
            pDF.append('\n');
            n2 = 1;
        }
        pDF.append("]\n");
        pDF.endobj();
        font.setWidthsArrayObjNumber(pDF.objNumber);
    }

    private void addEncodingObject(PDF pDF, Font font, int n) throws Exception {
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Encoding\n");
        pDF.append("/BaseEncoding /WinAnsiEncoding\n");
        pDF.append("/Differences [127\n");
        for (int i = 0; i < 129; ++i) {
            if (n == 0) {
                pDF.append(CP1250.names[i]);
            } else if (n == 1) {
                pDF.append(CP1251.names[i]);
            } else if (n == 2) {
                pDF.append(CP1252.names[i]);
            } else if (n == 3) {
                pDF.append(CP1253.names[i]);
            } else if (n == 4) {
                pDF.append(CP1254.names[i]);
            } else if (n == 7) {
                pDF.append(CP1257.names[i]);
            }
            pDF.append(' ');
        }
        pDF.append("]\n");
        pDF.append(">>\n");
        pDF.endobj();
        font.setEncodingObjNumber(pDF.objNumber);
    }

    private void addToUnicodeCMapObject(PDF pDF, Font font, OTF oTF) throws Exception {
        Object object;
        for (int i = 0; i < pDF.fonts.size(); ++i) {
            object = pDF.fonts.get(i);
            if (!((Font)object).name.equals(oTF.fontName) || ((Font)object).getToUnicodeCMapObjNumber() == -1) continue;
            font.setToUnicodeCMapObjNumber(((Font)object).getToUnicodeCMapObjNumber());
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("/CIDInit /ProcSet findresource begin\n");
        stringBuilder.append("12 dict begin\n");
        stringBuilder.append("begincmap\n");
        stringBuilder.append("/CIDSystemInfo <</Registry (Adobe) /Ordering (Identity) /Supplement 0>> def\n");
        stringBuilder.append("/CMapName /Adobe-Identity def\n");
        stringBuilder.append("/CMapType 2 def\n");
        stringBuilder.append("1 begincodespacerange\n");
        stringBuilder.append("<0000> <FFFF>\n");
        stringBuilder.append("endcodespacerange\n");
        object = new ArrayList();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i <= 65535; ++i) {
            int n = oTF.unicodeToGID[i];
            if (n <= 0) continue;
            stringBuilder2.append('<');
            stringBuilder2.append(this.toHexString(n));
            stringBuilder2.append("> <");
            stringBuilder2.append(this.toHexString(i));
            stringBuilder2.append(">\n");
            object.add(stringBuilder2.toString());
            stringBuilder2.setLength(0);
            if (object.size() != 100) continue;
            this.writeListToBuffer((List<String>)object, stringBuilder);
        }
        if (object.size() > 0) {
            this.writeListToBuffer((List<String>)object, stringBuilder);
        }
        stringBuilder.append("endcmap\n");
        stringBuilder.append("CMapName currentdict /CMap defineresource pop\n");
        stringBuilder.append("end\nend");
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Length ");
        pDF.append(stringBuilder.length());
        pDF.append("\n");
        pDF.append(">>\n");
        pDF.append("stream\n");
        pDF.append(stringBuilder.toString());
        pDF.append("\nendstream\n");
        pDF.endobj();
        font.setToUnicodeCMapObjNumber(pDF.objNumber);
    }

    private void addCIDFontDictionaryObject(PDF pDF, Font font, OTF oTF) throws Exception {
        int n;
        for (n = 0; n < pDF.fonts.size(); ++n) {
            Font font2 = pDF.fonts.get(n);
            if (!font2.name.equals(oTF.fontName) || font2.getCidFontDictObjNumber() == -1) continue;
            font.setCidFontDictObjNumber(font2.getCidFontDictObjNumber());
            return;
        }
        pDF.newobj();
        pDF.append("<<\n");
        pDF.append("/Type /Font\n");
        if (oTF.cff) {
            pDF.append("/Subtype /CIDFontType0\n");
        } else {
            pDF.append("/Subtype /CIDFontType2\n");
        }
        pDF.append("/BaseFont /");
        pDF.append(oTF.fontName);
        pDF.append('\n');
        pDF.append("/CIDSystemInfo <</Registry (Adobe) /Ordering (Identity) /Supplement 0>>\n");
        pDF.append("/FontDescriptor ");
        pDF.append(font.getFontDescriptorObjNumber());
        pDF.append(" 0 R\n");
        pDF.append("/DW ");
        pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.advanceWidth[0]));
        pDF.append('\n');
        pDF.append("/W [0[\n");
        for (n = 0; n < oTF.advanceWidth.length; ++n) {
            pDF.append((int)(1000.0f / (float)oTF.unitsPerEm * (float)oTF.advanceWidth[n]));
            if ((n + 1) % 10 == 0) {
                pDF.append('\n');
                continue;
            }
            pDF.append(' ');
        }
        pDF.append("]]\n");
        pDF.append("/CIDToGIDMap /Identity\n");
        pDF.append(">>\n");
        pDF.endobj();
        font.setCidFontDictObjNumber(pDF.objNumber);
    }

    private String toHexString(int n) {
        String string = Integer.toHexString(n);
        if (string.length() == 1) {
            return "000" + string;
        }
        if (string.length() == 2) {
            return "00" + string;
        }
        if (string.length() == 3) {
            return "0" + string;
        }
        return string;
    }

    private void writeListToBuffer(List<String> list, StringBuilder stringBuilder) {
        stringBuilder.append(list.size());
        stringBuilder.append(" beginbfchar\n");
        for (String string : list) {
            stringBuilder.append(string);
        }
        stringBuilder.append("endbfchar\n");
        list.clear();
    }
}

