/*
 * Decompiled with CFR 0.152.
 */
package com.pdfjet;

import com.pdfjet.Annotation;
import com.pdfjet.Page;

public class Box {
    protected float x;
    protected float y;
    private float w;
    private float h;
    private int color = 0;
    private float width = 0.3f;
    private String pattern = "[] 0";
    private boolean fill_shape = false;
    private String language = null;
    private String altDescription = " ";
    private String actualText = " ";
    protected String uri = null;
    protected String key = null;

    public Box() {
    }

    public Box(double d, double d2, double d3, double d4) {
        this.x = (float)d;
        this.y = (float)d2;
        this.w = (float)d3;
        this.h = (float)d4;
    }

    public Box(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.w = f3;
        this.h = f4;
    }

    public Box setPosition(double d, double d2) {
        return this.setLocation((float)d, (float)d2);
    }

    public Box setPosition(float f, float f2) {
        return this.setLocation(f, f2);
    }

    public Box setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public void setSize(double d, double d2) {
        this.w = (float)d;
        this.h = (float)d2;
    }

    public void setSize(float f, float f2) {
        this.w = f;
        this.h = f2;
    }

    public void setColor(int n) {
        this.color = n;
    }

    public void setLineWidth(double d) {
        this.width = (float)d;
    }

    public void setLineWidth(float f) {
        this.width = f;
    }

    public void setURIAction(String string) {
        this.uri = string;
    }

    public void setGoToAction(String string) {
        this.key = string;
    }

    public Box setAltDescription(String string) {
        this.altDescription = string;
        return this;
    }

    public Box setActualText(String string) {
        this.actualText = string;
        return this;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setFillShape(boolean bl) {
        this.fill_shape = bl;
    }

    public void placeIn(Box box, double d, double d2) throws Exception {
        this.placeIn(box, (float)d, (float)d2);
    }

    public void placeIn(Box box, float f, float f2) throws Exception {
        this.x = box.x + f;
        this.y = box.y + f2;
    }

    public void scaleBy(double d) throws Exception {
        this.scaleBy((float)d);
    }

    public void scaleBy(float f) throws Exception {
        this.x *= f;
        this.y *= f;
    }

    public void drawOn(Page page) throws Exception {
        page.addBMC("Span", this.language, this.altDescription, this.actualText);
        page.setPenWidth(this.width);
        page.setLinePattern(this.pattern);
        if (this.fill_shape) {
            page.setBrushColor(this.color);
        } else {
            page.setPenColor(this.color);
        }
        page.moveTo(this.x, this.y);
        page.lineTo(this.x + this.w, this.y);
        page.lineTo(this.x + this.w, this.y + this.h);
        page.lineTo(this.x, this.y + this.h);
        if (this.fill_shape) {
            page.fillPath();
        } else {
            page.closePath();
        }
        page.addEMC();
        if (this.uri != null || this.key != null) {
            page.addAnnotation(new Annotation(this.uri, this.key, this.x, page.height - this.y, this.x + this.w, page.height - (this.y + this.h), this.language, this.altDescription, this.actualText));
        }
    }
}

