/*
 * Decompiled with CFR 0.152.
 */
package com.hendrix.pdfmyxml.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class BitmapUtils {
    private static DisplayMetrics _dm;
    private static Resources _resources;

    private BitmapUtils() {
    }

    public static void init(Resources resources) {
        _resources = resources;
        _dm = _resources.getDisplayMetrics();
    }

    public static Bitmap resizeBitmap(Bitmap bmSrc, Rect rectDest, ScaleMode scaleMode, boolean fitBitmapResult, boolean scaleConditionally, boolean recycleBmpSource) {
        Matrix mat = new Matrix();
        int wOrig = bmSrc.getWidth();
        int hOrig = bmSrc.getHeight();
        int wScaleTo = rectDest.width();
        int hScaleTo = rectDest.height();
        if (wScaleTo == 0 && hScaleTo == 0) {
            throw new Error("resizeBitmap: need at least $scaleTo.width or $scaleTo.height");
        }
        float arW = wScaleTo != 0 ? (float)wScaleTo / (float)wOrig : Float.NaN;
        float arH = hScaleTo != 0 ? (float)hScaleTo / (float)hOrig : Float.NaN;
        arW = Float.isNaN(arW) ? arH : arW;
        arH = Float.isNaN(arH) ? arW : arH;
        float arMin = Math.min(arW, arH);
        float arMax = Math.max(arW, arH);
        wScaleTo = wScaleTo != 0 ? wScaleTo : (int)((float)wOrig * arW);
        int n = hScaleTo = hScaleTo != 0 ? hScaleTo : (int)((float)hOrig * arH);
        if (scaleConditionally) {
            boolean isScaleConditionally;
            boolean bl = isScaleConditionally = wScaleTo >= bmSrc.getWidth() && hScaleTo >= bmSrc.getHeight();
            if (isScaleConditionally) {
                return Bitmap.createBitmap((Bitmap)bmSrc);
            }
        }
        Bitmap bmResult = Bitmap.createBitmap((int)wScaleTo, (int)hScaleTo, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bmResult);
        switch (scaleMode) {
            case STRETCH: {
                mat.reset();
                mat.postScale(arW, arH);
                canvas.drawBitmap(bmSrc, mat, null);
                break;
            }
            case LETTERBOX: {
                if (fitBitmapResult) {
                    if (bmResult != null) {
                        bmResult.recycle();
                    }
                    wScaleTo = (int)((float)wOrig * arMin);
                    hScaleTo = (int)((float)hOrig * arMin);
                    bmResult = Bitmap.createBitmap((int)wScaleTo, (int)hScaleTo, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    canvas.setBitmap(bmResult);
                }
                mat.reset();
                mat.postScale(arMin, arMin);
                canvas.drawBitmap(bmSrc, mat, null);
                break;
            }
            case ZOOM: {
                mat.reset();
                mat.postScale(arMax, arMax);
                canvas.drawBitmap(bmSrc, mat, null);
                break;
            }
            case NONE: {
                mat.reset();
                canvas.drawBitmap(bmSrc, mat, null);
            }
        }
        if (recycleBmpSource) {
            bmSrc.recycle();
        }
        return bmResult;
    }

    public static Bitmap pathToBitmap(String picturePath) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inDither = false;
        opts.inPurgeable = true;
        opts.inInputShareable = true;
        opts.inTempStorage = new byte[32768];
        return BitmapFactory.decodeFile((String)picturePath, (BitmapFactory.Options)opts);
    }

    public static Bitmap cutCircleFromBitmap(String picturePath, int destCube) {
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inDither = false;
        opts.inPurgeable = true;
        opts.inInputShareable = true;
        opts.inTempStorage = new byte[32768];
        Bitmap bitmapImg = BitmapFactory.decodeFile((String)picturePath, (BitmapFactory.Options)opts);
        int cube = destCube;
        if (bitmapImg == null) {
            return null;
        }
        int smallest = Math.min(bitmapImg.getWidth(), bitmapImg.getHeight());
        Bitmap output = Bitmap.createBitmap((int)cube, (int)cube, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        int left = (int)((double)(bitmapImg.getWidth() - smallest) * 0.5);
        int top = (int)((double)(bitmapImg.getHeight() - smallest) * 0.5);
        Rect rectSrc = new Rect(left, top, left + smallest, top + smallest);
        Rect rectDest = new Rect(0, 0, cube, cube);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawCircle((float)(cube / 2), (float)(cube / 2), (float)(cube / 2), paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmapImg, rectSrc, rectDest, paint);
        bitmapImg.recycle();
        return output;
    }

    public static byte[] bitmapToPng(Bitmap image) {
        if (image == null) {
            return null;
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        if (image.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)ba)) {
            return ba.toByteArray();
        }
        return null;
    }

    public static ByteArrayInputStream bitmapToPngInputStream(Bitmap image) {
        return new ByteArrayInputStream(BitmapUtils.bitmapToPng(image));
    }

    public static byte[] bitmapToJpg(Bitmap image, int quality) {
        if (image == null) {
            return null;
        }
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        if (image.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)ba)) {
            return ba.toByteArray();
        }
        return null;
    }

    public static Bitmap imgToBitmap(byte[] image) {
        if (image == null) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
    }

    public static int dpToPx(float val) {
        return (int)TypedValue.applyDimension((int)1, (float)val, (DisplayMetrics)_dm);
    }

    public static Bitmap maskBitmap(Bitmap src, Bitmap mask, Bitmap dst, Canvas dstCanvas, Paint paint, PorterDuffXfermode paintMode) {
        if (dst == null) {
            dst = Bitmap.createBitmap((int)mask.getWidth(), (int)mask.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        if (dstCanvas == null) {
            dstCanvas = new Canvas(dst);
        }
        if (paintMode == null) {
            paintMode = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
        }
        if (paint == null) {
            paint = new Paint(1);
            paint.setXfermode((Xfermode)paintMode);
        }
        dstCanvas.drawBitmap(src, 0.0f, 0.0f, null);
        dstCanvas.drawBitmap(mask, 0.0f, 0.0f, paint);
        paint.setXfermode(null);
        return dst;
    }

    public static Bitmap maskBitmap(Bitmap src, int drawableResId) {
        Bitmap mask = BitmapFactory.decodeResource((Resources)_resources, (int)drawableResId);
        return BitmapUtils.maskBitmap(src, mask, null, null, null, null);
    }

    public static Bitmap roundBitMap(Bitmap bitmap) {
        Bitmap circleBitmap = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Paint paint = new Paint(1);
        paint.setShader((Shader)shader);
        Canvas c = new Canvas(circleBitmap);
        c.drawCircle((float)(bitmap.getWidth() / 2), (float)(bitmap.getHeight() / 2), (float)(bitmap.getWidth() / 2), paint);
        return circleBitmap;
    }

    public static Bitmap getCroppedBitmap(Bitmap bmp, int radius) {
        Bitmap sbmp = bmp.getWidth() != radius || bmp.getHeight() != radius ? Bitmap.createScaledBitmap((Bitmap)bmp, (int)radius, (int)radius, (boolean)false) : bmp;
        Bitmap output = Bitmap.createBitmap((int)sbmp.getWidth(), (int)sbmp.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint(1);
        Rect rect = new Rect(0, 0, sbmp.getWidth(), sbmp.getHeight());
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setDither(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(Color.parseColor((String)"#BAB399"));
        canvas.drawCircle((float)(sbmp.getWidth() / 2) + 0.7f, (float)(sbmp.getHeight() / 2) + 0.7f, (float)(sbmp.getWidth() / 2) + 0.1f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(sbmp, rect, rect, paint);
        return output;
    }

    public static enum ScaleMode {
        STRETCH,
        LETTERBOX,
        ZOOM,
        NONE;

    }
}

