/*
 * Decompiled with CFR 0.152.
 */
package com.potyvideo.library.utils;

import android.annotation.SuppressLint;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/potyvideo/library/utils/PathUtil;", "", "()V", "Companion", "library_release"})
public final class PathUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\r"}, d2={"Lcom/potyvideo/library/utils/PathUtil$Companion;", "", "()V", "getPath", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "isDownloadsDocument", "", "isExternalStorageDocument", "isMediaDocument", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @SuppressLint(value={"NewApi"})
        @Nullable
        public final String getPath(@NotNull Context context, @Nullable Uri uri) throws URISyntaxException {
            String[] split;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Uri uri2 = uri;
            Intrinsics.checkNotNull((Object)uri2);
            Uri uri3 = uri2;
            boolean needToCheckUri = Build.VERSION.SDK_INT >= 19;
            String selection = null;
            String[] selectionArgs = null;
            if (needToCheckUri && DocumentsContract.isDocumentUri((Context)context.getApplicationContext(), (Uri)uri3)) {
                if (this.isExternalStorageDocument(uri3)) {
                    void $this$toTypedArray$iv;
                    String docId = DocumentsContract.getDocumentId((Uri)uri3);
                    Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                    Object object = docId;
                    Regex regex = new Regex(":");
                    int n = 0;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    String[] split2 = stringArray;
                    return Environment.getExternalStorageDirectory().toString() + "/" + split2[1];
                }
                if (this.isDownloadsDocument(uri3)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri3);
                    Uri uri4 = Uri.parse((String)"content://downloads/public_downloads");
                    Long l = Long.valueOf(id2);
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(id)");
                    split = ContentUris.withAppendedId((Uri)uri4, (long)((Number)l).longValue());
                    Intrinsics.checkNotNullExpressionValue((Object)split, (String)"withAppendedId(\n        \u2026va.lang.Long.valueOf(id))");
                    uri3 = split;
                } else if (this.isMediaDocument(uri3)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri3);
                    Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                    Object $this$toTypedArray$iv = docId;
                    Regex $i$f$toTypedArray = new Regex(":");
                    int thisCollection$iv = 0;
                    $this$toTypedArray$iv = $i$f$toTypedArray.split((CharSequence)$this$toTypedArray$iv, thisCollection$iv);
                    boolean $i$f$toTypedArray2 = false;
                    Object thisCollection$iv2 = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv2.toArray(new String[0]);
                    Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    split = stringArray;
                    String type = split[0];
                    if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                        Uri uri5 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                        Intrinsics.checkNotNullExpressionValue((Object)uri5, (String)"EXTERNAL_CONTENT_URI");
                        uri3 = uri5;
                    } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                        Uri uri6 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                        Intrinsics.checkNotNullExpressionValue((Object)uri6, (String)"EXTERNAL_CONTENT_URI");
                        uri3 = uri6;
                    } else if (Intrinsics.areEqual((Object)"audio", (Object)type)) {
                        Uri uri7 = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                        Intrinsics.checkNotNullExpressionValue((Object)uri7, (String)"EXTERNAL_CONTENT_URI");
                        uri3 = uri7;
                    }
                    selection = "_id=?";
                    String[] stringArray2 = new String[]{split[1]};
                    selectionArgs = stringArray2;
                }
            }
            if (StringsKt.equals((String)"content", (String)uri3.getScheme(), (boolean)true)) {
                split = new String[]{"_data"};
                String[] projection = split;
                Cursor cursor = null;
                try {
                    Cursor cursor2 = cursor = context.getContentResolver().query(uri3, projection, selection, selectionArgs, null);
                    Intrinsics.checkNotNull((Object)cursor2);
                    int column_index = cursor2.getColumnIndexOrThrow("_data");
                    if (cursor.moveToFirst()) {
                        return cursor.getString(column_index);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (StringsKt.equals((String)"file", (String)uri3.getScheme(), (boolean)true)) {
                return uri3.getPath();
            }
            return null;
        }

        public final boolean isExternalStorageDocument(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return Intrinsics.areEqual((Object)"com.android.externalstorage.documents", (Object)uri.getAuthority());
        }

        public final boolean isDownloadsDocument(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
        }

        public final boolean isMediaDocument(@NotNull Uri uri) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

