/*
 * Decompiled with CFR 0.152.
 */
package com.potyvideo.library;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.potyvideo.library.AndExoPlayerRoot;
import com.potyvideo.library.R;
import com.potyvideo.library.globalEnums.EnumAspectRatio;
import com.potyvideo.library.globalEnums.EnumMute;
import com.potyvideo.library.globalEnums.EnumRepeatMode;
import com.potyvideo.library.globalEnums.EnumResizeMode;
import com.potyvideo.library.globalEnums.EnumScreenMode;
import com.potyvideo.library.globalInterfaces.AndExoPlayerListener;
import com.potyvideo.library.utils.DoubleClick;
import com.potyvideo.library.utils.DoubleClickListener;
import com.potyvideo.library.utils.PublicFunctions;
import com.potyvideo.library.utils.PublicValues;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J4\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\"\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0!j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\"H\u0002J4\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\"\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0!j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\"H\u0002J4\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\"\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0!j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\"H\u0002J4\u0010%\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\"\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0!j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\"H\u0002J4\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\"\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0!j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\"H\u0002J\u0012\u0010'\u001a\u00020(2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010)\u001a\u0004\u0018\u00010*J\u0006\u0010+\u001a\u00020\u001aJ\u0006\u0010,\u001a\u00020(J\b\u0010-\u001a\u00020(H\u0014J\u0012\u0010.\u001a\u00020(2\b\u0010/\u001a\u0004\u0018\u000100H\u0014J\b\u00101\u001a\u00020(H\u0014J\u0010\u00102\u001a\u00020(2\u0006\u00103\u001a\u00020\u000bH\u0016J\u0010\u00104\u001a\u00020(2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020(2\u0006\u00108\u001a\u000209H\u0016J\u0018\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u0011H\u0016J\u0010\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020\u0011H\u0016J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020\u0011H\u0016J\u0018\u0010A\u001a\u00020(2\u0006\u0010B\u001a\u00020C2\u0006\u0010>\u001a\u00020\u0011H\u0016J\u0006\u0010D\u001a\u00020(J\u0006\u0010E\u001a\u00020(J\b\u0010F\u001a\u00020(H\u0002J\u0010\u0010G\u001a\u00020(2\b\b\u0002\u0010H\u001a\u00020\u0011J\u0010\u0010I\u001a\u00020(2\b\b\u0002\u0010J\u001a\u00020\u0011J\u000e\u0010K\u001a\u00020(2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010L\u001a\u00020(2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020(2\u0006\u0010P\u001a\u00020QJ\u0010\u0010R\u001a\u00020(2\b\b\u0002\u0010;\u001a\u00020\u000bJ\u0010\u0010S\u001a\u00020(2\b\b\u0002\u0010@\u001a\u00020TJ\u000e\u0010U\u001a\u00020(2\u0006\u0010V\u001a\u00020WJ\u0010\u0010X\u001a\u00020(2\b\b\u0002\u0010Y\u001a\u00020ZJ\u0010\u0010[\u001a\u00020(2\b\b\u0002\u0010\\\u001a\u00020\u000bJ\u000e\u0010]\u001a\u00020(2\u0006\u0010^\u001a\u00020\u0011J4\u0010_\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020\r2$\b\u0002\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0!j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r`\"J\u0006\u0010`\u001a\u00020(J\u0006\u0010a\u001a\u00020(J\u0006\u0010b\u001a\u00020(R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/potyvideo/library/AndExoPlayerView;", "Lcom/potyvideo/library/AndExoPlayerRoot;", "Lcom/google/android/exoplayer2/Player$Listener;", "context", "Landroid/content/Context;", "attributeSet", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "andExoPlayerListener", "Lcom/potyvideo/library/globalInterfaces/AndExoPlayerListener;", "currPlayWhenReady", "", "currSource", "", "currVolume", "", "currentWindow", "", "value", "Lcom/potyvideo/library/utils/DoubleClick;", "customClickListener", "getCustomClickListener", "()Lcom/potyvideo/library/utils/DoubleClick;", "setCustomClickListener", "(Lcom/potyvideo/library/utils/DoubleClick;)V", "playbackPosition", "", "player", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "buildMediaDash", "Lcom/google/android/exoplayer2/MediaItem;", "source", "extraHeaders", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "buildMediaGlobal", "buildMediaHLS", "buildMediaItem", "buildMediaItemMP4", "extractAttrs", "", "getActivity", "Landroid/app/Activity;", "getCurrentPlayerPosition", "mutePlayer", "onAttachedToWindow", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onDetachedFromWindow", "onLoadingChanged", "isLoading", "onPlaybackParametersChanged", "playbackParameters", "Lcom/google/android/exoplayer2/PlaybackParameters;", "onPlayerError", "error", "Lcom/google/android/exoplayer2/PlaybackException;", "onPlayerStateChanged", "playWhenReady", "playbackState", "onPositionDiscontinuity", "reason", "onRepeatModeChanged", "repeatMode", "onTimelineChanged", "timeline", "Lcom/google/android/exoplayer2/Timeline;", "pausePlayer", "releasePlayer", "restartPlayer", "seekBackward", "backwardValue", "seekForward", "ForwardValue", "setAndExoPlayerListener", "setAspectRatio", "aspectRatio", "Lcom/potyvideo/library/globalEnums/EnumAspectRatio;", "setMute", "mute", "Lcom/potyvideo/library/globalEnums/EnumMute;", "setPlayWhenReady", "setRepeatMode", "Lcom/potyvideo/library/globalEnums/EnumRepeatMode;", "setResizeMode", "resizeMode", "Lcom/potyvideo/library/globalEnums/EnumResizeMode;", "setScreenMode", "screenMode", "Lcom/potyvideo/library/globalEnums/EnumScreenMode;", "setShowControllers", "showControllers", "setShowTimeOut", "showTimeoutMs", "setSource", "startPlayer", "stopPlayer", "unMutePlayer", "library_release"})
public final class AndExoPlayerView
extends AndExoPlayerRoot
implements Player.Listener {
    private String currSource;
    @NotNull
    private SimpleExoPlayer player;
    @Nullable
    private AndExoPlayerListener andExoPlayerListener;
    private boolean currPlayWhenReady;
    private long playbackPosition;
    private int currentWindow;
    private float currVolume;

    public AndExoPlayerView(@NotNull Context context, @NotNull AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributeSet, (String)"attributeSet");
        super(context, attributeSet, 0, 4, null);
        SimpleExoPlayer simpleExoPlayer = new SimpleExoPlayer.Builder(context).build();
        Intrinsics.checkNotNullExpressionValue((Object)simpleExoPlayer, (String)"Builder(context).build()");
        this.player = simpleExoPlayer;
        this.currPlayWhenReady = true;
        this.player.addListener((Player.Listener)this);
        this.extractAttrs(attributeSet);
    }

    @Override
    @NotNull
    public DoubleClick getCustomClickListener() {
        return new DoubleClick(new DoubleClickListener(this){
            final /* synthetic */ AndExoPlayerView this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSingleClickEvent(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                int n = view.getId();
                if (n == this.this$0.getRetryButton().getId()) {
                    this.this$0.hideRetryView();
                    AndExoPlayerView.access$restartPlayer(this.this$0);
                } else if (n == this.this$0.getMute().getId()) {
                    this.this$0.unMutePlayer();
                } else if (n == this.this$0.getUnMute().getId()) {
                    this.this$0.mutePlayer();
                } else if (n == this.this$0.getEnterFullScreen().getId()) {
                    this.this$0.setScreenMode(EnumScreenMode.FULLSCREEN);
                } else if (n == this.this$0.getExitFullScreen().getId()) {
                    this.this$0.setScreenMode(EnumScreenMode.MINIMISE);
                }
            }

            public void onDoubleClickEvent(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                int n = view.getId();
                if (n == this.this$0.getBackwardView().getId()) {
                    AndExoPlayerView.seekBackward$default(this.this$0, 0, 1, null);
                } else if (n == this.this$0.getForwardView().getId()) {
                    AndExoPlayerView.seekForward$default(this.this$0, 0, 1, null);
                }
            }
        }, 0L, 2, null);
    }

    @Override
    public void setCustomClickListener(@NotNull DoubleClick value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
    }

    private final void extractAttrs(AttributeSet attributeSet) {
        AttributeSet it = attributeSet;
        boolean bl = false;
        TypedArray typedArray = this.getContext().obtainStyledAttributes(it, R.styleable.AndExoPlayerView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026yleable.AndExoPlayerView)");
        TypedArray typedArray2 = typedArray;
        if (typedArray2.hasValue(R.styleable.AndExoPlayerView_andexo_aspect_ratio)) {
            int aspectRatio = typedArray2.getInteger(R.styleable.AndExoPlayerView_andexo_aspect_ratio, EnumAspectRatio.ASPECT_16_9.getValue());
            this.setAspectRatio(EnumAspectRatio.Companion.get(aspectRatio));
        }
        if (typedArray2.hasValue(R.styleable.AndExoPlayerView_andexo_resize_mode)) {
            int resizeMode = typedArray2.getInteger(R.styleable.AndExoPlayerView_andexo_resize_mode, EnumResizeMode.FILL.getValue());
            this.setResizeMode(EnumResizeMode.Companion.get(resizeMode));
        }
        if (typedArray2.hasValue(R.styleable.AndExoPlayerView_andexo_play_when_ready)) {
            this.setPlayWhenReady(typedArray2.getBoolean(R.styleable.AndExoPlayerView_andexo_play_when_ready, true));
        }
        if (typedArray2.hasValue(R.styleable.AndExoPlayerView_andexo_mute)) {
            int muteValue = typedArray2.getInteger(R.styleable.AndExoPlayerView_andexo_mute, EnumMute.UNMUTE.getValue());
            this.setMute(EnumMute.Companion.get(muteValue));
        }
        if (typedArray2.hasValue(R.styleable.AndExoPlayerView_andexo_show_controller)) {
            this.setShowControllers(typedArray2.getBoolean(R.styleable.AndExoPlayerView_andexo_show_controller, true));
        }
        if (typedArray2.hasValue(R.styleable.AndExoPlayerView_andexo_show_full_screen)) {
            this.setShowFullScreenButton(typedArray2.getBoolean(R.styleable.AndExoPlayerView_andexo_show_full_screen, true));
        }
        typedArray2.recycle();
    }

    public void onPlaybackParametersChanged(@NotNull PlaybackParameters playbackParameters) {
        Intrinsics.checkNotNullParameter((Object)playbackParameters, (String)"playbackParameters");
    }

    public void onPlayerError(@NotNull PlaybackException error) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.showRetryView(error.getMessage());
            AndExoPlayerListener andExoPlayerListener = this.andExoPlayerListener;
            if (andExoPlayerListener == null) break block0;
            AndExoPlayerListener it = andExoPlayerListener;
            boolean bl = false;
            AndExoPlayerListener andExoPlayerListener2 = this.andExoPlayerListener;
            Intrinsics.checkNotNull((Object)andExoPlayerListener2);
            andExoPlayerListener2.onExoPlayerError(error.getMessage());
        }
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        switch (playbackState) {
            case 2: {
                AndExoPlayerListener andExoPlayerListener = this.andExoPlayerListener;
                if (andExoPlayerListener != null) {
                    andExoPlayerListener.onExoBuffering();
                }
                break;
            }
            case 4: {
                AndExoPlayerListener andExoPlayerListener = this.andExoPlayerListener;
                if (andExoPlayerListener != null) {
                    andExoPlayerListener.onExoEnded();
                }
                break;
            }
            case 1: {
                AndExoPlayerListener andExoPlayerListener = this.andExoPlayerListener;
                if (andExoPlayerListener != null) {
                    andExoPlayerListener.onExoIdle();
                }
                break;
            }
            case 3: {
                AndExoPlayerListener andExoPlayerListener = this.andExoPlayerListener;
                if (andExoPlayerListener == null) break;
                andExoPlayerListener.onExoReady();
                break;
            }
        }
    }

    public void onLoadingChanged(boolean isLoading) {
    }

    public void onPositionDiscontinuity(int reason) {
    }

    public void onRepeatModeChanged(int repeatMode) {
    }

    public void onTimelineChanged(@NotNull Timeline timeline, int reason) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
    }

    public final void releasePlayer() {
        this.currPlayWhenReady = this.player.getPlayWhenReady();
        this.playbackPosition = this.player.getCurrentPosition();
        this.currentWindow = this.player.getCurrentWindowIndex();
        this.player.stop();
        this.player.release();
    }

    private final void restartPlayer() {
        this.player.seekTo(0L);
        this.player.prepare();
    }

    private final MediaItem buildMediaItem(String source, HashMap<String, String> extraHeaders) {
        String string = PublicFunctions.Companion.getMimeTypeV2(source);
        return Intrinsics.areEqual((Object)string, (Object)PublicValues.Companion.getKEY_MP4()) ? this.buildMediaItemMP4(source, extraHeaders) : (Intrinsics.areEqual((Object)string, (Object)PublicValues.Companion.getKEY_M3U8()) ? this.buildMediaHLS(source, extraHeaders) : (Intrinsics.areEqual((Object)string, (Object)PublicValues.Companion.getKEY_MP3()) ? this.buildMediaItemMP4(source, extraHeaders) : this.buildMediaGlobal(source, extraHeaders)));
    }

    private final MediaItem buildMediaItemMP4(String source, HashMap<String, String> extraHeaders) {
        MediaItem mediaItem = new MediaItem.Builder().setUri(source).setMimeType("application/mp4").setDrmLicenseRequestHeaders((Map)extraHeaders).build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"Builder()\n            .s\u2026ers)\n            .build()");
        return mediaItem;
    }

    private final MediaItem buildMediaHLS(String source, HashMap<String, String> extraHeaders) {
        MediaItem mediaItem = new MediaItem.Builder().setUri(source).setMimeType("application/x-mpegURL").setDrmLicenseRequestHeaders((Map)extraHeaders).build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"Builder()\n            .s\u2026ers)\n            .build()");
        return mediaItem;
    }

    private final MediaItem buildMediaDash(String source, HashMap<String, String> extraHeaders) {
        MediaItem mediaItem = new MediaItem.Builder().setUri(source).setMimeType("application/dash+xml").setDrmLicenseRequestHeaders((Map)extraHeaders).build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"Builder()\n            .s\u2026ers)\n            .build()");
        return mediaItem;
    }

    private final MediaItem buildMediaGlobal(String source, HashMap<String, String> extraHeaders) {
        MediaItem mediaItem = new MediaItem.Builder().setUri(source).setDrmLicenseRequestHeaders((Map)extraHeaders).build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaItem, (String)"Builder()\n            .s\u2026ers)\n            .build()");
        return mediaItem;
    }

    public final void setAndExoPlayerListener(@NotNull AndExoPlayerListener andExoPlayerListener) {
        Intrinsics.checkNotNullParameter((Object)andExoPlayerListener, (String)"andExoPlayerListener");
        this.andExoPlayerListener = andExoPlayerListener;
    }

    public final void setSource(@NotNull String source, @NotNull HashMap<String, String> extraHeaders) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(extraHeaders, (String)"extraHeaders");
        this.currSource = source;
        MediaItem mediaItem = this.buildMediaItem(source, extraHeaders);
        this.getPlayerView().setPlayer((Player)this.player);
        this.player.setPlayWhenReady(this.currPlayWhenReady);
        this.player.setMediaItem(mediaItem);
        this.player.prepare();
    }

    public static /* synthetic */ void setSource$default(AndExoPlayerView andExoPlayerView, String string, HashMap hashMap, int n, Object object) {
        if ((n & 2) != 0) {
            hashMap = new HashMap<String, String>();
        }
        andExoPlayerView.setSource(string, hashMap);
    }

    public final void seekBackward(int backwardValue) {
        long seekValue = this.player.getCurrentPosition() - (long)backwardValue;
        if (seekValue < 0L) {
            seekValue = 0L;
        }
        this.player.seekTo(seekValue);
    }

    public static /* synthetic */ void seekBackward$default(AndExoPlayerView andExoPlayerView, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10000;
        }
        andExoPlayerView.seekBackward(n);
    }

    public final void seekForward(int ForwardValue) {
        long seekValue = this.player.getCurrentPosition() + (long)ForwardValue;
        if (seekValue > this.player.getDuration()) {
            seekValue = this.player.getDuration();
        }
        this.player.seekTo(seekValue);
    }

    public static /* synthetic */ void seekForward$default(AndExoPlayerView andExoPlayerView, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10000;
        }
        andExoPlayerView.seekForward(n);
    }

    public final void setShowControllers(boolean showControllers) {
        if (showControllers) {
            this.setShowTimeOut(4000);
        } else {
            this.setShowTimeOut(0);
        }
    }

    public static /* synthetic */ void setShowControllers$default(AndExoPlayerView andExoPlayerView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        andExoPlayerView.setShowControllers(bl);
    }

    public final void setShowTimeOut(int showTimeoutMs) {
        this.getPlayerView().setControllerShowTimeoutMs(showTimeoutMs);
        if (showTimeoutMs == 0) {
            this.getPlayerView().setControllerHideOnTouch(false);
        }
    }

    public final void setMute(@NotNull EnumMute mute) {
        Intrinsics.checkNotNullParameter((Object)((Object)mute), (String)"mute");
        switch (WhenMappings.$EnumSwitchMapping$0[mute.ordinal()]) {
            case 1: {
                this.mutePlayer();
                break;
            }
            case 2: {
                this.unMutePlayer();
                break;
            }
            default: {
                this.unMutePlayer();
            }
        }
    }

    public final void mutePlayer() {
        this.currVolume = this.player.getVolume();
        this.player.setVolume(0.0f);
        this.showMuteButton();
    }

    public final void unMutePlayer() {
        this.player.setVolume(this.currVolume);
        this.showUnMuteButton();
    }

    public final void setRepeatMode(@NotNull EnumRepeatMode repeatMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)repeatMode), (String)"repeatMode");
        this.setCurrRepeatMode(repeatMode);
        switch (WhenMappings.$EnumSwitchMapping$1[repeatMode.ordinal()]) {
            case 1: {
                this.player.setRepeatMode(0);
                break;
            }
            case 2: {
                this.player.setRepeatMode(1);
                break;
            }
            case 3: {
                this.player.setRepeatMode(2);
                break;
            }
            default: {
                this.player.setRepeatMode(0);
            }
        }
    }

    public static /* synthetic */ void setRepeatMode$default(AndExoPlayerView andExoPlayerView, EnumRepeatMode enumRepeatMode, int n, Object object) {
        if ((n & 1) != 0) {
            enumRepeatMode = EnumRepeatMode.REPEAT_OFF;
        }
        andExoPlayerView.setRepeatMode(enumRepeatMode);
    }

    public final void setAspectRatio(@NotNull EnumAspectRatio aspectRatio) {
        Intrinsics.checkNotNullParameter((Object)((Object)aspectRatio), (String)"aspectRatio");
        this.setCurrAspectRatio(aspectRatio);
        int value = PublicFunctions.Companion.getScreenWidth();
        switch (WhenMappings.$EnumSwitchMapping$2[aspectRatio.ordinal()]) {
            case 1: {
                this.getPlayerView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(value, value));
                break;
            }
            case 2: {
                this.getPlayerView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(value, 3 * value / 4));
                break;
            }
            case 3: {
                this.getPlayerView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(value, 9 * value / 16));
                break;
            }
            case 4: {
                this.getPlayerView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                break;
            }
            case 5: {
                this.getPlayerView().setControllerShowTimeoutMs(0);
                this.getPlayerView().setControllerHideOnTouch(false);
                int mp3Height = this.getContext().getResources().getDimensionPixelSize(R.dimen.player_controller_base_height);
                this.getPlayerView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, mp3Height));
                break;
            }
            case 6: {
                int baseHeight = (int)this.getResources().getDimension(R.dimen.player_base_height);
                this.getPlayerView().setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, baseHeight));
            }
        }
    }

    public final void setResizeMode(@NotNull EnumResizeMode resizeMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)resizeMode), (String)"resizeMode");
        switch (WhenMappings.$EnumSwitchMapping$3[resizeMode.ordinal()]) {
            case 1: {
                this.getPlayerView().setResizeMode(0);
                break;
            }
            case 2: {
                this.getPlayerView().setResizeMode(3);
                break;
            }
            case 3: {
                this.getPlayerView().setResizeMode(4);
                break;
            }
            default: {
                this.getPlayerView().setResizeMode(0);
            }
        }
    }

    public final void setPlayWhenReady(boolean playWhenReady) {
        this.currPlayWhenReady = playWhenReady;
        this.player.setPlayWhenReady(playWhenReady);
    }

    public static /* synthetic */ void setPlayWhenReady$default(AndExoPlayerView andExoPlayerView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        andExoPlayerView.setPlayWhenReady(bl);
    }

    public final void pausePlayer() {
        this.player.setPlayWhenReady(false);
        this.player.getPlaybackState();
    }

    public final void stopPlayer() {
        this.player.stop();
        this.player.getPlaybackState();
    }

    public final void startPlayer() {
        this.player.setPlayWhenReady(true);
        this.player.getPlaybackState();
    }

    public final void setScreenMode(@NotNull EnumScreenMode screenMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)screenMode), (String)"screenMode");
        switch (WhenMappings.$EnumSwitchMapping$4[screenMode.ordinal()]) {
            case 1: {
                Activity activity = this.getActivity();
                if (activity == null) break;
                activity.setRequestedOrientation(0);
                break;
            }
            case 2: {
                Activity activity = this.getActivity();
                if (activity == null) break;
                activity.setRequestedOrientation(1);
                break;
            }
            default: {
                Activity activity = this.getActivity();
                if (activity == null) break;
                activity.setRequestedOrientation(1);
            }
        }
        this.setCurrScreenMode(screenMode);
        this.setShowScreenModeButton(this.getCurrScreenMode());
    }

    public static /* synthetic */ void setScreenMode$default(AndExoPlayerView andExoPlayerView, EnumScreenMode enumScreenMode, int n, Object object) {
        if ((n & 1) != 0) {
            enumScreenMode = EnumScreenMode.MINIMISE;
        }
        andExoPlayerView.setScreenMode(enumScreenMode);
    }

    public final long getCurrentPlayerPosition() {
        long currentPosition = 0L;
        if (this.player.isPlaying()) {
            currentPosition = this.player.getCurrentPosition();
        }
        return currentPosition;
    }

    @Nullable
    public final Activity getActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.releasePlayer();
    }

    protected void onConfigurationChanged(@Nullable Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Configuration configuration = newConfig;
        Intrinsics.checkNotNull((Object)configuration);
        if (configuration.orientation == 2) {
            this.hideSystemUI();
            ViewGroup.LayoutParams layoutParams = this.getPlayerView().getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)layoutParams;
            params.width = -1;
            params.height = -1;
            this.getPlayerView().setLayoutParams((ViewGroup.LayoutParams)params);
        } else if (newConfig.orientation == 1) {
            this.showSystemUI();
            this.setAspectRatio(this.getCurrAspectRatio());
        }
    }

    public static final /* synthetic */ void access$restartPlayer(AndExoPlayerView $this) {
        $this.restartPlayer();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;
        public static final /* synthetic */ int[] $EnumSwitchMapping$4;

        static {
            int[] nArray = new int[EnumMute.values().length];
            nArray[EnumMute.MUTE.ordinal()] = 1;
            nArray[EnumMute.UNMUTE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EnumRepeatMode.values().length];
            nArray[EnumRepeatMode.REPEAT_OFF.ordinal()] = 1;
            nArray[EnumRepeatMode.REPEAT_ONE.ordinal()] = 2;
            nArray[EnumRepeatMode.REPEAT_ALWAYS.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[EnumAspectRatio.values().length];
            nArray[EnumAspectRatio.ASPECT_1_1.ordinal()] = 1;
            nArray[EnumAspectRatio.ASPECT_4_3.ordinal()] = 2;
            nArray[EnumAspectRatio.ASPECT_16_9.ordinal()] = 3;
            nArray[EnumAspectRatio.ASPECT_MATCH.ordinal()] = 4;
            nArray[EnumAspectRatio.ASPECT_MP3.ordinal()] = 5;
            nArray[EnumAspectRatio.UNDEFINE.ordinal()] = 6;
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[EnumResizeMode.values().length];
            nArray[EnumResizeMode.FIT.ordinal()] = 1;
            nArray[EnumResizeMode.FILL.ordinal()] = 2;
            nArray[EnumResizeMode.ZOOM.ordinal()] = 3;
            $EnumSwitchMapping$3 = nArray;
            nArray = new int[EnumScreenMode.values().length];
            nArray[EnumScreenMode.FULLSCREEN.ordinal()] = 1;
            nArray[EnumScreenMode.MINIMISE.ordinal()] = 2;
            $EnumSwitchMapping$4 = nArray;
        }
    }
}

