/*
 * Decompiled with CFR 0.152.
 */
package at.huber.youtubeExtractor;

public class Format {
    private int itag;
    private String ext;
    private int height;
    private int fps;
    private VCodec vCodec;
    private ACodec aCodec;
    private int audioBitrate;
    private boolean isDashContainer;
    private boolean isHlsContent;

    Format(int itag, String ext, int height, VCodec vCodec, ACodec aCodec, boolean isDashContainer) {
        this.itag = itag;
        this.ext = ext;
        this.height = height;
        this.fps = 30;
        this.audioBitrate = -1;
        this.isDashContainer = isDashContainer;
        this.isHlsContent = false;
    }

    Format(int itag, String ext, VCodec vCodec, ACodec aCodec, int audioBitrate, boolean isDashContainer) {
        this.itag = itag;
        this.ext = ext;
        this.height = -1;
        this.fps = 30;
        this.audioBitrate = audioBitrate;
        this.isDashContainer = isDashContainer;
        this.isHlsContent = false;
    }

    Format(int itag, String ext, int height, VCodec vCodec, ACodec aCodec, int audioBitrate, boolean isDashContainer) {
        this.itag = itag;
        this.ext = ext;
        this.height = height;
        this.fps = 30;
        this.audioBitrate = audioBitrate;
        this.isDashContainer = isDashContainer;
        this.isHlsContent = false;
    }

    Format(int itag, String ext, int height, VCodec vCodec, ACodec aCodec, int audioBitrate, boolean isDashContainer, boolean isHlsContent) {
        this.itag = itag;
        this.ext = ext;
        this.height = height;
        this.fps = 30;
        this.audioBitrate = audioBitrate;
        this.isDashContainer = isDashContainer;
        this.isHlsContent = isHlsContent;
    }

    Format(int itag, String ext, int height, VCodec vCodec, int fps, ACodec aCodec, boolean isDashContainer) {
        this.itag = itag;
        this.ext = ext;
        this.height = height;
        this.audioBitrate = -1;
        this.fps = fps;
        this.isDashContainer = isDashContainer;
        this.isHlsContent = false;
    }

    public int getFps() {
        return this.fps;
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public int getItag() {
        return this.itag;
    }

    public String getExt() {
        return this.ext;
    }

    public boolean isDashContainer() {
        return this.isDashContainer;
    }

    public ACodec getAudioCodec() {
        return this.aCodec;
    }

    public VCodec getVideoCodec() {
        return this.vCodec;
    }

    public boolean isHlsContent() {
        return this.isHlsContent;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Format format = (Format)o;
        if (this.itag != format.itag) {
            return false;
        }
        if (this.height != format.height) {
            return false;
        }
        if (this.fps != format.fps) {
            return false;
        }
        if (this.audioBitrate != format.audioBitrate) {
            return false;
        }
        if (this.isDashContainer != format.isDashContainer) {
            return false;
        }
        if (this.isHlsContent != format.isHlsContent) {
            return false;
        }
        if (this.ext != null ? !this.ext.equals(format.ext) : format.ext != null) {
            return false;
        }
        if (this.vCodec != format.vCodec) {
            return false;
        }
        return this.aCodec == format.aCodec;
    }

    public int hashCode() {
        int result = this.itag;
        result = 31 * result + (this.ext != null ? this.ext.hashCode() : 0);
        result = 31 * result + this.height;
        result = 31 * result + this.fps;
        result = 31 * result + (this.vCodec != null ? this.vCodec.hashCode() : 0);
        result = 31 * result + (this.aCodec != null ? this.aCodec.hashCode() : 0);
        result = 31 * result + this.audioBitrate;
        result = 31 * result + (this.isDashContainer ? 1 : 0);
        result = 31 * result + (this.isHlsContent ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Format{itag=" + this.itag + ", ext='" + this.ext + '\'' + ", height=" + this.height + ", fps=" + this.fps + ", vCodec=" + (Object)((Object)this.vCodec) + ", aCodec=" + (Object)((Object)this.aCodec) + ", audioBitrate=" + this.audioBitrate + ", isDashContainer=" + this.isDashContainer + ", isHlsContent=" + this.isHlsContent + '}';
    }

    public static enum ACodec {
        MP3,
        AAC,
        VORBIS,
        OPUS,
        NONE;

    }

    public static enum VCodec {
        H263,
        H264,
        MPEG4,
        VP8,
        VP9,
        NONE;

    }
}

