/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import java.util.Timer;
import java.util.TimerTask;

public abstract class Countdown
extends Timer {
    private long totalTime;
    private long interval;
    private long delay;
    private TimerTask task;
    private long startTime = -1L;
    private boolean restart = false;
    private boolean wasCancelled = false;
    private boolean wasStarted = false;

    public Countdown(long totalTime, long interval) {
        this(totalTime, interval, 0L);
    }

    public Countdown(long totalTime, long interval, long delay) {
        super("PreciseCountdown", true);
        this.delay = delay;
        this.interval = interval;
        this.totalTime = totalTime;
        this.task = this.getTask(totalTime);
    }

    public void start() {
        this.wasStarted = true;
        this.schedule(this.task, this.delay, this.interval);
    }

    public void stop() {
        this.onStopCalled();
        this.wasCancelled = true;
        this.task.cancel();
        this.dispose();
    }

    public void dispose() {
        this.cancel();
        this.purge();
    }

    private TimerTask getTask(final long totalTime) {
        return new TimerTask(){

            @Override
            public void run() {
                long timeLeft;
                if (Countdown.this.startTime < 0L || Countdown.this.restart) {
                    Countdown.this.startTime = this.scheduledExecutionTime();
                    timeLeft = totalTime;
                    Countdown.this.restart = false;
                } else {
                    timeLeft = totalTime - (this.scheduledExecutionTime() - Countdown.this.startTime);
                    if (timeLeft <= 0L) {
                        this.cancel();
                        Countdown.this.startTime = -1L;
                        Countdown.this.onFinished();
                        return;
                    }
                }
                Countdown.this.onTick(timeLeft);
            }
        };
    }

    public abstract void onTick(long var1);

    public abstract void onFinished();

    public abstract void onStopCalled();
}

