/*
 * Decompiled with CFR 0.152.
 */
package com.hbisoft.hbrecorder;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Icon;
import android.hardware.display.VirtualDisplay;
import android.media.MediaRecorder;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.util.Log;
import androidx.annotation.RequiresApi;
import com.hbisoft.hbrecorder.NotificationReceiver;
import com.hbisoft.hbrecorder.R;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Objects;

public class ScreenRecordService
extends Service {
    private static final String TAG = "ScreenRecordService";
    private int mScreenWidth;
    private int mScreenHeight;
    private int mScreenDensity;
    private int mResultCode;
    private Intent mResultData;
    private boolean isVideoHD;
    private boolean isAudioEnabled;
    private String path;
    private MediaProjection mMediaProjection;
    private MediaRecorder mMediaRecorder;
    private VirtualDisplay mVirtualDisplay;
    private String name;
    private int audioBitrate;
    private int audioSamplingRate;
    private static String filePath;
    private static String fileName;
    private String audioSource;
    private int audioSourceAsInt;
    private String videoEncoder;
    private int videoEncoderAsInt;
    private boolean isCustomSettingsEnabled;
    private int videoFrameRate;
    private int videoBitrate;
    private String outputFormat;
    private int outputFormatAsInt;
    public static final String BUNDLED_LISTENER = "listener";

    @RequiresApi(api=21)
    public int onStartCommand(Intent intent, int flags, int startId) {
        byte[] notificationSmallIcon = intent.getByteArrayExtra("notificationSmallBitmap");
        String notificationTitle = intent.getStringExtra("notificationTitle");
        String notificationDescription = intent.getStringExtra("notificationDescription");
        boolean shouldShowNotification = intent.getBooleanExtra("shouldShowNotification", true);
        String notificationButtonText = intent.getStringExtra("notificationButtonText");
        this.mResultCode = intent.getIntExtra("code", -1);
        this.mResultData = (Intent)intent.getParcelableExtra("data");
        this.mScreenWidth = intent.getIntExtra("width", 720);
        this.mScreenHeight = intent.getIntExtra("height", 1280);
        this.mScreenDensity = intent.getIntExtra("density", 1);
        this.isVideoHD = intent.getBooleanExtra("quality", true);
        this.isAudioEnabled = intent.getBooleanExtra("audio", true);
        this.path = intent.getStringExtra("path");
        this.name = intent.getStringExtra("fileName");
        this.audioSource = intent.getStringExtra("audioSource");
        this.videoEncoder = intent.getStringExtra("videoEncoder");
        this.videoFrameRate = intent.getIntExtra("videoFrameRate", 30);
        this.videoBitrate = intent.getIntExtra("videoBitrate", 40000000);
        this.setAudioSourceAsInt(this.audioSource);
        this.setvideoEncoderAsInt(this.videoEncoder);
        filePath = this.name;
        this.audioBitrate = intent.getIntExtra("audioBitrate", 128000);
        this.audioSamplingRate = intent.getIntExtra("audioSamplingRate", 44100);
        this.outputFormat = intent.getStringExtra("outputFormat");
        this.setOutputformatAsInt(this.outputFormat);
        this.isCustomSettingsEnabled = intent.getBooleanExtra("enableCustomSettings", false);
        if (notificationButtonText == null) {
            notificationButtonText = "STOP RECORDING";
        }
        if (this.audioBitrate == 0) {
            this.audioBitrate = 128000;
        }
        if (this.audioSamplingRate == 0) {
            this.audioSamplingRate = 44100;
        }
        if (notificationTitle == null || notificationTitle.equals("")) {
            notificationTitle = "Recording your screen";
        }
        if (notificationDescription == null || notificationDescription.equals("")) {
            notificationDescription = "Drag down to stop the recording";
        }
        if (shouldShowNotification) {
            if (Build.VERSION.SDK_INT >= 26) {
                String channelId = "001";
                String channelName = "RecordChannel";
                NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 0);
                channel.setLightColor(-16776961);
                channel.setLockscreenVisibility(0);
                NotificationManager manager = (NotificationManager)this.getSystemService("notification");
                if (manager != null) {
                    Notification notification;
                    manager.createNotificationChannel(channel);
                    Intent myIntent = new Intent((Context)this, NotificationReceiver.class);
                    PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)myIntent, (int)0);
                    Notification.Action action = new Notification.Action.Builder(Icon.createWithResource((Context)this, (int)17301678), (CharSequence)notificationButtonText, pendingIntent).build();
                    if (notificationSmallIcon != null) {
                        Bitmap bmp = BitmapFactory.decodeByteArray((byte[])notificationSmallIcon, (int)0, (int)notificationSmallIcon.length);
                        notification = new Notification.Builder(this.getApplicationContext(), channelId).setOngoing(true).setSmallIcon(Icon.createWithBitmap((Bitmap)bmp)).setContentTitle((CharSequence)notificationTitle).setContentText((CharSequence)notificationDescription).addAction(action).build();
                    } else {
                        notification = new Notification.Builder(this.getApplicationContext(), channelId).setOngoing(true).setSmallIcon(R.drawable.icon).setContentTitle((CharSequence)notificationTitle).setContentText((CharSequence)notificationDescription).addAction(action).build();
                    }
                    this.startForeground(101, notification);
                }
            } else {
                this.startForeground(101, new Notification());
            }
        }
        if (this.path == null) {
            this.path = String.valueOf(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_MOVIES));
        }
        this.mMediaProjection = this.createMediaProjection();
        this.mMediaRecorder = this.createMediaRecorder();
        this.mVirtualDisplay = this.createVirtualDisplay();
        this.mMediaRecorder.setOnErrorListener(new MediaRecorder.OnErrorListener(){

            public void onError(MediaRecorder mediaRecorder, int i, int i1) {
                Log.e((String)"ERROR", (String)"WAS CALLED");
            }
        });
        try {
            this.mMediaRecorder.start();
        }
        catch (IllegalStateException e) {
            ResultReceiver receiver = (ResultReceiver)intent.getParcelableExtra(BUNDLED_LISTENER);
            Bundle bundle = new Bundle();
            bundle.putString("error", "38");
            receiver.send(-1, bundle);
        }
        return 1;
    }

    private void setOutputformatAsInt(String outputFormat) {
        switch (outputFormat) {
            case "DEFAULT": {
                this.outputFormatAsInt = 0;
                break;
            }
            case "THREE_GPP": {
                this.outputFormatAsInt = 1;
                break;
            }
            case "MPEG_4": {
                this.outputFormatAsInt = 2;
                break;
            }
            case "AMR_NB": {
                this.outputFormatAsInt = 3;
                break;
            }
            case "AMR_WB": {
                this.outputFormatAsInt = 4;
                break;
            }
            case "AAC_ADTS": {
                this.outputFormatAsInt = 6;
                break;
            }
            case "MPEG_2_TS": {
                this.outputFormatAsInt = 8;
                break;
            }
            case "WEBM": {
                this.outputFormatAsInt = 9;
                break;
            }
            case "OGG": {
                this.outputFormatAsInt = 11;
                break;
            }
            default: {
                this.outputFormatAsInt = 2;
            }
        }
    }

    private void setvideoEncoderAsInt(String encoder) {
        switch (encoder) {
            case "DEFAULT": {
                this.videoEncoderAsInt = 0;
                break;
            }
            case "H263": {
                this.videoEncoderAsInt = 1;
                break;
            }
            case "H264": {
                this.videoEncoderAsInt = 2;
                break;
            }
            case "MPEG_4_SP": {
                this.videoEncoderAsInt = 3;
                break;
            }
            case "VP8": {
                this.videoEncoderAsInt = 4;
                break;
            }
            case "HEVC": {
                this.videoEncoderAsInt = 5;
            }
        }
    }

    private void setAudioSourceAsInt(String audioSource) {
        switch (audioSource) {
            case "DEFAULT": {
                this.audioSourceAsInt = 0;
                break;
            }
            case "MIC": {
                this.audioSourceAsInt = 1;
                break;
            }
            case "VOICE_UPLINK": {
                this.audioSourceAsInt = 2;
                break;
            }
            case "VOICE_DOWNLINK": {
                this.audioSourceAsInt = 3;
                break;
            }
            case "VOICE_CALL": {
                this.audioSourceAsInt = 4;
                break;
            }
            case "CAMCODER": {
                this.audioSourceAsInt = 5;
                break;
            }
            case "VOICE_RECOGNITION": {
                this.audioSourceAsInt = 6;
                break;
            }
            case "VOICE_COMMUNICATION": {
                this.audioSourceAsInt = 7;
                break;
            }
            case "REMOTE_SUBMIX": {
                this.audioSourceAsInt = 8;
                break;
            }
            case "UNPROCESSED": {
                this.audioSourceAsInt = 9;
                break;
            }
            case "VOICE_PERFORMANCE": {
                this.audioSourceAsInt = 10;
            }
        }
    }

    @RequiresApi(api=21)
    private MediaProjection createMediaProjection() {
        return ((MediaProjectionManager)Objects.requireNonNull(this.getSystemService("media_projection"))).getMediaProjection(this.mResultCode, this.mResultData);
    }

    public static String getFilePath() {
        return filePath;
    }

    public static String getFileName() {
        return fileName;
    }

    @RequiresApi(api=21)
    private MediaRecorder createMediaRecorder() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.getDefault());
        Date curDate = new Date(System.currentTimeMillis());
        String curTime = formatter.format(curDate).replace(" ", "");
        String videoQuality = "HD";
        if (!this.isVideoHD) {
            videoQuality = "SD";
        }
        if (this.name == null) {
            this.name = videoQuality + curTime;
        }
        filePath = this.path + "/" + this.name + ".mp4";
        fileName = this.name + ".mp4";
        MediaRecorder mediaRecorder = new MediaRecorder();
        if (this.isAudioEnabled) {
            mediaRecorder.setAudioSource(this.audioSourceAsInt);
        }
        mediaRecorder.setVideoSource(2);
        mediaRecorder.setOutputFormat(this.outputFormatAsInt);
        if (this.isAudioEnabled) {
            mediaRecorder.setAudioEncoder(3);
            mediaRecorder.setAudioEncodingBitRate(this.audioBitrate);
            mediaRecorder.setAudioSamplingRate(this.audioSamplingRate);
        }
        mediaRecorder.setVideoEncoder(this.videoEncoderAsInt);
        mediaRecorder.setOutputFile(this.path + "/" + this.name + ".mp4");
        mediaRecorder.setVideoSize(this.mScreenWidth, this.mScreenHeight);
        if (!this.isCustomSettingsEnabled) {
            if (!this.isVideoHD) {
                mediaRecorder.setVideoEncodingBitRate(12000000);
                mediaRecorder.setVideoFrameRate(30);
            } else {
                mediaRecorder.setVideoEncodingBitRate(5 * this.mScreenWidth * this.mScreenHeight);
                mediaRecorder.setVideoFrameRate(60);
            }
        } else {
            mediaRecorder.setVideoEncodingBitRate(this.videoBitrate);
            mediaRecorder.setVideoFrameRate(this.videoFrameRate);
        }
        try {
            mediaRecorder.prepare();
        }
        catch (IOException | IllegalStateException e) {
            Log.e((String)TAG, (String)("createMediaRecorder: e = " + e.toString()));
        }
        return mediaRecorder;
    }

    @RequiresApi(api=21)
    private VirtualDisplay createVirtualDisplay() {
        return this.mMediaProjection.createVirtualDisplay(TAG, this.mScreenWidth, this.mScreenHeight, this.mScreenDensity, 16, this.mMediaRecorder.getSurface(), null, null);
    }

    @RequiresApi(api=21)
    public void onDestroy() {
        super.onDestroy();
        this.resetAll();
    }

    @RequiresApi(api=21)
    private void resetAll() {
        this.stopForeground(true);
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
        }
        if (this.mMediaRecorder != null) {
            this.mMediaRecorder.setOnErrorListener(null);
            this.mMediaProjection.stop();
            this.mMediaRecorder.reset();
        }
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
            this.mMediaProjection = null;
        }
    }

    public IBinder onBind(Intent intent) {
        return null;
    }
}

