/*
 * Decompiled with CFR 0.152.
 */
package com.goodiebag.pinview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.goodiebag.pinview.R;
import java.util.ArrayList;
import java.util.List;

public class Pinview
extends LinearLayout
implements TextWatcher,
View.OnFocusChangeListener,
View.OnKeyListener {
    private final float DENSITY;
    private int mPinLength;
    private List<EditText> editTextList;
    private int mPinWidth;
    private int mPinHeight;
    private int mSplitWidth;
    private boolean mCursorVisible;
    private boolean mDelPressed;
    @DrawableRes
    private int mPinBackground;
    private boolean mPassword;
    private String mHint;
    private InputType inputType;
    private boolean finalNumberPin;
    private PinViewEventListener mListener;
    private boolean fromSetValue;
    private boolean mForceKeyboard;
    View.OnClickListener mClickListener;
    View currentFocus;
    InputFilter[] filters;
    LinearLayout.LayoutParams params;

    public Pinview(Context context) {
        this(context, null);
    }

    public Pinview(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Pinview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.DENSITY = this.getContext().getResources().getDisplayMetrics().density;
        this.mPinLength = 4;
        this.editTextList = new ArrayList<EditText>();
        this.mPinWidth = 50;
        this.mPinHeight = 50;
        this.mSplitWidth = 20;
        this.mCursorVisible = false;
        this.mDelPressed = false;
        this.mPinBackground = R.drawable.sample_background;
        this.mPassword = false;
        this.mHint = "";
        this.inputType = InputType.TEXT;
        this.finalNumberPin = false;
        this.fromSetValue = false;
        this.mForceKeyboard = true;
        this.currentFocus = null;
        this.filters = new InputFilter[1];
        this.setGravity(17);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.removeAllViews();
        this.mPinHeight = (int)((float)this.mPinHeight * this.DENSITY);
        this.mPinWidth = (int)((float)this.mPinWidth * this.DENSITY);
        this.mSplitWidth = (int)((float)this.mSplitWidth * this.DENSITY);
        this.setWillNotDraw(false);
        this.initAttributes(context, attrs, defStyleAttr);
        this.params = new LinearLayout.LayoutParams(this.mPinWidth, this.mPinHeight);
        this.setOrientation(0);
        this.createEditTexts();
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean focused = false;
                for (EditText editText : Pinview.this.editTextList) {
                    if (editText.length() != 0) continue;
                    editText.requestFocus();
                    if (Pinview.this.mForceKeyboard) {
                        InputMethodManager inputMethodManager = (InputMethodManager)Pinview.this.getContext().getSystemService("input_method");
                        inputMethodManager.toggleSoftInput(2, 1);
                    }
                    focused = true;
                    break;
                }
                if (!focused && Pinview.this.editTextList.size() > 0) {
                    ((EditText)Pinview.this.editTextList.get(Pinview.this.editTextList.size() - 1)).requestFocus();
                }
                if (Pinview.this.mClickListener != null) {
                    Pinview.this.mClickListener.onClick((View)Pinview.this);
                }
            }
        });
        if (this.editTextList.get(0) != null && this.mForceKeyboard) {
            this.editTextList.get(0).postDelayed(new Runnable(){

                @Override
                public void run() {
                    InputMethodManager inputMethodManager = (InputMethodManager)Pinview.this.getContext().getSystemService("input_method");
                    inputMethodManager.toggleSoftInput(2, 1);
                }
            }, 200L);
        }
    }

    private void createEditTexts() {
        this.removeAllViews();
        this.editTextList.clear();
        for (int i = 0; i < this.mPinLength; ++i) {
            EditText editText = new EditText(this.getContext());
            this.editTextList.add(i, editText);
            this.addView((View)editText);
            this.generateOneEditText(editText, "" + i);
        }
        this.setTransformation();
    }

    private void initAttributes(Context context, AttributeSet attrs, int defStyleAttr) {
        if (attrs != null) {
            TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.Pinview, defStyleAttr, 0);
            this.mPinBackground = array.getResourceId(R.styleable.Pinview_pinBackground, this.mPinBackground);
            this.mPinLength = array.getInt(R.styleable.Pinview_pinLength, this.mPinLength);
            this.mPinHeight = (int)array.getDimension(R.styleable.Pinview_pinHeight, (float)this.mPinHeight);
            this.mPinWidth = (int)array.getDimension(R.styleable.Pinview_pinWidth, (float)this.mPinWidth);
            this.mSplitWidth = (int)array.getDimension(R.styleable.Pinview_splitWidth, (float)this.mSplitWidth);
            this.mCursorVisible = array.getBoolean(R.styleable.Pinview_cursorVisible, this.mCursorVisible);
            this.mPassword = array.getBoolean(R.styleable.Pinview_password, this.mPassword);
            this.mForceKeyboard = array.getBoolean(R.styleable.Pinview_forceKeyboard, this.mForceKeyboard);
            this.mHint = array.getString(R.styleable.Pinview_hint);
            InputType[] its = InputType.values();
            this.inputType = its[array.getInt(R.styleable.Pinview_inputType, 0)];
            array.recycle();
        }
    }

    private void generateOneEditText(EditText styleEditText, String tag) {
        int it;
        this.params.setMargins(this.mSplitWidth / 2, this.mSplitWidth / 2, this.mSplitWidth / 2, this.mSplitWidth / 2);
        this.filters[0] = new InputFilter.LengthFilter(1);
        styleEditText.setFilters(this.filters);
        styleEditText.setLayoutParams((ViewGroup.LayoutParams)this.params);
        styleEditText.setGravity(17);
        styleEditText.setCursorVisible(this.mCursorVisible);
        if (!this.mCursorVisible) {
            styleEditText.setClickable(false);
            styleEditText.setHint((CharSequence)this.mHint);
            styleEditText.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    Pinview.this.mDelPressed = false;
                    return false;
                }
            });
        }
        styleEditText.setBackgroundResource(this.mPinBackground);
        styleEditText.setPadding(0, 0, 0, 0);
        styleEditText.setTag((Object)tag);
        switch (this.inputType) {
            case NUMBER: {
                it = 2;
                break;
            }
            case TEXT: {
                it = 1;
                break;
            }
            default: {
                it = 1;
            }
        }
        styleEditText.setInputType(it);
        styleEditText.addTextChangedListener((TextWatcher)this);
        styleEditText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        styleEditText.setOnKeyListener((View.OnKeyListener)this);
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder();
        for (EditText et : this.editTextList) {
            sb.append(et.getText().toString());
        }
        return sb.toString();
    }

    public void setValue(@NonNull String value) {
        String regex = "[0-9]+";
        this.fromSetValue = true;
        if (this.inputType == InputType.NUMBER && !value.matches(regex)) {
            return;
        }
        int lastTagHavingValue = -1;
        for (int i = 0; i < this.editTextList.size(); ++i) {
            if (value.length() > i) {
                lastTagHavingValue = i;
                this.editTextList.get(i).setText((CharSequence)Character.valueOf(value.charAt(i)).toString());
                continue;
            }
            this.editTextList.get(i).setText((CharSequence)"");
        }
        if (this.mPinLength > 0) {
            if (lastTagHavingValue < this.mPinLength - 1) {
                this.currentFocus = (View)this.editTextList.get(lastTagHavingValue + 1);
            } else {
                this.currentFocus = (View)this.editTextList.get(this.mPinLength - 1);
                if (this.inputType == InputType.NUMBER || this.mPassword) {
                    this.finalNumberPin = true;
                }
                if (this.mListener != null) {
                    this.mListener.onDataEntered(this, false);
                }
            }
            this.currentFocus.requestFocus();
        }
        this.fromSetValue = false;
    }

    public void onFocusChange(View view, boolean isFocused) {
        if (isFocused && !this.mCursorVisible) {
            if (this.mDelPressed) {
                this.currentFocus = view;
                this.mDelPressed = false;
                return;
            }
            for (EditText editText : this.editTextList) {
                if (editText.length() != 0) continue;
                if (editText != view) {
                    editText.requestFocus();
                } else {
                    this.currentFocus = view;
                }
                return;
            }
            if (this.editTextList.get(this.editTextList.size() - 1) != view) {
                this.editTextList.get(this.editTextList.size() - 1).requestFocus();
            } else {
                this.currentFocus = view;
            }
        } else if (isFocused && this.mCursorVisible) {
            this.currentFocus = view;
        } else {
            view.clearFocus();
        }
    }

    private void setTransformation() {
        if (this.mPassword) {
            for (EditText editText : this.editTextList) {
                editText.removeTextChangedListener((TextWatcher)this);
                editText.setTransformationMethod((TransformationMethod)new PinTransformationMethod());
                editText.addTextChangedListener((TextWatcher)this);
            }
        } else {
            for (EditText editText : this.editTextList) {
                editText.removeTextChangedListener((TextWatcher)this);
                editText.setTransformationMethod(null);
                editText.addTextChangedListener((TextWatcher)this);
            }
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int start, int i1, int count) {
        int currentTag;
        if (charSequence.length() == 1 && this.currentFocus != null) {
            currentTag = this.getIndexOfCurrentFocus();
            if (currentTag < this.mPinLength - 1) {
                long delay = 1L;
                if (this.mPassword) {
                    delay = 25L;
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ((EditText)Pinview.this.editTextList.get(currentTag + 1)).requestFocus();
                    }
                }, delay);
            }
            if (currentTag == this.mPinLength - 1 && this.inputType == InputType.NUMBER || currentTag == this.mPinLength - 1 && this.mPassword) {
                this.finalNumberPin = true;
            }
        } else if (charSequence.length() == 0) {
            currentTag = this.getIndexOfCurrentFocus();
            this.mDelPressed = true;
            if (this.editTextList.get(currentTag).getText().length() > 0) {
                this.editTextList.get(currentTag).setText((CharSequence)"");
            }
        }
        for (int index = 0; index < this.mPinLength && this.editTextList.get(index).getText().length() >= 1; ++index) {
            if (this.fromSetValue || index + 1 != this.mPinLength || this.mListener == null) continue;
            this.mListener.onDataEntered(this, true);
        }
    }

    public void afterTextChanged(Editable editable) {
    }

    public boolean onKey(View view, int i, KeyEvent keyEvent) {
        if (keyEvent.getAction() == 1 && i == 67) {
            int currentTag = this.getIndexOfCurrentFocus();
            if (this.inputType == InputType.NUMBER && currentTag == this.mPinLength - 1 && this.finalNumberPin || this.mPassword && currentTag == this.mPinLength - 1 && this.finalNumberPin) {
                if (this.editTextList.get(currentTag).length() > 0) {
                    this.editTextList.get(currentTag).setText((CharSequence)"");
                }
                this.finalNumberPin = false;
            } else if (currentTag > 0) {
                this.mDelPressed = true;
                if (this.editTextList.get(currentTag).length() == 0) {
                    this.editTextList.get(currentTag - 1).requestFocus();
                    this.editTextList.get(currentTag).setText((CharSequence)"");
                } else {
                    this.editTextList.get(currentTag).setText((CharSequence)"");
                }
            } else if (this.editTextList.get(currentTag).getText().length() > 0) {
                this.editTextList.get(currentTag).setText((CharSequence)"");
            }
            return true;
        }
        return false;
    }

    private int getIndexOfCurrentFocus() {
        return this.editTextList.indexOf(this.currentFocus);
    }

    public int getSplitWidth() {
        return this.mSplitWidth;
    }

    public void setSplitWidth(int splitWidth) {
        this.mSplitWidth = splitWidth;
        int margin = splitWidth / 2;
        this.params.setMargins(margin, margin, margin, margin);
        for (EditText editText : this.editTextList) {
            editText.setLayoutParams((ViewGroup.LayoutParams)this.params);
        }
    }

    public int getPinHeight() {
        return this.mPinHeight;
    }

    public void setPinHeight(int pinHeight) {
        this.mPinHeight = pinHeight;
        this.params.height = pinHeight;
        for (EditText editText : this.editTextList) {
            editText.setLayoutParams((ViewGroup.LayoutParams)this.params);
        }
    }

    public int getPinWidth() {
        return this.mPinWidth;
    }

    public void setPinWidth(int pinWidth) {
        this.mPinWidth = pinWidth;
        this.params.width = pinWidth;
        for (EditText editText : this.editTextList) {
            editText.setLayoutParams((ViewGroup.LayoutParams)this.params);
        }
    }

    public int getPinLength() {
        return this.mPinLength;
    }

    public void setPinLength(int pinLength) {
        this.mPinLength = pinLength;
        this.createEditTexts();
    }

    public boolean isPassword() {
        return this.mPassword;
    }

    public void setPassword(boolean password) {
        this.mPassword = password;
        this.setTransformation();
    }

    public String getHint() {
        return this.mHint;
    }

    public void setHint(String mHint) {
        this.mHint = mHint;
        for (EditText editText : this.editTextList) {
            editText.setHint((CharSequence)mHint);
        }
    }

    @DrawableRes
    public int getPinBackground() {
        return this.mPinBackground;
    }

    public void setPinBackgroundRes(@DrawableRes int res) {
        this.mPinBackground = res;
        for (EditText editText : this.editTextList) {
            editText.setBackgroundResource(res);
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mClickListener = l;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public void setInputType(InputType inputType) {
        this.inputType = inputType;
        for (EditText editText : this.editTextList) {
            int it;
            switch (inputType) {
                case NUMBER: {
                    it = 2;
                    break;
                }
                case TEXT: {
                    it = 1;
                    break;
                }
                default: {
                    it = 1;
                }
            }
            if (this.mPassword) {
                if (inputType == InputType.NUMBER) {
                    it = 18;
                } else if (inputType == InputType.TEXT) {
                    it = 129;
                }
            }
            editText.setInputType(it);
        }
    }

    public void setPinViewEventListener(PinViewEventListener listener) {
        this.mListener = listener;
    }

    private class PinTransformationMethod
    implements TransformationMethod {
        private char BULLET = (char)8226;

        private PinTransformationMethod() {
        }

        public CharSequence getTransformation(CharSequence source, View view) {
            return new PasswordCharSequence(source);
        }

        public void onFocusChanged(View view, CharSequence sourceText, boolean focused, int direction, Rect previouslyFocusedRect) {
        }

        private class PasswordCharSequence
        implements CharSequence {
            private final CharSequence source;

            public PasswordCharSequence(CharSequence source) {
                this.source = source;
            }

            @Override
            public int length() {
                return this.source.length();
            }

            @Override
            public char charAt(int index) {
                return PinTransformationMethod.this.BULLET;
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new PasswordCharSequence(this.source.subSequence(start, end));
            }
        }
    }

    public static interface PinViewEventListener {
        public void onDataEntered(Pinview var1, boolean var2);
    }

    public static enum InputType {
        TEXT,
        NUMBER;

    }
}

