/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

public class ScaleImageView
extends AppCompatImageView {
    private MatrixTouchListener mListener;
    private GestureDetector mGestureDetector;
    private Matrix mMatrix = new Matrix();
    private float mImageWidth;
    private float mImageHeight;

    public ScaleImageView(Context context) {
        this(context, null);
    }

    public ScaleImageView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScaleImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mListener = new MatrixTouchListener();
        this.setOnTouchListener(this.mListener);
        this.mGestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener(this.mListener));
        this.setBackgroundColor(-1);
        this.setScaleType(ImageView.ScaleType.FIT_CENTER);
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.mMatrix.reset();
        float[] values = new float[9];
        this.mMatrix.getValues(values);
        this.mListener.resetListener();
        this.mImageWidth = (float)bm.getWidth() / values[0];
        this.mImageHeight = ((float)bm.getHeight() - values[5] * 2.0f) / values[4];
    }

    public void resetScale(int scale) {
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private final MatrixTouchListener listener;

        public GestureListener(MatrixTouchListener listener) {
            this.listener = listener;
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            this.listener.onDoubleClick();
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return super.onSingleTapUp(e);
        }

        public void onLongPress(MotionEvent e) {
            super.onLongPress(e);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return super.onScroll(e1, e2, distanceX, distanceY);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public void onShowPress(MotionEvent e) {
            super.onShowPress(e);
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            return super.onDoubleTapEvent(e);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return super.onSingleTapConfirmed(e);
        }
    }

    public class MatrixTouchListener
    implements View.OnTouchListener {
        private static final int MODE_DRAG = 1;
        private static final int MODE_ZOOM = 2;
        private static final int MODE_UNABLE = 3;
        float mMaxScale = 6.0f;
        float mDoubleClickScale = 2.0f;
        private int mMode = 0;
        private float mStartDis;
        private Matrix mCurrentMatrix = new Matrix();
        private PointF startPoint = new PointF();

        public void resetListener() {
            this.mStartDis = 0.0f;
            this.mCurrentMatrix.reset();
            this.startPoint.set(0.0f, 0.0f);
            this.mCurrentMatrix.setScale(1.0f, 1.0f);
            ScaleImageView.this.setImageMatrix(this.mCurrentMatrix);
        }

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getActionMasked()) {
                case 0: {
                    this.mMode = 1;
                    this.startPoint.set(event.getX(), event.getY());
                    this.isMatrixEnable();
                    break;
                }
                case 1: 
                case 3: {
                    this.reSetMatrix();
                    break;
                }
                case 2: {
                    if (this.mMode == 2) {
                        this.setZoomMatrix(event);
                        break;
                    }
                    if (this.mMode != 1) break;
                    this.setDragMatrix(event);
                    break;
                }
                case 5: {
                    if (this.mMode == 3) {
                        return true;
                    }
                    this.mMode = 2;
                    this.mStartDis = this.distance(event);
                    break;
                }
            }
            return ScaleImageView.this.mGestureDetector.onTouchEvent(event);
        }

        public void setDragMatrix(MotionEvent event) {
            float dy;
            float dx;
            if (this.isZoomChanged() && Math.sqrt((dx = event.getX() - this.startPoint.x) * dx + (dy = event.getY() - this.startPoint.y) * dy) > 10.0) {
                this.startPoint.set(event.getX(), event.getY());
                this.mCurrentMatrix.set(ScaleImageView.this.getImageMatrix());
                float[] values = new float[9];
                this.mCurrentMatrix.getValues(values);
                dx = this.checkDxBound(values, dx);
                dy = this.checkDyBound(values, dy);
                this.mCurrentMatrix.postTranslate(dx, dy);
                ScaleImageView.this.setImageMatrix(this.mCurrentMatrix);
            }
        }

        private boolean isZoomChanged() {
            float[] values = new float[9];
            ScaleImageView.this.getImageMatrix().getValues(values);
            float scale = values[0];
            ScaleImageView.this.mMatrix.getValues(values);
            return scale != values[0];
        }

        private float checkDyBound(float[] values, float dy) {
            float height = ScaleImageView.this.getHeight();
            if (ScaleImageView.this.mImageHeight * values[4] < height) {
                return 0.0f;
            }
            if (values[5] + dy > 0.0f) {
                dy = -values[5];
            } else if (values[5] + dy < -(ScaleImageView.this.mImageHeight * values[4] - height)) {
                dy = -(ScaleImageView.this.mImageHeight * values[4] - height) - values[5];
            }
            return dy;
        }

        private float checkDxBound(float[] values, float dx) {
            float width = ScaleImageView.this.getWidth();
            if (ScaleImageView.this.mImageWidth * values[0] < width) {
                return 0.0f;
            }
            if (values[2] + dx > 0.0f) {
                dx = -values[2];
            } else if (values[2] + dx < -(ScaleImageView.this.mImageWidth * values[0] - width)) {
                dx = -(ScaleImageView.this.mImageWidth * values[0] - width) - values[2];
            }
            return dx;
        }

        private void setZoomMatrix(MotionEvent event) {
            if (event.getPointerCount() < 2) {
                return;
            }
            float endDis = this.distance(event);
            if (endDis > 10.0f) {
                float scale = endDis / this.mStartDis;
                this.mStartDis = endDis;
                this.mCurrentMatrix.set(ScaleImageView.this.getImageMatrix());
                float[] values = new float[9];
                this.mCurrentMatrix.getValues(values);
                scale = this.checkMaxScale(scale, values);
                ScaleImageView.this.setImageMatrix(this.mCurrentMatrix);
            }
        }

        private float checkMaxScale(float scale, float[] values) {
            if (scale * values[0] > this.mMaxScale) {
                scale = this.mMaxScale / values[0];
            }
            this.mCurrentMatrix.postScale(scale, scale, (float)(ScaleImageView.this.getWidth() / 2), (float)(ScaleImageView.this.getHeight() / 2));
            return scale;
        }

        private void reSetMatrix() {
            if (this.checkRest()) {
                ScaleImageView.this.setScaleType(ImageView.ScaleType.FIT_CENTER);
                this.mCurrentMatrix.set(ScaleImageView.this.mMatrix);
                ScaleImageView.this.setImageMatrix(this.mCurrentMatrix);
            }
        }

        private boolean checkRest() {
            float[] values = new float[9];
            ScaleImageView.this.getImageMatrix().getValues(values);
            float scale = values[0];
            ScaleImageView.this.mMatrix.getValues(values);
            return scale < values[0];
        }

        private void isMatrixEnable() {
            if (ScaleImageView.this.getScaleType() != ImageView.ScaleType.CENTER) {
                ScaleImageView.this.setScaleType(ImageView.ScaleType.MATRIX);
            } else {
                this.mMode = 3;
            }
        }

        private float distance(MotionEvent event) {
            float dx = event.getX(1) - event.getX(0);
            float dy = event.getY(1) - event.getY(0);
            return (float)Math.sqrt(dx * dx + dy * dy);
        }

        public void onDoubleClick() {
            float scale = this.isZoomChanged() ? 1.0f : this.mDoubleClickScale;
            this.mCurrentMatrix.set(ScaleImageView.this.mMatrix);
            this.mCurrentMatrix.postScale(scale, scale, (float)(ScaleImageView.this.getWidth() / 2), (float)(ScaleImageView.this.getHeight() / 2));
            ScaleImageView.this.setImageMatrix(this.mCurrentMatrix);
        }
    }
}

