/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.zjy.pdfview.widget.IPDFController;
import java.util.ArrayList;
import java.util.List;

public abstract class AbsControllerBar
extends FrameLayout
implements IPDFController {
    protected List<IPDFController.OperateListener> mListener;

    public AbsControllerBar(@NonNull Context context) {
        this(context, null);
    }

    public AbsControllerBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AbsControllerBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    protected abstract View getView();

    private void initView(Context context) {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.addView(view);
        this.mListener = new ArrayList<IPDFController.OperateListener>();
    }

    protected void clickPrevious() {
        for (IPDFController.OperateListener listener : this.mListener) {
            if (listener == null) continue;
            listener.clickPrevious();
        }
    }

    protected void clickNext() {
        for (IPDFController.OperateListener listener : this.mListener) {
            if (listener == null) continue;
            listener.clickNext();
        }
    }

    @Override
    public void addOperateListener(IPDFController.OperateListener listener) {
        if (this.mListener != null && listener != null) {
            this.mListener.add(listener);
        }
    }

    @Override
    public void setPageIndexText(String text) {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mListener != null) {
            this.mListener.clear();
        }
    }
}

