/*
 * Decompiled with CFR 0.152.
 */
package com.zjy.pdfview.utils;

import android.content.Context;
import com.zjy.pdfview.utils.PdfLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Response;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeAssetsToFile(Context context, String assetPath) throws IOException {
        String fileName = assetPath.substring(assetPath.lastIndexOf("/") + 1);
        File resultFile = FileUtils.checkCacheSize(context, assetPath);
        if (!resultFile.exists()) {
            resultFile.createNewFile();
        }
        InputStream is = context.getAssets().open(fileName);
        try (FileOutputStream fos = null;){
            byte[] data = new byte[2048];
            int nbread = 0;
            fos = new FileOutputStream(resultFile);
            while ((nbread = is.read(data)) > -1) {
                fos.write(data, 0, nbread);
            }
        }
        return resultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeNetToFile(Context context, String url, Response response) throws IOException {
        File dest = null;
        try (BufferedSink bufferedSink = null;){
            dest = FileUtils.checkCacheSize(context, url);
            if (dest.exists()) {
                PdfLog.logError("download cache exist");
                File file = dest;
                return file;
            }
            Sink sink = Okio.sink((File)dest);
            bufferedSink = Okio.buffer((Sink)sink);
            bufferedSink.writeAll((Source)response.body().source());
            bufferedSink.close();
            PdfLog.logInfo("download success");
        }
        return dest;
    }

    private static File checkCacheSize(Context context, String url) {
        File[] cacheList;
        String folderPath = context.getFilesDir().getAbsolutePath() + "/pdf/";
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if ((cacheList = folder.listFiles()) != null && cacheList.length >= 10) {
            for (int i = 0; i < cacheList.length; ++i) {
                File childFile = cacheList[i];
                childFile.delete();
            }
        }
        return new File(folderPath, url.substring(url.lastIndexOf("/") + 1));
    }
}

