/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.scoreboard;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ClientboundResetScorePacket
implements MinecraftPacket {
    @NonNull
    private final String owner;
    @Nullable
    private final String objective;

    public ClientboundResetScorePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.owner = helper.readString(in);
        this.objective = helper.readNullable(in, helper::readString);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeString(out, this.owner);
        helper.writeNullable(out, this.objective, helper::writeString);
    }

    @NonNull
    public String getOwner() {
        return this.owner;
    }

    @Nullable
    public String getObjective() {
        return this.objective;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundResetScorePacket)) {
            return false;
        }
        ClientboundResetScorePacket other = (ClientboundResetScorePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$objective = this.getObjective();
        String other$objective = other.getObjective();
        return !(this$objective == null ? other$objective != null : !this$objective.equals(other$objective));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundResetScorePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $objective = this.getObjective();
        result = result * 59 + ($objective == null ? 43 : $objective.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundResetScorePacket(owner=" + this.getOwner() + ", objective=" + this.getObjective() + ")";
    }

    public ClientboundResetScorePacket withOwner(@NonNull String owner) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        return this.owner == owner ? this : new ClientboundResetScorePacket(owner, this.objective);
    }

    public ClientboundResetScorePacket withObjective(@Nullable String objective) {
        return this.objective == objective ? this : new ClientboundResetScorePacket(this.owner, objective);
    }

    public ClientboundResetScorePacket(@NonNull String owner, @Nullable String objective) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        this.owner = owner;
        this.objective = objective;
    }
}

