/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity.player;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class ClientboundSetExperiencePacket
implements MinecraftPacket {
    private final float experience;
    private final int level;
    private final int totalExperience;

    public ClientboundSetExperiencePacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.experience = in.readFloat();
        this.level = helper.readVarInt(in);
        this.totalExperience = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        out.writeFloat(this.experience);
        helper.writeVarInt(out, this.level);
        helper.writeVarInt(out, this.totalExperience);
    }

    public float getExperience() {
        return this.experience;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTotalExperience() {
        return this.totalExperience;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetExperiencePacket)) {
            return false;
        }
        ClientboundSetExperiencePacket other = (ClientboundSetExperiencePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getExperience(), other.getExperience()) != 0) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        return this.getTotalExperience() == other.getTotalExperience();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundSetExperiencePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getExperience());
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getTotalExperience();
        return result;
    }

    public String toString() {
        return "ClientboundSetExperiencePacket(experience=" + this.getExperience() + ", level=" + this.getLevel() + ", totalExperience=" + this.getTotalExperience() + ")";
    }

    public ClientboundSetExperiencePacket withExperience(float experience) {
        return this.experience == experience ? this : new ClientboundSetExperiencePacket(experience, this.level, this.totalExperience);
    }

    public ClientboundSetExperiencePacket withLevel(int level) {
        return this.level == level ? this : new ClientboundSetExperiencePacket(this.experience, level, this.totalExperience);
    }

    public ClientboundSetExperiencePacket withTotalExperience(int totalExperience) {
        return this.totalExperience == totalExperience ? this : new ClientboundSetExperiencePacket(this.experience, this.level, totalExperience);
    }

    public ClientboundSetExperiencePacket(float experience, int level, int totalExperience) {
        this.experience = experience;
        this.level = level;
        this.totalExperience = totalExperience;
    }
}

