/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.ingame.clientbound.entity;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.game.entity.Effect;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;

public class ClientboundRemoveMobEffectPacket
implements MinecraftPacket {
    private final int entityId;
    @NonNull
    private final Effect effect;

    public ClientboundRemoveMobEffectPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.entityId = helper.readVarInt(in);
        this.effect = helper.readEffect(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeVarInt(out, this.entityId);
        helper.writeEffect(out, this.effect);
    }

    public int getEntityId() {
        return this.entityId;
    }

    @NonNull
    public Effect getEffect() {
        return this.effect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRemoveMobEffectPacket)) {
            return false;
        }
        ClientboundRemoveMobEffectPacket other = (ClientboundRemoveMobEffectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        Effect this$effect = this.getEffect();
        Effect other$effect = other.getEffect();
        return !(this$effect == null ? other$effect != null : !((Object)((Object)this$effect)).equals((Object)other$effect));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundRemoveMobEffectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        Effect $effect = this.getEffect();
        result = result * 59 + ($effect == null ? 43 : ((Object)((Object)$effect)).hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundRemoveMobEffectPacket(entityId=" + this.getEntityId() + ", effect=" + this.getEffect() + ")";
    }

    public ClientboundRemoveMobEffectPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundRemoveMobEffectPacket(entityId, this.effect);
    }

    public ClientboundRemoveMobEffectPacket withEffect(@NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        return this.effect == effect ? this : new ClientboundRemoveMobEffectPacket(this.entityId, effect);
    }

    public ClientboundRemoveMobEffectPacket(int entityId, @NonNull Effect effect) {
        if (effect == null) {
            throw new NullPointerException("effect is marked non-null but is null");
        }
        this.entityId = entityId;
        this.effect = effect;
    }
}

