/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.protocol.packet.common.clientbound;

import com.github.steveice10.mc.protocol.codec.MinecraftCodecHelper;
import com.github.steveice10.mc.protocol.codec.MinecraftPacket;
import com.github.steveice10.mc.protocol.data.DefaultComponentSerializer;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import lombok.NonNull;
import net.kyori.adventure.text.Component;

public class ClientboundDisconnectPacket
implements MinecraftPacket {
    @NonNull
    private final Component reason;

    public ClientboundDisconnectPacket(@NonNull String reason) {
        this(DefaultComponentSerializer.get().deserialize((Object)reason));
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
    }

    public ClientboundDisconnectPacket(ByteBuf in, MinecraftCodecHelper helper) throws IOException {
        this.reason = helper.readComponent(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) throws IOException {
        helper.writeComponent(out, this.reason);
    }

    @Override
    public boolean isPriority() {
        return true;
    }

    @NonNull
    public Component getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundDisconnectPacket)) {
            return false;
        }
        ClientboundDisconnectPacket other = (ClientboundDisconnectPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Component this$reason = this.getReason();
        Component other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !this$reason.equals(other$reason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientboundDisconnectPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Component $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        return result;
    }

    public String toString() {
        return "ClientboundDisconnectPacket(reason=" + this.getReason() + ")";
    }

    public ClientboundDisconnectPacket withReason(@NonNull Component reason) {
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        return this.reason == reason ? this : new ClientboundDisconnectPacket(reason);
    }

    public ClientboundDisconnectPacket(@NonNull Component reason) {
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        this.reason = reason;
    }
}

