/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ServerboundMovePlayerRotPacket
implements MinecraftPacket {
    private final boolean onGround;
    private final boolean horizontalCollision;
    private final float yaw;
    private final float pitch;

    public ServerboundMovePlayerRotPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.yaw = in.readFloat();
        this.pitch = in.readFloat();
        short flags = in.readUnsignedByte();
        this.onGround = (flags & 1) != 0;
        this.horizontalCollision = (flags & 2) != 0;
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
        int flags = 0;
        if (this.onGround) {
            flags |= 1;
        }
        if (this.horizontalCollision) {
            flags |= 2;
        }
        out.writeByte(flags);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean isHorizontalCollision() {
        return this.horizontalCollision;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundMovePlayerRotPacket)) {
            return false;
        }
        ServerboundMovePlayerRotPacket other = (ServerboundMovePlayerRotPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnGround() != other.isOnGround()) {
            return false;
        }
        if (this.isHorizontalCollision() != other.isHorizontalCollision()) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        return Float.compare(this.getPitch(), other.getPitch()) == 0;
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundMovePlayerRotPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnGround() ? 79 : 97);
        result = result * 59 + (this.isHorizontalCollision() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundMovePlayerRotPacket(onGround=" + this.isOnGround() + ", horizontalCollision=" + this.isHorizontalCollision() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public @NonNull ServerboundMovePlayerRotPacket withOnGround(boolean onGround) {
        return this.onGround == onGround ? this : new ServerboundMovePlayerRotPacket(onGround, this.horizontalCollision, this.yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerRotPacket withHorizontalCollision(boolean horizontalCollision) {
        return this.horizontalCollision == horizontalCollision ? this : new ServerboundMovePlayerRotPacket(this.onGround, horizontalCollision, this.yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerRotPacket withYaw(float yaw) {
        return this.yaw == yaw ? this : new ServerboundMovePlayerRotPacket(this.onGround, this.horizontalCollision, yaw, this.pitch);
    }

    public @NonNull ServerboundMovePlayerRotPacket withPitch(float pitch) {
        return this.pitch == pitch ? this : new ServerboundMovePlayerRotPacket(this.onGround, this.horizontalCollision, this.yaw, pitch);
    }

    public ServerboundMovePlayerRotPacket(boolean onGround, boolean horizontalCollision, float yaw, float pitch) {
        this.onGround = onGround;
        this.horizontalCollision = horizontalCollision;
        this.yaw = yaw;
        this.pitch = pitch;
    }
}

