/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.title;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundSetTitlesAnimationPacket
implements MinecraftPacket {
    private final int fadeIn;
    private final int stay;
    private final int fadeOut;

    public ClientboundSetTitlesAnimationPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.fadeIn = in.readInt();
        this.stay = in.readInt();
        this.fadeOut = in.readInt();
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        out.writeInt(this.fadeIn);
        out.writeInt(this.stay);
        out.writeInt(this.fadeOut);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getFadeIn() {
        return this.fadeIn;
    }

    public int getStay() {
        return this.stay;
    }

    public int getFadeOut() {
        return this.fadeOut;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundSetTitlesAnimationPacket)) {
            return false;
        }
        ClientboundSetTitlesAnimationPacket other = (ClientboundSetTitlesAnimationPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFadeIn() != other.getFadeIn()) {
            return false;
        }
        if (this.getStay() != other.getStay()) {
            return false;
        }
        return this.getFadeOut() == other.getFadeOut();
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundSetTitlesAnimationPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFadeIn();
        result = result * 59 + this.getStay();
        result = result * 59 + this.getFadeOut();
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundSetTitlesAnimationPacket(fadeIn=" + this.getFadeIn() + ", stay=" + this.getStay() + ", fadeOut=" + this.getFadeOut() + ")";
    }

    public @NonNull ClientboundSetTitlesAnimationPacket withFadeIn(int fadeIn) {
        return this.fadeIn == fadeIn ? this : new ClientboundSetTitlesAnimationPacket(fadeIn, this.stay, this.fadeOut);
    }

    public @NonNull ClientboundSetTitlesAnimationPacket withStay(int stay) {
        return this.stay == stay ? this : new ClientboundSetTitlesAnimationPacket(this.fadeIn, stay, this.fadeOut);
    }

    public @NonNull ClientboundSetTitlesAnimationPacket withFadeOut(int fadeOut) {
        return this.fadeOut == fadeOut ? this : new ClientboundSetTitlesAnimationPacket(this.fadeIn, this.stay, fadeOut);
    }

    public ClientboundSetTitlesAnimationPacket(int fadeIn, int stay, int fadeOut) {
        this.fadeIn = fadeIn;
        this.stay = stay;
        this.fadeOut = fadeOut;
    }
}

