/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.common.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

public class ClientboundStoreCookiePacket
implements MinecraftPacket {
    private final Key key;
    private final byte[] payload;

    public ClientboundStoreCookiePacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.key = helper.readResourceLocation(in);
        this.payload = helper.readByteArray(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeResourceLocation(out, this.key);
        helper.writeByteArray(out, this.payload);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Key getKey() {
        return this.key;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundStoreCookiePacket)) {
            return false;
        }
        ClientboundStoreCookiePacket other = (ClientboundStoreCookiePacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$key = this.getKey();
        Key other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), other.getPayload());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundStoreCookiePacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPayload());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundStoreCookiePacket(key=" + this.getKey() + ", payload=" + Arrays.toString(this.getPayload()) + ")";
    }

    public @NonNull ClientboundStoreCookiePacket withKey(Key key) {
        return this.key == key ? this : new ClientboundStoreCookiePacket(key, this.payload);
    }

    public @NonNull ClientboundStoreCookiePacket withPayload(byte[] payload) {
        return this.payload == payload ? this : new ClientboundStoreCookiePacket(this.key, payload);
    }

    public ClientboundStoreCookiePacket(Key key, byte[] payload) {
        this.key = key;
        this.payload = payload;
    }
}

