package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound;

import io.netty.buffer.ByteBuf;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.With;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftCodecHelper;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;

@Data
@With
@AllArgsConstructor
public class ClientboundTickingStepPacket implements MinecraftPacket {

    private final int tickSteps;

    public ClientboundTickingStepPacket(ByteBuf in, MinecraftCodecHelper helper) {
        this.tickSteps = helper.readVarInt(in);
    }

    @Override
    public void serialize(ByteBuf out, MinecraftCodecHelper helper) {
        helper.writeVarInt(out, this.tickSteps);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }
}
