/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.auth.util;

import com.github.steveice10.mc.auth.exception.request.AuthPendingException;
import com.github.steveice10.mc.auth.exception.request.InvalidCredentialsException;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.exception.request.ServiceUnavailableException;
import com.github.steveice10.mc.auth.exception.request.UserMigratedException;
import com.github.steveice10.mc.auth.util.UUIDSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class HTTP {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDSerializer()).create();

    private HTTP() {
    }

    public static void makeRequest(Proxy proxy, URI uri, Object input) throws RequestException {
        HTTP.makeRequest(proxy, uri, input, null);
    }

    public static <T> T makeRequest(Proxy proxy, URI uri, Object input, Class<T> responseType, Map<String, String> extraHeaders) throws RequestException {
        JsonElement response;
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy cannot be null.");
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null.");
        }
        try {
            response = input == null ? HTTP.performGetRequest(proxy, uri, extraHeaders) : HTTP.performPostRequest(proxy, uri, extraHeaders, GSON.toJson(input), "application/json");
        }
        catch (IOException e) {
            throw new ServiceUnavailableException("Could not make request to '" + uri + "'.", e);
        }
        if (response != null) {
            HTTP.checkForError(response);
            if (responseType != null) {
                return (T)GSON.fromJson(response, responseType);
            }
        }
        return null;
    }

    public static <T> T makeRequest(Proxy proxy, URI uri, Object input, Class<T> responseType) throws RequestException {
        return HTTP.makeRequest(proxy, uri, input, responseType, new HashMap<String, String>());
    }

    public static <T> T makeRequestForm(Proxy proxy, URI uri, Map<String, String> input, Class<T> responseType) throws RequestException {
        JsonElement response;
        if (proxy == null) {
            throw new IllegalArgumentException("Proxy cannot be null.");
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null.");
        }
        String inputString = HTTP.formMapToString(input);
        try {
            response = HTTP.performPostRequest(proxy, uri, new HashMap<String, String>(), inputString, "application/x-www-form-urlencoded");
        }
        catch (IOException e) {
            throw new ServiceUnavailableException("Could not make request to '" + uri + "'.", e);
        }
        if (response != null) {
            HTTP.checkForError(response);
            if (responseType != null) {
                return (T)GSON.fromJson(response, responseType);
            }
        }
        return null;
    }

    public static String formMapToString(Map<String, String> input) {
        StringBuilder inputString = new StringBuilder();
        for (Map.Entry<String, String> inputField : input.entrySet()) {
            if (inputString.length() > 0) {
                inputString.append("&");
            }
            try {
                inputString.append(URLEncoder.encode(inputField.getKey(), StandardCharsets.UTF_8.toString()));
                inputString.append("=");
                inputString.append(URLEncoder.encode(inputField.getValue(), StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return inputString.toString();
    }

    private static void checkForError(JsonElement response) throws RequestException {
        JsonObject object;
        if (response.isJsonObject() && (object = response.getAsJsonObject()).has("error")) {
            String error = object.get("error").getAsString();
            String cause = object.has("cause") ? object.get("cause").getAsString() : "";
            String errorMessage = object.has("errorMessage") ? object.get("errorMessage").getAsString() : "";
            String string = errorMessage = object.has("error_description") ? object.get("error_description").getAsString() : errorMessage;
            if (!error.equals("")) {
                if (error.equals("ForbiddenOperationException")) {
                    if (cause != null && cause.equals("UserMigratedException")) {
                        throw new UserMigratedException(errorMessage);
                    }
                    throw new InvalidCredentialsException(errorMessage);
                }
                if (error.equals("authorization_pending")) {
                    throw new AuthPendingException(errorMessage);
                }
                throw new RequestException(errorMessage);
            }
        }
    }

    private static JsonElement performGetRequest(Proxy proxy, URI uri, Map<String, String> extraHeaders) throws IOException {
        HttpURLConnection connection = HTTP.createUrlConnection(proxy, uri);
        for (Map.Entry<String, String> header : extraHeaders.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.setDoInput(true);
        return HTTP.processResponse(connection);
    }

    private static JsonElement performPostRequest(Proxy proxy, URI uri, Map<String, String> extraHeaders, String post, String type) throws IOException {
        byte[] bytes = post.getBytes(StandardCharsets.UTF_8);
        HttpURLConnection connection = HTTP.createUrlConnection(proxy, uri);
        connection.setRequestProperty("Content-Type", type + "; charset=utf-8");
        connection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
        for (Map.Entry<String, String> header : extraHeaders.entrySet()) {
            connection.setRequestProperty(header.getKey(), header.getValue());
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        try (OutputStream out = connection.getOutputStream();){
            out.write(bytes);
        }
        return HTTP.processResponse(connection);
    }

    public static HttpURLConnection createUrlConnection(Proxy proxy, URI uri) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection(proxy);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        return connection;
    }

    private static JsonElement processResponse(HttpURLConnection connection) throws IOException {
        try (InputStream in = connection.getResponseCode() == 200 ? connection.getInputStream() : connection.getErrorStream();){
            JsonElement jsonElement = in != null ? (JsonElement)GSON.fromJson((Reader)new InputStreamReader(in), JsonElement.class) : null;
            return jsonElement;
        }
    }
}

