/*
 * Decompiled with CFR 0.152.
 */
package com.nafis.bottomnavigation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.View;
import com.nafis.bottomnavigation.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J\b\u00101\u001a\u000202H\u0002J\u0018\u00103\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0018\u00108\u001a\u0002022\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00109\u001a\u0002022\u0006\u00104\u001a\u000205H\u0014J\u0018\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0015R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR$\u0010#\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001dR$\u0010'\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0016\"\u0004\b)\u0010\u0018R\u000e\u0010*\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/nafis/bottomnavigation/BezierView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttrs", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "bezierInnerHeight", "", "bezierInnerWidth", "bezierOuterHeight", "bezierOuterWidth", "value", "bezierX", "getBezierX", "()F", "setBezierX", "(F)V", "color", "getColor", "()I", "setColor", "(I)V", "height", "innerArray", "", "Landroid/graphics/PointF;", "[Landroid/graphics/PointF;", "mainPaint", "Landroid/graphics/Paint;", "mainPath", "Landroid/graphics/Path;", "outerArray", "progress", "getProgress", "setProgress", "progressArray", "shadowColor", "getShadowColor", "setShadowColor", "shadowHeight", "shadowPaint", "shadowPath", "width", "calculate", "start", "end", "calculateInner", "", "drawInner", "canvas", "Landroid/graphics/Canvas;", "isShadow", "", "drawProgress", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "NafisBottomNavigation_release"})
public final class BezierView
extends View {
    @Nullable
    private Paint mainPaint;
    @Nullable
    private Paint shadowPaint;
    @Nullable
    private Path mainPath;
    @Nullable
    private Path shadowPath;
    @NotNull
    private PointF[] outerArray;
    @NotNull
    private PointF[] innerArray;
    @NotNull
    private PointF[] progressArray;
    private float width;
    private float height;
    private float bezierOuterWidth;
    private float bezierOuterHeight;
    private float bezierInnerWidth;
    private float bezierInnerHeight;
    private final float shadowHeight;
    private int color;
    private int shadowColor;
    private float bezierX;
    private float progress;

    @JvmOverloads
    public BezierView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttrs) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttrs);
        this.shadowHeight = UtilsKt.dp(8.0f, context);
        this.setWillNotDraw(false);
        this.mainPath = new Path();
        this.shadowPath = new Path();
        int n2 = 0;
        Paint paint = new PointF[11];
        BezierView bezierView = this;
        while (n2 < 11) {
            n = n2++;
            paint[n] = new PointF();
        }
        bezierView.outerArray = paint;
        n2 = 0;
        paint = new PointF[11];
        bezierView = this;
        while (n2 < 11) {
            n = n2++;
            paint[n] = new PointF();
        }
        bezierView.innerArray = paint;
        n2 = 0;
        paint = new PointF[11];
        bezierView = this;
        while (n2 < 11) {
            n = n2++;
            paint[n] = new PointF();
        }
        bezierView.progressArray = paint;
        Paint paint2 = this.mainPaint = new Paint(1);
        if (paint2 != null) {
            Paint $this$_init__u24lambda_u240 = paint = paint2;
            boolean bl = false;
            $this$_init__u24lambda_u240.setStrokeWidth(0.0f);
            $this$_init__u24lambda_u240.setAntiAlias(true);
            $this$_init__u24lambda_u240.setStyle(Paint.Style.FILL);
            $this$_init__u24lambda_u240.setColor(this.color);
        }
        Paint paint3 = this.shadowPaint = new Paint(1);
        if (paint3 != null) {
            Paint $this$_init__u24lambda_u241 = paint = paint3;
            boolean bl = false;
            $this$_init__u24lambda_u241.setAntiAlias(true);
            $this$_init__u24lambda_u241.setShadowLayer(UtilsKt.dp(4.0f, context), 0.0f, 0.0f, this.shadowColor);
        }
        this.setColor(this.color);
        this.setShadowColor(this.shadowColor);
        this.setLayerType(1, this.shadowPaint);
    }

    public /* synthetic */ BezierView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int value) {
        this.color = value;
        Paint paint = this.mainPaint;
        if (paint != null) {
            paint.setColor(this.color);
        }
        this.invalidate();
    }

    public final int getShadowColor() {
        return this.shadowColor;
    }

    public final void setShadowColor(int value) {
        this.shadowColor = value;
        Paint paint = this.shadowPaint;
        if (paint != null) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            paint.setShadowLayer(UtilsKt.dp(4.0f, context), 0.0f, 0.0f, this.shadowColor);
        }
        this.invalidate();
    }

    public final float getBezierX() {
        return this.bezierX;
    }

    public final void setBezierX(float value) {
        if (value == this.bezierX) {
            return;
        }
        this.bezierX = value;
        this.invalidate();
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float value) {
        if (value == this.progress) {
            return;
        }
        this.progress = value;
        this.progressArray[1].x = this.bezierX - this.bezierInnerWidth / (float)2;
        this.progressArray[2].x = this.bezierX - this.bezierInnerWidth / (float)4;
        this.progressArray[3].x = this.bezierX - this.bezierInnerWidth / (float)4;
        this.progressArray[4].x = this.bezierX;
        this.progressArray[5].x = this.bezierX + this.bezierInnerWidth / (float)4;
        this.progressArray[6].x = this.bezierX + this.bezierInnerWidth / (float)4;
        this.progressArray[7].x = this.bezierX + this.bezierInnerWidth / (float)2;
        for (int i = 2; i < 7; ++i) {
            this.progressArray[i].y = this.progress <= 1.0f ? this.calculate(this.innerArray[i].y, this.outerArray[i].y) : this.calculate(this.outerArray[i].y, this.innerArray[i].y);
        }
        if (this.progress == 2.0f) {
            this.progress = 0.0f;
        }
        this.invalidate();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        this.bezierOuterWidth = UtilsKt.dp(72.0f, context);
        Context context2 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"getContext(...)");
        this.bezierOuterHeight = UtilsKt.dp(8.0f, context2);
        Context context3 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"getContext(...)");
        this.bezierInnerWidth = UtilsKt.dp(124.0f, context3);
        Context context4 = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"getContext(...)");
        this.bezierInnerHeight = UtilsKt.dp(16.0f, context4);
        float extra = this.shadowHeight;
        this.outerArray[0] = new PointF(0.0f, this.bezierOuterHeight + extra);
        this.outerArray[1] = new PointF(this.bezierX - this.bezierOuterWidth / (float)2, this.bezierOuterHeight + extra);
        this.outerArray[2] = new PointF(this.bezierX - this.bezierOuterWidth / (float)4, this.bezierOuterHeight + extra);
        this.outerArray[3] = new PointF(this.bezierX - this.bezierOuterWidth / (float)4, extra);
        this.outerArray[4] = new PointF(this.bezierX, extra);
        this.outerArray[5] = new PointF(this.bezierX + this.bezierOuterWidth / (float)4, extra);
        this.outerArray[6] = new PointF(this.bezierX + this.bezierOuterWidth / (float)4, this.bezierOuterHeight + extra);
        this.outerArray[7] = new PointF(this.bezierX + this.bezierOuterWidth / (float)2, this.bezierOuterHeight + extra);
        this.outerArray[8] = new PointF(this.width, this.bezierOuterHeight + extra);
        this.outerArray[9] = new PointF(this.width, this.height);
        this.outerArray[10] = new PointF(0.0f, this.height);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        Path path = this.mainPath;
        Intrinsics.checkNotNull((Object)path);
        path.reset();
        Path path2 = this.shadowPath;
        Intrinsics.checkNotNull((Object)path2);
        path2.reset();
        if (this.progress == 0.0f) {
            this.drawInner(canvas, true);
            this.drawInner(canvas, false);
        } else {
            this.drawProgress(canvas, true);
            this.drawProgress(canvas, false);
        }
    }

    private final void drawInner(Canvas canvas, boolean isShadow) {
        Paint paint = isShadow ? this.shadowPaint : this.mainPaint;
        Path path = isShadow ? this.shadowPath : this.mainPath;
        this.calculateInner();
        Path path2 = path;
        Intrinsics.checkNotNull((Object)path2);
        path2.lineTo(this.innerArray[0].x, this.innerArray[0].y);
        path.lineTo(this.innerArray[1].x, this.innerArray[1].y);
        path.cubicTo(this.innerArray[2].x, this.innerArray[2].y, this.innerArray[3].x, this.innerArray[3].y, this.innerArray[4].x, this.innerArray[4].y);
        path.cubicTo(this.innerArray[5].x, this.innerArray[5].y, this.innerArray[6].x, this.innerArray[6].y, this.innerArray[7].x, this.innerArray[7].y);
        path.lineTo(this.innerArray[8].x, this.innerArray[8].y);
        path.lineTo(this.innerArray[9].x, this.innerArray[9].y);
        path.lineTo(this.innerArray[10].x, this.innerArray[10].y);
        this.progressArray = (PointF[])this.innerArray.clone();
        Paint paint2 = paint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawPath(path, paint2);
    }

    private final void calculateInner() {
        float extra = this.shadowHeight;
        this.innerArray[0] = new PointF(0.0f, this.bezierInnerHeight + extra);
        this.innerArray[1] = new PointF(this.bezierX - this.bezierInnerWidth / (float)2, this.bezierInnerHeight + extra);
        this.innerArray[2] = new PointF(this.bezierX - this.bezierInnerWidth / (float)4, this.bezierInnerHeight + extra);
        this.innerArray[3] = new PointF(this.bezierX - this.bezierInnerWidth / (float)4, this.height - extra);
        this.innerArray[4] = new PointF(this.bezierX, this.height - extra);
        this.innerArray[5] = new PointF(this.bezierX + this.bezierInnerWidth / (float)4, this.height - extra);
        this.innerArray[6] = new PointF(this.bezierX + this.bezierInnerWidth / (float)4, this.bezierInnerHeight + extra);
        this.innerArray[7] = new PointF(this.bezierX + this.bezierInnerWidth / (float)2, this.bezierInnerHeight + extra);
        this.innerArray[8] = new PointF(this.width, this.bezierInnerHeight + extra);
        this.innerArray[9] = new PointF(this.width, this.height);
        this.innerArray[10] = new PointF(0.0f, this.height);
    }

    private final void drawProgress(Canvas canvas, boolean isShadow) {
        Path path;
        Paint paint = isShadow ? this.shadowPaint : this.mainPaint;
        Path path2 = path = isShadow ? this.shadowPath : this.mainPath;
        Intrinsics.checkNotNull((Object)path2);
        path2.lineTo(this.progressArray[0].x, this.progressArray[0].y);
        path.lineTo(this.progressArray[1].x, this.progressArray[1].y);
        path.cubicTo(this.progressArray[2].x, this.progressArray[2].y, this.progressArray[3].x, this.progressArray[3].y, this.progressArray[4].x, this.progressArray[4].y);
        path.cubicTo(this.progressArray[5].x, this.progressArray[5].y, this.progressArray[6].x, this.progressArray[6].y, this.progressArray[7].x, this.progressArray[7].y);
        path.lineTo(this.progressArray[8].x, this.progressArray[8].y);
        path.lineTo(this.progressArray[9].x, this.progressArray[9].y);
        path.lineTo(this.progressArray[10].x, this.progressArray[10].y);
        Paint paint2 = paint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawPath(path, paint2);
    }

    private final float calculate(float start, float end) {
        float p = this.progress;
        if (p > 1.0f) {
            p = this.progress - 1.0f;
        }
        boolean bl = 0.9f <= p ? p <= 1.0f : false;
        if (bl) {
            this.calculateInner();
        }
        return p * (end - start) + start;
    }

    @JvmOverloads
    public BezierView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BezierView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

