/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.viewmodels;

import android.os.Bundle;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.folioreader.FolioReader;
import com.folioreader.model.locators.SearchItemType;
import com.folioreader.model.locators.SearchLocator;
import com.folioreader.network.R2StreamerApi;
import com.folioreader.ui.adapter.ListViewType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.readium.r2.shared.Locator;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\u0016\u0010\u0018\u001a\u00020\u00072\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002J$\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00072\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011H\u0002J<\u0010\u001d\u001a\u00020\u00072\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0014\u0010\u001e\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/folioreader/viewmodels/SearchViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "errorSearchCallCount", "", "liveAdapterDataBundle", "Landroidx/lifecycle/MutableLiveData;", "Landroid/os/Bundle;", "getLiveAdapterDataBundle", "()Landroidx/lifecycle/MutableLiveData;", "setLiveAdapterDataBundle", "(Landroidx/lifecycle/MutableLiveData;)V", "r2StreamerApi", "Lcom/folioreader/network/R2StreamerApi;", "searchCallCount", "searchCallList", "", "Lretrofit2/Call;", "", "Lorg/readium/r2/shared/Locator;", "successSearchCallCount", "cancelAllSearchCalls", "", "init", "initSearchLocatorList", "locatorList", "mergeSearchResponse", "bundle", "call", "processSingleSearchResponse", "response", "Lretrofit2/Response;", "t", "", "search", "spineSize", "query", "", "Companion", "SearchApiCallback", "folioreader_release"})
public final class SearchViewModel
extends ViewModel {
    @NotNull
    private MutableLiveData<Bundle> liveAdapterDataBundle = new MutableLiveData();
    private R2StreamerApi r2StreamerApi;
    private int searchCallCount;
    private int successSearchCallCount;
    private int errorSearchCallCount;
    private List<Call<List<Locator>>> searchCallList;
    @NotNull
    private static final String LOG_TAG;
    public static final Companion Companion;

    @NotNull
    public final MutableLiveData<Bundle> getLiveAdapterDataBundle() {
        return this.liveAdapterDataBundle;
    }

    public final void setLiveAdapterDataBundle(@NotNull MutableLiveData<Bundle> mutableLiveData) {
        Intrinsics.checkParameterIsNotNull(mutableLiveData, (String)"<set-?>");
        this.liveAdapterDataBundle = mutableLiveData;
    }

    public final void init() {
        Log.v((String)LOG_TAG, (String)"-> init");
        Bundle bundle = new Bundle();
        bundle.putString("LIST_VIEW_TYPE", ListViewType.INIT_VIEW.toString());
        bundle.putParcelableArrayList("DATA", new ArrayList());
        this.liveAdapterDataBundle.setValue((Object)bundle);
    }

    /*
     * WARNING - void declaration
     */
    public final void search(int spineSize, @NotNull String query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Log.d((String)LOG_TAG, (String)("-> search -> spineSize = " + spineSize + ", query = " + query));
        this.cancelAllSearchCalls();
        this.searchCallCount = spineSize;
        this.successSearchCallCount = 0;
        this.errorSearchCallCount = 0;
        int n = 0;
        int n2 = spineSize;
        while (n < n2) {
            void i;
            Call<List<Locator>> call;
            R2StreamerApi r2StreamerApi = this.r2StreamerApi;
            Call<List<Locator>> call2 = call = r2StreamerApi != null ? r2StreamerApi.search((int)i, query) : null;
            if (call != null) {
                Call<List<Locator>> call3;
                Call<List<Locator>> it = call3;
                this.searchCallList.add(it);
                it.enqueue((Callback)new SearchApiCallback());
            }
            ++i;
        }
    }

    public final void cancelAllSearchCalls() {
        Log.v((String)LOG_TAG, (String)"-> cancelAllSearchCalls");
        Iterable $receiver$iv = this.searchCallList;
        for (Object element$iv : $receiver$iv) {
            Call it = (Call)element$iv;
            it.cancel();
        }
        this.searchCallList.clear();
    }

    private final void mergeSearchResponse(Bundle bundle, Call<List<Locator>> call) {
        Log.v((String)LOG_TAG, (String)"-> mergeSearchResponse");
        if (call.isCanceled()) {
            return;
        }
        String responseViewType = bundle.getString("LIST_VIEW_TYPE");
        if (Intrinsics.areEqual((Object)responseViewType, (Object)ListViewType.NORMAL_VIEW.name())) {
            SearchViewModel searchViewModel = this;
            ++searchViewModel.successSearchCallCount;
            int cfr_ignored_0 = searchViewModel.successSearchCallCount;
            ArrayList arrayList = bundle.getParcelableArrayList("DATA");
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            List responseList = arrayList;
            Object object = this.liveAdapterDataBundle.getValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            ArrayList arrayList2 = ((Bundle)object).getParcelableArrayList("DATA");
            if (arrayList2 == null) {
                Intrinsics.throwNpe();
            }
            List liveList = arrayList2;
            if ((liveList = CollectionsKt.toMutableList((Collection)liveList)).isEmpty()) {
                bundle.putString("LIST_VIEW_TYPE", ListViewType.PAGINATION_IN_PROGRESS_VIEW.toString());
                this.liveAdapterDataBundle.setValue((Object)bundle);
            } else {
                String string2 = ((SearchLocator)((Object)CollectionsKt.first((List)liveList))).getPrimaryContents();
                int liveSearchCountItems = Integer.parseInt(string2);
                String string3 = ((SearchLocator)((Object)CollectionsKt.first((List)responseList))).getPrimaryContents();
                int responseSearchCountItems = Integer.parseInt(string3);
                int totalLiveSearchCountItems = liveSearchCountItems + responseSearchCountItems;
                ((SearchLocator)((Object)CollectionsKt.first((List)liveList))).setPrimaryContents(String.valueOf(totalLiveSearchCountItems));
                responseList.remove(0);
                liveList.addAll(responseList);
                Bundle dataBundle = new Bundle();
                dataBundle.putString("LIST_VIEW_TYPE", ListViewType.PAGINATION_IN_PROGRESS_VIEW.toString());
                dataBundle.putParcelableArrayList("DATA", new ArrayList(liveList));
                this.liveAdapterDataBundle.setValue((Object)dataBundle);
            }
        } else if (Intrinsics.areEqual((Object)responseViewType, (Object)ListViewType.FAILURE_VIEW.name())) {
            SearchViewModel searchViewModel = this;
            ++searchViewModel.errorSearchCallCount;
            int cfr_ignored_1 = searchViewModel.errorSearchCallCount;
        } else {
            SearchViewModel searchViewModel = this;
            ++searchViewModel.successSearchCallCount;
            int cfr_ignored_2 = searchViewModel.successSearchCallCount;
        }
        SearchViewModel searchViewModel = this;
        searchViewModel.searchCallCount += -1;
        if (searchViewModel.searchCallCount == 0) {
            Object object = this.liveAdapterDataBundle.getValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            ArrayList arrayList = ((Bundle)object).getParcelableArrayList("DATA");
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            List liveList = arrayList;
            Bundle dataBundle = new Bundle();
            dataBundle.putParcelableArrayList("DATA", new ArrayList(liveList));
            ListViewType liveListViewType = liveList.isEmpty() && this.errorSearchCallCount > 0 ? ListViewType.FAILURE_VIEW : (liveList.isEmpty() ? ListViewType.EMPTY_VIEW : ListViewType.NORMAL_VIEW);
            dataBundle.putString("LIST_VIEW_TYPE", liveListViewType.toString());
            this.liveAdapterDataBundle.setValue((Object)dataBundle);
        }
    }

    private final Bundle processSingleSearchResponse(Call<List<Locator>> call, Response<List<Locator>> response, Throwable t) {
        Bundle bundle;
        List locatorList;
        Log.d((String)LOG_TAG, (String)"-> processSingleSearchResponse");
        Response<List<Locator>> response2 = response;
        List list = locatorList = response2 != null ? (List)response2.body() : null;
        if (locatorList == null) {
            Bundle dataBundle = new Bundle();
            dataBundle.putString("LIST_VIEW_TYPE", ListViewType.FAILURE_VIEW.toString());
            bundle = dataBundle;
        } else if (locatorList.isEmpty()) {
            Bundle dataBundle = new Bundle();
            dataBundle.putString("LIST_VIEW_TYPE", ListViewType.EMPTY_VIEW.toString());
            bundle = dataBundle;
        } else {
            bundle = this.initSearchLocatorList(TypeIntrinsics.asMutableList((Object)locatorList));
        }
        return bundle;
    }

    private final Bundle initSearchLocatorList(List<Locator> locatorList) {
        Log.v((String)LOG_TAG, (String)"-> initSearchLocatorList");
        List searchLocatorList = new ArrayList();
        SearchLocator searchCountItem = new SearchLocator();
        searchCountItem.setSearchItemType(SearchItemType.SEARCH_COUNT_ITEM);
        searchCountItem.setPrimaryContents(String.valueOf(locatorList.size()));
        searchLocatorList.add(searchCountItem);
        String resourceHref = null;
        for (Locator locator : locatorList) {
            String primaryContents;
            if (Intrinsics.areEqual((Object)resourceHref, (Object)locator.getHref()) ^ true) {
                resourceHref = locator.getHref();
                SearchLocator titleLocator = new SearchLocator();
                titleLocator.setSearchItemType(SearchItemType.RESOURCE_TITLE_ITEM);
                titleLocator.setPrimaryContents(locator.getTitle());
                searchLocatorList.add(titleLocator);
            }
            StringBuilder stringBuilder = new StringBuilder();
            Object object = locator.getText();
            if (object == null || (object = object.getBefore()) == null) {
                object = "";
            }
            StringBuilder stringBuilder2 = stringBuilder.append((String)object);
            Object object2 = locator.getText();
            if (object2 == null || (object2 = object2.getHightlight()) == null) {
                object2 = "";
            }
            StringBuilder stringBuilder3 = stringBuilder2.append((String)object2);
            Object object3 = locator.getText();
            if (object3 == null || (object3 = object3.getAfter()) == null) {
                object3 = "";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3.append((String)object3).toString(), (String)"StringBuilder()\n        \u2026              .toString()");
            SearchLocator searchResultItem = new SearchLocator(locator, primaryContents, SearchItemType.SEARCH_RESULT_ITEM);
            searchLocatorList.add(searchResultItem);
        }
        Bundle dataBundle = new Bundle();
        dataBundle.putString("LIST_VIEW_TYPE", ListViewType.NORMAL_VIEW.toString());
        dataBundle.putParcelableArrayList("DATA", new ArrayList(searchLocatorList));
        return dataBundle;
    }

    public SearchViewModel() {
        List list;
        this.r2StreamerApi = FolioReader.get().r2StreamerApi;
        SearchViewModel searchViewModel = this;
        searchViewModel.searchCallList = list = (List)new ArrayList();
        this.init();
    }

    static {
        Companion = new Companion(null);
        String string2 = SearchViewModel.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SearchViewModel::class.java.simpleName");
        LOG_TAG = string2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/folioreader/viewmodels/SearchViewModel$SearchApiCallback;", "Lretrofit2/Callback;", "", "Lorg/readium/r2/shared/Locator;", "(Lcom/folioreader/viewmodels/SearchViewModel;)V", "onFailure", "", "call", "Lretrofit2/Call;", "t", "", "onResponse", "response", "Lretrofit2/Response;", "folioreader_release"})
    public final class SearchApiCallback
    implements Callback<List<? extends Locator>> {
        public void onFailure(@NotNull Call<List<Locator>> call, @NotNull Throwable t) {
            Intrinsics.checkParameterIsNotNull(call, (String)"call");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            Log.e((String)Companion.getLOG_TAG(), (String)"-> search -> onFailure", (Throwable)t);
            Bundle bundle = SearchViewModel.this.processSingleSearchResponse((Call<List<Locator>>)call, (Response<List<Locator>>)null, t);
            SearchViewModel.this.mergeSearchResponse(bundle, (Call<List<Locator>>)call);
        }

        public void onResponse(@NotNull Call<List<Locator>> call, @NotNull Response<List<Locator>> response) {
            Intrinsics.checkParameterIsNotNull(call, (String)"call");
            Intrinsics.checkParameterIsNotNull(response, (String)"response");
            Log.d((String)Companion.getLOG_TAG(), (String)"-> search -> onResponse");
            Bundle bundle = SearchViewModel.this.processSingleSearchResponse((Call<List<Locator>>)call, (Response<List<Locator>>)response, null);
            SearchViewModel.this.mergeSearchResponse(bundle, (Call<List<Locator>>)call);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/folioreader/viewmodels/SearchViewModel$Companion;", "", "()V", "LOG_TAG", "", "getLOG_TAG", "()Ljava/lang/String;", "folioreader_release"})
    public static final class Companion {
        @NotNull
        public final String getLOG_TAG() {
            return LOG_TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

