/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader.ui.activity;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Toast;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import androidx.viewpager.widget.PagerAdapter;
import com.folioreader.Config;
import com.folioreader.Constants;
import com.folioreader.FolioReader;
import com.folioreader.R;
import com.folioreader.model.DisplayUnit;
import com.folioreader.model.HighlightImpl;
import com.folioreader.model.event.MediaOverlayPlayPauseEvent;
import com.folioreader.model.locators.ReadLocator;
import com.folioreader.model.locators.SearchLocator;
import com.folioreader.ui.activity.ContentHighlightActivity;
import com.folioreader.ui.activity.FolioActivity;
import com.folioreader.ui.activity.FolioActivity$WhenMappings;
import com.folioreader.ui.activity.FolioActivityCallback;
import com.folioreader.ui.activity.SearchActivity;
import com.folioreader.ui.adapter.FolioPageFragmentAdapter;
import com.folioreader.ui.fragment.FolioPageFragment;
import com.folioreader.ui.fragment.MediaControllerFragment;
import com.folioreader.ui.view.ConfigBottomSheetDialogFragment;
import com.folioreader.ui.view.DirectionalViewpager;
import com.folioreader.ui.view.FolioAppBarLayout;
import com.folioreader.ui.view.FolioWebView;
import com.folioreader.ui.view.MediaControllerCallback;
import com.folioreader.util.AppUtil;
import com.folioreader.util.FileUtil;
import com.folioreader.util.UiUtil;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.greenrobot.eventbus.EventBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.readium.r2.shared.Link;
import org.readium.r2.shared.Publication;
import org.readium.r2.streamer.container.Container;
import org.readium.r2.streamer.parser.CbzParser;
import org.readium.r2.streamer.parser.EpubParser;
import org.readium.r2.streamer.parser.PubBox;
import org.readium.r2.streamer.server.Server;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0016*\u0002\r;\u0018\u0000 \u0091\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0006\u0091\u0001\u0092\u0001\u0093\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010K\u001a\u00020LH\u0002J\b\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020LH\u0002J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00000QH\u0016J\u0010\u0010R\u001a\u00020\u00102\u0006\u0010S\u001a\u00020TH\u0016J\u0012\u0010U\u001a\u00020\u00102\b\u0010V\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010U\u001a\u00020\u00102\u0006\u0010W\u001a\u00020\u000b2\u0006\u0010X\u001a\u00020\u000bH\u0002J\b\u0010Y\u001a\u00020\u0010H\u0016J\b\u0010Z\u001a\u00020\u0018H\u0016J\n\u0010[\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\\\u001a\u00020\u000bH\u0016J\u0010\u0010]\u001a\u00020\u00102\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010^\u001a\u00020N2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010_\u001a\u00020\u001c2\u0006\u0010`\u001a\u00020\u000bH\u0016J\b\u0010a\u001a\u00020LH\u0002J\b\u0010b\u001a\u00020LH\u0002J\b\u0010c\u001a\u00020LH\u0002J\u0012\u0010d\u001a\u00020L2\b\u00104\u001a\u0004\u0018\u00010.H\u0002J\b\u0010e\u001a\u00020LH\u0002J\"\u0010f\u001a\u00020L2\u0006\u0010g\u001a\u00020\u00102\u0006\u0010h\u001a\u00020\u00102\b\u0010i\u001a\u0004\u0018\u00010jH\u0014J\b\u0010k\u001a\u00020LH\u0002J\b\u0010l\u001a\u00020LH\u0002J\u0012\u0010m\u001a\u00020L2\b\u00104\u001a\u0004\u0018\u00010.H\u0014J\u0010\u0010n\u001a\u00020\u001c2\u0006\u0010o\u001a\u00020pH\u0016J\b\u0010q\u001a\u00020LH\u0014J\u0010\u0010r\u001a\u00020L2\u0006\u0010s\u001a\u00020\u0018H\u0016J\u0010\u0010t\u001a\u00020L2\u0006\u0010u\u001a\u00020jH\u0014J\u0010\u0010v\u001a\u00020\u001c2\u0006\u0010w\u001a\u00020xH\u0016J\u0012\u0010y\u001a\u00020L2\b\u00104\u001a\u0004\u0018\u00010.H\u0014J+\u0010z\u001a\u00020L2\u0006\u0010g\u001a\u00020\u00102\f\u0010{\u001a\b\u0012\u0004\u0012\u00020\u000b0|2\u0006\u0010}\u001a\u00020~H\u0016\u00a2\u0006\u0002\u0010\u007fJ\t\u0010\u0080\u0001\u001a\u00020LH\u0014J\u0011\u0010\u0081\u0001\u001a\u00020L2\u0006\u0010-\u001a\u00020.H\u0014J\t\u0010\u0082\u0001\u001a\u00020LH\u0014J\u0012\u0010\u0083\u0001\u001a\u00020L2\u0007\u0010\u0084\u0001\u001a\u00020\u0010H\u0016J\t\u0010\u0085\u0001\u001a\u00020LH\u0016J\t\u0010\u0086\u0001\u001a\u00020LH\u0016J\u0013\u0010\u0087\u0001\u001a\u00020L2\b\u00104\u001a\u0004\u0018\u00010.H\u0002J\t\u0010\u0088\u0001\u001a\u00020LH\u0016J\t\u0010\u0089\u0001\u001a\u00020LH\u0016J\t\u0010\u008a\u0001\u001a\u00020LH\u0002J\u0007\u0010\u008b\u0001\u001a\u00020LJ\u0007\u0010\u008c\u0001\u001a\u00020LJ\t\u0010\u008d\u0001\u001a\u00020LH\u0002J\u0007\u0010\u008e\u0001\u001a\u00020LJ\u0011\u0010\u008f\u0001\u001a\u00020L2\u0006\u0010!\u001a\u00020\u001eH\u0016J\t\u0010\u0090\u0001\u001a\u00020LH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00104\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00108\u001a\u0004\u0018\u000109X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010<R\u0010\u0010=\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010?\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010@X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010B\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0010\u0010E\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010I\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010J\u00a8\u0006\u0094\u0001"}, d2={"Lcom/folioreader/ui/activity/FolioActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lcom/folioreader/ui/activity/FolioActivityCallback;", "Lcom/folioreader/ui/view/MediaControllerCallback;", "Landroid/view/View$OnSystemUiVisibilityChangeListener;", "()V", "actionBar", "Landroidx/appcompat/app/ActionBar;", "appBarLayout", "Lcom/folioreader/ui/view/FolioAppBarLayout;", "bookFileName", "", "closeBroadcastReceiver", "com/folioreader/ui/activity/FolioActivity$closeBroadcastReceiver$1", "Lcom/folioreader/ui/activity/FolioActivity$closeBroadcastReceiver$1;", "currentChapterIndex", "", "currentFragment", "Lcom/folioreader/ui/fragment/FolioPageFragment;", "getCurrentFragment", "()Lcom/folioreader/ui/fragment/FolioPageFragment;", "density", "", "direction", "Lcom/folioreader/Config$Direction;", "displayMetrics", "Landroid/util/DisplayMetrics;", "distractionFreeMode", "", "entryReadLocator", "Lcom/folioreader/model/locators/ReadLocator;", "handler", "Landroid/os/Handler;", "lastReadLocator", "mBookId", "mEpubFilePath", "mEpubRawId", "mEpubSourceType", "Lcom/folioreader/ui/activity/FolioActivity$EpubSourceType;", "mFolioPageFragmentAdapter", "Lcom/folioreader/ui/adapter/FolioPageFragmentAdapter;", "mFolioPageViewPager", "Lcom/folioreader/ui/view/DirectionalViewpager;", "mediaControllerFragment", "Lcom/folioreader/ui/fragment/MediaControllerFragment;", "outState", "Landroid/os/Bundle;", "portNumber", "pubBox", "Lorg/readium/r2/streamer/parser/PubBox;", "r2StreamerServer", "Lorg/readium/r2/streamer/server/Server;", "savedInstanceState", "searchAdapterDataBundle", "searchLocator", "Lcom/folioreader/model/locators/SearchLocator;", "searchQuery", "", "searchReceiver", "com/folioreader/ui/activity/FolioActivity$searchReceiver$1", "Lcom/folioreader/ui/activity/FolioActivity$searchReceiver$1;", "searchUri", "Landroid/net/Uri;", "spine", "", "Lorg/readium/r2/shared/Link;", "statusBarHeight", "getStatusBarHeight", "()I", "streamerUri", "taskImportance", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "topActivity", "Ljava/lang/Boolean;", "clearSearchLocator", "", "computeViewportRect", "Landroid/graphics/Rect;", "configFolio", "getActivity", "Ljava/lang/ref/WeakReference;", "getBottomDistraction", "unit", "Lcom/folioreader/model/DisplayUnit;", "getChapterIndex", "readLocator", "caseString", "value", "getCurrentChapterIndex", "getDirection", "getEntryReadLocator", "getStreamerUrl", "getTopDistraction", "getViewportRect", "goToChapter", "href", "hideSystemUI", "initActionBar", "initBook", "initDistractionFreeMode", "initMediaController", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onBookInitFailure", "onBookInitSuccess", "onCreate", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onDestroy", "onDirectionChange", "newDirection", "onNewIntent", "intent", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPostCreate", "onRequestPermissionsResult", "permissions", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onResume", "onSaveInstanceState", "onStop", "onSystemUiVisibilityChange", "visibility", "pause", "play", "setConfig", "setDayMode", "setNightMode", "setupBook", "showConfigBottomSheetDialogFragment", "showMediaController", "showSystemUI", "startContentHighlightActivity", "storeLastReadLocator", "toggleSystemUI", "Companion", "EpubSourceType", "RequestCode", "folioreader_release"})
public final class FolioActivity
extends AppCompatActivity
implements FolioActivityCallback,
MediaControllerCallback,
View.OnSystemUiVisibilityChangeListener {
    private String bookFileName;
    private DirectionalViewpager mFolioPageViewPager;
    private ActionBar actionBar;
    private FolioAppBarLayout appBarLayout;
    private Toolbar toolbar;
    private boolean distractionFreeMode;
    private Handler handler;
    private int currentChapterIndex;
    private FolioPageFragmentAdapter mFolioPageFragmentAdapter;
    private ReadLocator entryReadLocator;
    private ReadLocator lastReadLocator;
    private Bundle outState;
    private Bundle savedInstanceState;
    private Server r2StreamerServer;
    private PubBox pubBox;
    private List<Link> spine;
    private String mBookId;
    private String mEpubFilePath;
    private EpubSourceType mEpubSourceType;
    private int mEpubRawId;
    private MediaControllerFragment mediaControllerFragment;
    private Config.Direction direction = Config.Direction.VERTICAL;
    private int portNumber = 8080;
    private Uri streamerUri;
    private Uri searchUri;
    private Bundle searchAdapterDataBundle;
    private CharSequence searchQuery;
    private SearchLocator searchLocator;
    private DisplayMetrics displayMetrics;
    private float density;
    private Boolean topActivity;
    private int taskImportance;
    private final closeBroadcastReceiver.1 closeBroadcastReceiver = new BroadcastReceiver(this){
        final /* synthetic */ FolioActivity this$0;

        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            StringBuilder stringBuilder = new StringBuilder().append("-> closeBroadcastReceiver -> onReceive -> ");
            String string2 = intent.getAction();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Log.v((String)FolioActivity.LOG_TAG, (String)stringBuilder.append(string2).toString());
            String action = intent.getAction();
            if (action != null && Intrinsics.areEqual((Object)action, (Object)"com.folioreader.action.CLOSE_FOLIOREADER")) {
                try {
                    Object object = context.getSystemService("activity");
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.app.ActivityManager");
                    }
                    ActivityManager activityManager = (ActivityManager)object;
                    List tasks = activityManager.getRunningAppProcesses();
                    FolioActivity.access$setTaskImportance$p(this.this$0, ((ActivityManager.RunningAppProcessInfo)tasks.get((int)0)).importance);
                }
                catch (Exception e) {
                    Log.e((String)FolioActivity.LOG_TAG, (String)"-> ", (Throwable)e);
                }
                Intent closeIntent = new Intent(this.this$0.getApplicationContext(), FolioActivity.class);
                closeIntent.setFlags(0x24000000);
                closeIntent.setAction("com.folioreader.action.CLOSE_FOLIOREADER");
                this.this$0.startActivity(closeIntent);
            }
        }
        {
            this.this$0 = $outer;
        }
    };
    private final searchReceiver.1 searchReceiver = new BroadcastReceiver(this){
        final /* synthetic */ FolioActivity this$0;

        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            String action;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            StringBuilder stringBuilder = new StringBuilder().append("-> searchReceiver -> onReceive -> ");
            String string2 = intent.getAction();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Log.v((String)FolioActivity.LOG_TAG, (String)stringBuilder.append(string2).toString());
            String string3 = intent.getAction();
            if (string3 == null) {
                return;
            }
            String string4 = action = string3;
            switch (string4.hashCode()) {
                case 1595694143: {
                    if (!string4.equals("ACTION_SEARCH_CLEAR")) break;
                    FolioActivity.access$clearSearchLocator(this.this$0);
                }
            }
        }
        {
            this.this$0 = $outer;
        }
    };
    @JvmField
    @NotNull
    public static final String LOG_TAG;
    @NotNull
    public static final String INTENT_EPUB_SOURCE_PATH = "com.folioreader.epub_asset_path";
    @NotNull
    public static final String INTENT_EPUB_SOURCE_TYPE = "epub_source_type";
    @NotNull
    public static final String EXTRA_READ_LOCATOR = "com.folioreader.extra.READ_LOCATOR";
    private static final String BUNDLE_READ_LOCATOR_CONFIG_CHANGE = "BUNDLE_READ_LOCATOR_CONFIG_CHANGE";
    private static final String BUNDLE_DISTRACTION_FREE_MODE = "BUNDLE_DISTRACTION_FREE_MODE";
    @NotNull
    public static final String EXTRA_SEARCH_ITEM = "EXTRA_SEARCH_ITEM";
    @NotNull
    public static final String ACTION_SEARCH_CLEAR = "ACTION_SEARCH_CLEAR";
    private static final String HIGHLIGHT_ITEM = "highlight_item";
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final int getStatusBarHeight() {
        int result = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = this.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    private final FolioPageFragment getCurrentFragment() {
        FolioPageFragment folioPageFragment;
        if (this.mFolioPageFragmentAdapter != null && this.mFolioPageViewPager != null) {
            FolioPageFragmentAdapter folioPageFragmentAdapter = this.mFolioPageFragmentAdapter;
            if (folioPageFragmentAdapter == null) {
                Intrinsics.throwNpe();
            }
            DirectionalViewpager directionalViewpager = this.mFolioPageViewPager;
            if (directionalViewpager == null) {
                Intrinsics.throwNpe();
            }
            Fragment fragment = folioPageFragmentAdapter.getItem(directionalViewpager.getCurrentItem());
            if (fragment == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.folioreader.ui.fragment.FolioPageFragment");
            }
            folioPageFragment = (FolioPageFragment)fragment;
        } else {
            folioPageFragment = null;
        }
        return folioPageFragment;
    }

    protected void onNewIntent(@NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        super.onNewIntent(intent);
        this.setIntent(intent);
        Log.v((String)LOG_TAG, (String)"-> onNewIntent");
        Intent intent2 = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent2, (String)"getIntent()");
        String action = intent2.getAction();
        if (action != null && Intrinsics.areEqual((Object)action, (Object)"com.folioreader.action.CLOSE_FOLIOREADER") && (this.topActivity == null || Intrinsics.areEqual((Object)this.topActivity, (Object)false))) {
            this.finish();
            boolean appInBackground = false;
            if (Build.VERSION.SDK_INT < 26) {
                if (400 == this.taskImportance) {
                    appInBackground = true;
                }
            } else if (400 == this.taskImportance) {
                appInBackground = true;
            }
            if (appInBackground) {
                this.moveTaskToBack(true);
            }
        }
    }

    protected void onResume() {
        super.onResume();
        Log.v((String)LOG_TAG, (String)"-> onResume");
        this.topActivity = true;
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        String action = intent.getAction();
        if (action != null && Intrinsics.areEqual((Object)action, (Object)"com.folioreader.action.CLOSE_FOLIOREADER")) {
            this.finish();
        }
    }

    protected void onStop() {
        super.onStop();
        Log.v((String)LOG_TAG, (String)"-> onStop");
        this.topActivity = false;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
        this.handler = new Handler();
        WindowManager windowManager = this.getWindowManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)windowManager, (String)"windowManager");
        Display display = windowManager.getDefaultDisplay();
        Resources resources = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        this.displayMetrics = resources.getDisplayMetrics();
        display.getRealMetrics(this.displayMetrics);
        DisplayMetrics displayMetrics = this.displayMetrics;
        if (displayMetrics == null) {
            Intrinsics.throwNpe();
        }
        this.density = displayMetrics.density;
        LocalBroadcastManager.getInstance((Context)((Context)this)).registerReceiver((BroadcastReceiver)this.closeBroadcastReceiver, new IntentFilter("com.folioreader.action.CLOSE_FOLIOREADER"));
        this.setConfig(savedInstanceState);
        this.initDistractionFreeMode(savedInstanceState);
        this.setContentView(R.layout.folio_activity);
        this.savedInstanceState = savedInstanceState;
        if (savedInstanceState != null) {
            this.searchAdapterDataBundle = savedInstanceState.getBundle("DATA_BUNDLE");
            this.searchQuery = savedInstanceState.getCharSequence("BUNDLE_SAVE_SEARCH_QUERY");
        }
        this.mBookId = this.getIntent().getStringExtra("com.folioreader.extra.BOOK_ID");
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Intrinsics.throwNpe();
        }
        Serializable serializable = bundle.getSerializable(INTENT_EPUB_SOURCE_TYPE);
        if (serializable == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.folioreader.ui.activity.FolioActivity.EpubSourceType");
        }
        this.mEpubSourceType = (EpubSourceType)((Object)serializable);
        if (this.mEpubSourceType == EpubSourceType.RAW) {
            Intent intent2 = this.getIntent();
            Intrinsics.checkExpressionValueIsNotNull((Object)intent2, (String)"intent");
            Bundle bundle2 = intent2.getExtras();
            if (bundle2 == null) {
                Intrinsics.throwNpe();
            }
            this.mEpubRawId = bundle2.getInt(INTENT_EPUB_SOURCE_PATH);
        } else {
            Intent intent3 = this.getIntent();
            Intrinsics.checkExpressionValueIsNotNull((Object)intent3, (String)"intent");
            Bundle bundle3 = intent3.getExtras();
            if (bundle3 == null) {
                Intrinsics.throwNpe();
            }
            this.mEpubFilePath = bundle3.getString(INTENT_EPUB_SOURCE_PATH);
        }
        this.initActionBar();
        this.initMediaController();
        if (ContextCompat.checkSelfPermission((Context)((Context)this), (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)this), (String[])Constants.getWriteExternalStoragePerms(), (int)102);
        } else {
            this.setupBook();
        }
    }

    private final void initActionBar() {
        this.appBarLayout = (FolioAppBarLayout)this.findViewById(R.id.appBarLayout);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(this.toolbar);
        this.actionBar = this.getSupportActionBar();
        Config config = AppUtil.Companion.getSavedConfig(this.getApplicationContext());
        if (config == null) {
            Intrinsics.throwNpe();
        }
        Config config2 = config;
        Drawable drawable2 = ContextCompat.getDrawable((Context)((Context)this), (int)R.drawable.ic_drawer);
        int n = config2.getThemeColor();
        Drawable drawable3 = drawable2;
        if (drawable3 == null) {
            Intrinsics.throwNpe();
        }
        UiUtil.setColorIntToDrawable(n, drawable3);
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwNpe();
        }
        toolbar.setNavigationIcon(drawable2);
        if (config2.isNightMode()) {
            this.setNightMode();
        } else {
            this.setDayMode();
        }
        if (Build.VERSION.SDK_INT >= 21) {
            int color2;
            if (config2.isNightMode()) {
                color2 = ContextCompat.getColor((Context)((Context)this), (int)R.color.black);
            } else {
                int[] attrs = new int[]{16843858};
                TypedArray typedArray = this.getTheme().obtainStyledAttributes(attrs);
                color2 = typedArray.getColor(0, ContextCompat.getColor((Context)((Context)this), (int)R.color.white));
            }
            Window window = this.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
            window.setNavigationBarColor(color2);
        }
        if (Build.VERSION.SDK_INT < 16) {
            FolioAppBarLayout folioAppBarLayout = this.appBarLayout;
            if (folioAppBarLayout == null) {
                Intrinsics.throwNpe();
            }
            folioAppBarLayout.setTopMargin(this.getStatusBarHeight());
        }
    }

    @Override
    public void setDayMode() {
        Log.v((String)LOG_TAG, (String)"-> setDayMode");
        ActionBar actionBar = this.actionBar;
        if (actionBar == null) {
            Intrinsics.throwNpe();
        }
        actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(ContextCompat.getColor((Context)((Context)this), (int)R.color.white)));
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwNpe();
        }
        toolbar.setTitleTextColor(ContextCompat.getColor((Context)((Context)this), (int)R.color.black));
    }

    @Override
    public void setNightMode() {
        Log.v((String)LOG_TAG, (String)"-> setNightMode");
        ActionBar actionBar = this.actionBar;
        if (actionBar == null) {
            Intrinsics.throwNpe();
        }
        actionBar.setBackgroundDrawable((Drawable)new ColorDrawable(ContextCompat.getColor((Context)((Context)this), (int)R.color.black)));
        Toolbar toolbar = this.toolbar;
        if (toolbar == null) {
            Intrinsics.throwNpe();
        }
        toolbar.setTitleTextColor(ContextCompat.getColor((Context)((Context)this), (int)R.color.night_title_text_color));
    }

    private final void initMediaController() {
        Log.v((String)LOG_TAG, (String)"-> initMediaController");
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"supportFragmentManager");
        this.mediaControllerFragment = MediaControllerFragment.Companion.getInstance(fragmentManager, this);
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.menu_main, menu2);
        Config config = AppUtil.Companion.getSavedConfig(this.getApplicationContext());
        if (config == null) {
            Intrinsics.throwNpe();
        }
        Config config2 = config;
        int n = config2.getThemeColor();
        MenuItem menuItem = menu2.findItem(R.id.itemSearch);
        Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"menu.findItem(R.id.itemSearch)");
        UiUtil.setColorIntToDrawable(n, menuItem.getIcon());
        int n2 = config2.getThemeColor();
        MenuItem menuItem2 = menu2.findItem(R.id.itemConfig);
        Intrinsics.checkExpressionValueIsNotNull((Object)menuItem2, (String)"menu.findItem(R.id.itemConfig)");
        UiUtil.setColorIntToDrawable(n2, menuItem2.getIcon());
        int n3 = config2.getThemeColor();
        MenuItem menuItem3 = menu2.findItem(R.id.itemTts);
        Intrinsics.checkExpressionValueIsNotNull((Object)menuItem3, (String)"menu.findItem(R.id.itemTts)");
        UiUtil.setColorIntToDrawable(n3, menuItem3.getIcon());
        if (!config2.isShowTts()) {
            MenuItem menuItem4 = menu2.findItem(R.id.itemTts);
            Intrinsics.checkExpressionValueIsNotNull((Object)menuItem4, (String)"menu.findItem(R.id.itemTts)");
            menuItem4.setVisible(false);
        }
        return true;
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        int itemId = item.getItemId();
        if (itemId == 16908332) {
            Log.v((String)LOG_TAG, (String)"-> onOptionsItemSelected -> drawer");
            this.startContentHighlightActivity();
            return true;
        }
        if (itemId == R.id.itemSearch) {
            Log.v((String)LOG_TAG, (String)("-> onOptionsItemSelected -> " + item.getTitle()));
            if (this.searchUri == null) {
                return true;
            }
            Intent intent = new Intent((Context)this, SearchActivity.class);
            List<Link> list = this.spine;
            intent.putExtra("BUNDLE_SPINE_SIZE", list != null ? list.size() : 0);
            intent.putExtra("BUNDLE_SEARCH_URI", (Parcelable)this.searchUri);
            intent.putExtra("DATA_BUNDLE", this.searchAdapterDataBundle);
            intent.putExtra("BUNDLE_SAVE_SEARCH_QUERY", this.searchQuery);
            this.startActivityForResult(intent, RequestCode.SEARCH.getValue$folioreader_release());
            return true;
        }
        if (itemId == R.id.itemConfig) {
            Log.v((String)LOG_TAG, (String)("-> onOptionsItemSelected -> " + item.getTitle()));
            this.showConfigBottomSheetDialogFragment();
            return true;
        }
        if (itemId == R.id.itemTts) {
            Log.v((String)LOG_TAG, (String)("-> onOptionsItemSelected -> " + item.getTitle()));
            this.showMediaController();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public final void startContentHighlightActivity() {
        Intent intent = new Intent((Context)this, ContentHighlightActivity.class);
        PubBox pubBox = this.pubBox;
        if (pubBox == null) {
            Intrinsics.throwNpe();
        }
        intent.putExtra("PUBLICATION", (Serializable)pubBox.getPublication());
        try {
            List<Link> list = this.spine;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            intent.putExtra("chapter_selected", list.get(this.currentChapterIndex).getHref());
        }
        catch (NullPointerException e) {
            Log.w((String)LOG_TAG, (String)"-> ", (Throwable)e);
            intent.putExtra("chapter_selected", "");
        }
        catch (IndexOutOfBoundsException e) {
            Log.w((String)LOG_TAG, (String)"-> ", (Throwable)e);
            intent.putExtra("chapter_selected", "");
        }
        intent.putExtra("com.folioreader.extra.BOOK_ID", this.mBookId);
        intent.putExtra("book_title", this.bookFileName);
        this.startActivityForResult(intent, RequestCode.CONTENT_HIGHLIGHT.getValue$folioreader_release());
        this.overridePendingTransition(R.anim.slide_in_up, R.anim.slide_out_up);
    }

    public final void showConfigBottomSheetDialogFragment() {
        new ConfigBottomSheetDialogFragment().show(this.getSupportFragmentManager(), ConfigBottomSheetDialogFragment.LOG_TAG);
    }

    public final void showMediaController() {
        MediaControllerFragment mediaControllerFragment = this.mediaControllerFragment;
        if (mediaControllerFragment == null) {
            Intrinsics.throwNpe();
        }
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"supportFragmentManager");
        mediaControllerFragment.show(fragmentManager);
    }

    private final void setupBook() {
        Log.v((String)LOG_TAG, (String)"-> setupBook");
        try {
            this.initBook();
            this.onBookInitSuccess();
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"-> Failed to initialize book", (Throwable)e);
            this.onBookInitFailure();
        }
    }

    private final void initBook() throws Exception {
        PubBox pubBox;
        Publication.EXTENSION extension;
        Log.v((String)LOG_TAG, (String)"-> initBook");
        Context context = (Context)this;
        EpubSourceType epubSourceType = this.mEpubSourceType;
        if (epubSourceType == null) {
            Intrinsics.throwNpe();
        }
        this.bookFileName = FileUtil.getEpubFilename(context, epubSourceType, this.mEpubFilePath, this.mEpubRawId);
        String path = FileUtil.saveEpubFileAndLoadLazyBook((Context)this, this.mEpubSourceType, this.mEpubFilePath, this.mEpubRawId, this.bookFileName);
        String extensionString = null;
        try {
            String string2 = extensionString = FileUtil.getExtensionUppercase(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"extensionString");
            extension = Publication.EXTENSION.valueOf((String)string2);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new Exception("-> Unknown book file extension `" + extensionString + '`', e);
        }
        switch (FolioActivity$WhenMappings.$EnumSwitchMapping$0[extension.ordinal()]) {
            case 1: {
                EpubParser epubParser = new EpubParser();
                String string3 = path;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                pubBox = epubParser.parse(string3, "");
                break;
            }
            case 2: {
                CbzParser cbzParser = new CbzParser();
                String string4 = path;
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                pubBox = cbzParser.parse(string4, "");
                break;
            }
            default: {
                pubBox = null;
            }
        }
        this.pubBox = pubBox;
        this.portNumber = this.getIntent().getIntExtra("com.folioreader.extra.PORT_NUMBER", 8080);
        this.portNumber = AppUtil.Companion.getAvailablePortNumber(this.portNumber);
        Server server = this.r2StreamerServer = new Server(this.portNumber);
        if (server == null) {
            Intrinsics.throwNpe();
        }
        PubBox pubBox2 = this.pubBox;
        if (pubBox2 == null) {
            Intrinsics.throwNpe();
        }
        Publication publication = pubBox2.getPublication();
        PubBox pubBox3 = this.pubBox;
        if (pubBox3 == null) {
            Intrinsics.throwNpe();
        }
        Container container = pubBox3.getContainer();
        StringBuilder stringBuilder = new StringBuilder().append("/");
        String string5 = this.bookFileName;
        if (string5 == null) {
            Intrinsics.throwNpe();
        }
        server.addEpub(publication, container, stringBuilder.append(string5).toString(), null);
        Server server2 = this.r2StreamerServer;
        if (server2 == null) {
            Intrinsics.throwNpe();
        }
        server2.start();
        FolioReader.initRetrofit(this.getStreamerUrl());
    }

    private final void onBookInitFailure() {
    }

    private final void onBookInitSuccess() {
        PubBox pubBox = this.pubBox;
        if (pubBox == null) {
            Intrinsics.throwNpe();
        }
        Publication publication = pubBox.getPublication();
        this.spine = publication.getReadingOrder();
        this.setTitle(publication.getMetadata().getTitle());
        if (this.mBookId == null) {
            CharSequence charSequence = publication.getMetadata().getIdentifier();
            if (!(charSequence.length() == 0)) {
                this.mBookId = publication.getMetadata().getIdentifier();
            } else {
                charSequence = publication.getMetadata().getTitle();
                if (!(charSequence.length() == 0)) {
                    this.mBookId = String.valueOf(publication.getMetadata().getTitle().hashCode());
                } else {
                    String string2 = this.bookFileName;
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mBookId = String.valueOf(string2.hashCode());
                }
            }
        }
        for (Link link : publication.getLinks()) {
            if (!link.getRel().contains("search")) continue;
            StringBuilder stringBuilder = new StringBuilder().append("http://");
            String string3 = link.getHref();
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            this.searchUri = Uri.parse((String)stringBuilder.append(string3).toString());
            break;
        }
        if (this.searchUri == null) {
            this.searchUri = Uri.parse((String)(this.getStreamerUrl() + "search"));
        }
        this.configFolio();
    }

    @Override
    @NotNull
    public String getStreamerUrl() {
        if (this.streamerUri == null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%s:%d/%s/";
            Object[] objectArray = new Object[]{"http://127.0.0.1", this.portNumber, this.bookFileName};
            FolioActivity folioActivity = this;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string3;
            folioActivity.streamerUri = Uri.parse((String)string4);
        }
        return String.valueOf(this.streamerUri);
    }

    @Override
    public void onDirectionChange(@NotNull Config.Direction newDirection) {
        block6: {
            SearchLocator searchLocator;
            FolioPageFragment folioPageFragment;
            Intrinsics.checkParameterIsNotNull((Object)((Object)newDirection), (String)"newDirection");
            Log.v((String)LOG_TAG, (String)"-> onDirectionChange");
            FolioPageFragment folioPageFragment2 = this.getCurrentFragment();
            if (folioPageFragment2 == null) {
                return;
            }
            FolioPageFragment folioPageFragment3 = folioPageFragment = folioPageFragment2;
            if (folioPageFragment3 == null) {
                Intrinsics.throwNpe();
            }
            this.entryReadLocator = folioPageFragment3.getLastReadLocator();
            SearchLocator searchLocatorVisible = folioPageFragment.getSearchLocatorVisible();
            this.direction = newDirection;
            DirectionalViewpager directionalViewpager = this.mFolioPageViewPager;
            if (directionalViewpager == null) {
                Intrinsics.throwNpe();
            }
            directionalViewpager.setDirection(newDirection);
            this.mFolioPageFragmentAdapter = new FolioPageFragmentAdapter(this.getSupportFragmentManager(), this.spine, this.bookFileName, this.mBookId);
            DirectionalViewpager directionalViewpager2 = this.mFolioPageViewPager;
            if (directionalViewpager2 == null) {
                Intrinsics.throwNpe();
            }
            directionalViewpager2.setAdapter((PagerAdapter)this.mFolioPageFragmentAdapter);
            DirectionalViewpager directionalViewpager3 = this.mFolioPageViewPager;
            if (directionalViewpager3 == null) {
                Intrinsics.throwNpe();
            }
            directionalViewpager3.setCurrentItem(this.currentChapterIndex);
            FolioPageFragment folioPageFragment4 = this.getCurrentFragment();
            if (folioPageFragment4 == null) {
                return;
            }
            folioPageFragment = folioPageFragment4;
            SearchLocator searchLocator2 = searchLocatorVisible;
            if (searchLocator2 == null) break block6;
            SearchLocator it = searchLocator = searchLocator2;
            folioPageFragment.highlightSearchLocator(searchLocatorVisible);
        }
    }

    private final void initDistractionFreeMode(Bundle savedInstanceState) {
        Log.v((String)LOG_TAG, (String)"-> initDistractionFreeMode");
        Window window = this.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
        window.getDecorView().setOnSystemUiVisibilityChangeListener((View.OnSystemUiVisibilityChangeListener)this);
        this.hideSystemUI();
        this.showSystemUI();
        this.distractionFreeMode = savedInstanceState != null && savedInstanceState.getBoolean(BUNDLE_DISTRACTION_FREE_MODE);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        Log.v((String)LOG_TAG, (String)"-> onPostCreate");
        if (this.distractionFreeMode) {
            Handler handler = this.handler;
            if (handler == null) {
                Intrinsics.throwNpe();
            }
            handler.post(new Runnable(this){
                final /* synthetic */ FolioActivity this$0;

                public final void run() {
                    FolioActivity.access$hideSystemUI(this.this$0);
                }
                {
                    this.this$0 = folioActivity;
                }
            });
        }
    }

    @Override
    public int getTopDistraction(@NotNull DisplayUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        int topDistraction = 0;
        if (!this.distractionFreeMode) {
            topDistraction = this.getStatusBarHeight();
            if (this.actionBar != null) {
                ActionBar actionBar = this.actionBar;
                if (actionBar == null) {
                    Intrinsics.throwNpe();
                }
                topDistraction += actionBar.getHeight();
            }
        }
        switch (FolioActivity$WhenMappings.$EnumSwitchMapping$1[unit.ordinal()]) {
            case 1: {
                return topDistraction;
            }
            case 2: {
                return topDistraction /= (int)this.density;
            }
        }
        throw (Throwable)new IllegalArgumentException("-> Illegal argument -> unit = " + (Object)((Object)unit));
    }

    @Override
    public int getBottomDistraction(@NotNull DisplayUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        int bottomDistraction = 0;
        if (!this.distractionFreeMode) {
            FolioAppBarLayout folioAppBarLayout = this.appBarLayout;
            if (folioAppBarLayout == null) {
                Intrinsics.throwNpe();
            }
            bottomDistraction = folioAppBarLayout.getNavigationBarHeight();
        }
        switch (FolioActivity$WhenMappings.$EnumSwitchMapping$2[unit.ordinal()]) {
            case 1: {
                return bottomDistraction;
            }
            case 2: {
                return bottomDistraction /= (int)this.density;
            }
        }
        throw (Throwable)new IllegalArgumentException("-> Illegal argument -> unit = " + (Object)((Object)unit));
    }

    private final Rect computeViewportRect() {
        FolioAppBarLayout folioAppBarLayout = this.appBarLayout;
        if (folioAppBarLayout == null) {
            Intrinsics.throwNpe();
        }
        Rect viewportRect = new Rect(folioAppBarLayout.getInsets());
        if (this.distractionFreeMode) {
            viewportRect.left = 0;
        }
        viewportRect.top = this.getTopDistraction(DisplayUnit.PX);
        if (this.distractionFreeMode) {
            DisplayMetrics displayMetrics = this.displayMetrics;
            if (displayMetrics == null) {
                Intrinsics.throwNpe();
            }
            viewportRect.right = displayMetrics.widthPixels;
        } else {
            DisplayMetrics displayMetrics = this.displayMetrics;
            if (displayMetrics == null) {
                Intrinsics.throwNpe();
            }
            viewportRect.right = displayMetrics.widthPixels - viewportRect.right;
        }
        DisplayMetrics displayMetrics = this.displayMetrics;
        if (displayMetrics == null) {
            Intrinsics.throwNpe();
        }
        viewportRect.bottom = displayMetrics.heightPixels - this.getBottomDistraction(DisplayUnit.PX);
        return viewportRect;
    }

    @Override
    @NotNull
    public Rect getViewportRect(@NotNull DisplayUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        Rect viewportRect = this.computeViewportRect();
        switch (FolioActivity$WhenMappings.$EnumSwitchMapping$3[unit.ordinal()]) {
            case 1: {
                return viewportRect;
            }
            case 2: {
                viewportRect.left /= (int)this.density;
                viewportRect.top /= (int)this.density;
                viewportRect.right /= (int)this.density;
                viewportRect.bottom /= (int)this.density;
                return viewportRect;
            }
            case 3: {
                viewportRect.left = (int)Math.ceil((float)viewportRect.left / this.density);
                viewportRect.top = (int)Math.ceil((float)viewportRect.top / this.density);
                viewportRect.right = (int)Math.ceil((float)viewportRect.right / this.density);
                viewportRect.bottom = (int)Math.ceil((float)viewportRect.bottom / this.density);
                return viewportRect;
            }
        }
        throw (Throwable)new IllegalArgumentException("-> Illegal argument -> unit = " + (Object)((Object)unit));
    }

    @Override
    @NotNull
    public WeakReference<FolioActivity> getActivity() {
        return new WeakReference<FolioActivity>(this);
    }

    public void onSystemUiVisibilityChange(int visibility) {
        Log.v((String)LOG_TAG, (String)("-> onSystemUiVisibilityChange -> visibility = " + visibility));
        this.distractionFreeMode = visibility != 0;
        Log.v((String)LOG_TAG, (String)("-> distractionFreeMode = " + this.distractionFreeMode));
        if (this.actionBar != null) {
            if (this.distractionFreeMode) {
                ActionBar actionBar = this.actionBar;
                if (actionBar == null) {
                    Intrinsics.throwNpe();
                }
                actionBar.hide();
            } else {
                ActionBar actionBar = this.actionBar;
                if (actionBar == null) {
                    Intrinsics.throwNpe();
                }
                actionBar.show();
            }
        }
    }

    @Override
    public void toggleSystemUI() {
        if (this.distractionFreeMode) {
            this.showSystemUI();
        } else {
            this.hideSystemUI();
        }
    }

    private final void showSystemUI() {
        Log.v((String)LOG_TAG, (String)"-> showSystemUI");
        if (Build.VERSION.SDK_INT >= 16) {
            View decorView;
            Window window = this.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
            View view = decorView = window.getDecorView();
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"decorView");
            view.setSystemUiVisibility(1792);
        } else {
            this.getWindow().clearFlags(1024);
            if (this.appBarLayout != null) {
                FolioAppBarLayout folioAppBarLayout = this.appBarLayout;
                if (folioAppBarLayout == null) {
                    Intrinsics.throwNpe();
                }
                folioAppBarLayout.setTopMargin(this.getStatusBarHeight());
            }
            this.onSystemUiVisibilityChange(0);
        }
    }

    private final void hideSystemUI() {
        Log.v((String)LOG_TAG, (String)"-> hideSystemUI");
        if (Build.VERSION.SDK_INT >= 16) {
            View decorView;
            Window window = this.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"window");
            View view = decorView = window.getDecorView();
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"decorView");
            view.setSystemUiVisibility(3846);
        } else {
            this.getWindow().setFlags(1536, 1536);
            this.onSystemUiVisibilityChange(1);
        }
    }

    @Override
    @Nullable
    public ReadLocator getEntryReadLocator() {
        if (this.entryReadLocator != null) {
            ReadLocator tempReadLocator = this.entryReadLocator;
            this.entryReadLocator = null;
            return tempReadLocator;
        }
        return null;
    }

    @Override
    public boolean goToChapter(@NotNull String href) {
        Intrinsics.checkParameterIsNotNull((Object)href, (String)"href");
        List<Link> list = this.spine;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        for (Link link : list) {
            FolioPageFragment folioPageFragment;
            CharSequence charSequence = href;
            String string2 = link.getHref();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
            List<Link> list2 = this.spine;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            this.currentChapterIndex = list2.indexOf(link);
            DirectionalViewpager directionalViewpager = this.mFolioPageViewPager;
            if (directionalViewpager == null) {
                Intrinsics.throwNpe();
            }
            directionalViewpager.setCurrentItem(this.currentChapterIndex);
            FolioPageFragment folioPageFragment2 = folioPageFragment = this.getCurrentFragment();
            if (folioPageFragment2 == null) {
                Intrinsics.throwNpe();
            }
            folioPageFragment2.scrollToFirst();
            folioPageFragment.scrollToAnchorId(href);
            return true;
        }
        return false;
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == RequestCode.SEARCH.getValue$folioreader_release()) {
            Log.v((String)LOG_TAG, (String)("-> onActivityResult -> " + (Object)((Object)RequestCode.SEARCH)));
            if (resultCode == 0) {
                return;
            }
            Intent intent = data;
            if (intent == null) {
                Intrinsics.throwNpe();
            }
            this.searchAdapterDataBundle = intent.getBundleExtra("DATA_BUNDLE");
            this.searchQuery = data.getCharSequenceExtra("BUNDLE_SAVE_SEARCH_QUERY");
            if (resultCode == SearchActivity.ResultCode.ITEM_SELECTED.getValue()) {
                this.searchLocator = (SearchLocator)data.getParcelableExtra(EXTRA_SEARCH_ITEM);
                if (this.mFolioPageViewPager == null) {
                    return;
                }
                SearchLocator searchLocator = this.searchLocator;
                if (searchLocator == null) {
                    Intrinsics.throwNpe();
                }
                this.currentChapterIndex = this.getChapterIndex("href", searchLocator.getHref());
                DirectionalViewpager directionalViewpager = this.mFolioPageViewPager;
                if (directionalViewpager == null) {
                    Intrinsics.throwNpe();
                }
                directionalViewpager.setCurrentItem(this.currentChapterIndex);
                FolioPageFragment folioPageFragment = this.getCurrentFragment();
                if (folioPageFragment == null) {
                    return;
                }
                FolioPageFragment folioPageFragment2 = folioPageFragment;
                SearchLocator searchLocator2 = this.searchLocator;
                if (searchLocator2 == null) {
                    Intrinsics.throwNpe();
                }
                folioPageFragment2.highlightSearchLocator(searchLocator2);
                this.searchLocator = null;
            }
        } else if (requestCode == RequestCode.CONTENT_HIGHLIGHT.getValue$folioreader_release() && resultCode == -1) {
            Intent intent = data;
            if (intent == null) {
                Intrinsics.throwNpe();
            }
            if (intent.hasExtra("type")) {
                String type = data.getStringExtra("type");
                if (Intrinsics.areEqual((Object)type, (Object)"chapter_selected")) {
                    String string2 = data.getStringExtra("selected_chapter_position");
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.getStringExtra(SELECTED_CHAPTER_POSITION)");
                    this.goToChapter(string2);
                } else if (Intrinsics.areEqual((Object)type, (Object)"highlight_selected")) {
                    HighlightImpl highlightImpl;
                    HighlightImpl highlightImpl2 = highlightImpl = (HighlightImpl)data.getParcelableExtra(HIGHLIGHT_ITEM);
                    Intrinsics.checkExpressionValueIsNotNull((Object)highlightImpl2, (String)"highlightImpl");
                    this.currentChapterIndex = highlightImpl2.getPageNumber();
                    DirectionalViewpager directionalViewpager = this.mFolioPageViewPager;
                    if (directionalViewpager == null) {
                        Intrinsics.throwNpe();
                    }
                    directionalViewpager.setCurrentItem(this.currentChapterIndex);
                    FolioPageFragment folioPageFragment = this.getCurrentFragment();
                    if (folioPageFragment == null) {
                        return;
                    }
                    FolioPageFragment folioPageFragment3 = folioPageFragment;
                    String string3 = highlightImpl.getRangy();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"highlightImpl.rangy");
                    folioPageFragment3.scrollToHighlightId(string3);
                }
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.outState != null) {
            Bundle bundle = this.outState;
            if (bundle == null) {
                Intrinsics.throwNpe();
            }
            bundle.putSerializable(BUNDLE_READ_LOCATOR_CONFIG_CHANGE, (Serializable)((Object)this.lastReadLocator));
        }
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        Intrinsics.checkExpressionValueIsNotNull((Object)localBroadcastManager, (String)"LocalBroadcastManager.getInstance(this)");
        LocalBroadcastManager localBroadcastManager2 = localBroadcastManager;
        localBroadcastManager2.unregisterReceiver((BroadcastReceiver)this.searchReceiver);
        localBroadcastManager2.unregisterReceiver((BroadcastReceiver)this.closeBroadcastReceiver);
        if (this.r2StreamerServer != null) {
            Server server = this.r2StreamerServer;
            if (server == null) {
                Intrinsics.throwNpe();
            }
            server.stop();
        }
        if (this.isFinishing()) {
            localBroadcastManager2.sendBroadcast(new Intent("com.folioreader.action.FOLIOREADER_CLOSED"));
            FolioReader.get().retrofit = null;
            FolioReader.get().r2StreamerApi = null;
        }
    }

    @Override
    public int getCurrentChapterIndex() {
        return this.currentChapterIndex;
    }

    private final void configFolio() {
        DirectionalViewpager directionalViewpager = this.mFolioPageViewPager = (DirectionalViewpager)this.findViewById(R.id.folioPageViewPager);
        if (directionalViewpager == null) {
            Intrinsics.throwNpe();
        }
        directionalViewpager.setOnPageChangeListener(new DirectionalViewpager.OnPageChangeListener(this){
            final /* synthetic */ FolioActivity this$0;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                Log.v((String)FolioActivity.LOG_TAG, (String)("-> onPageSelected -> DirectionalViewpager -> position = " + position));
                EventBus eventBus = EventBus.getDefault();
                List list = FolioActivity.access$getSpine$p(this.this$0);
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                eventBus.post((Object)new MediaOverlayPlayPauseEvent(((Link)list.get(FolioActivity.access$getCurrentChapterIndex$p(this.this$0))).getHref(), false, true));
                MediaControllerFragment mediaControllerFragment = FolioActivity.access$getMediaControllerFragment$p(this.this$0);
                if (mediaControllerFragment == null) {
                    Intrinsics.throwNpe();
                }
                mediaControllerFragment.setPlayButtonDrawable();
                FolioActivity.access$setCurrentChapterIndex$p(this.this$0, position);
            }

            public void onPageScrollStateChanged(int state) {
                if (state == 0) {
                    FolioPageFragment folioPageFragment;
                    DirectionalViewpager directionalViewpager = FolioActivity.access$getMFolioPageViewPager$p(this.this$0);
                    if (directionalViewpager == null) {
                        Intrinsics.throwNpe();
                    }
                    int position = directionalViewpager.getCurrentItem();
                    Log.v((String)FolioActivity.LOG_TAG, (String)("-> onPageScrollStateChanged -> DirectionalViewpager -> position = " + position));
                    FolioPageFragmentAdapter folioPageFragmentAdapter = FolioActivity.access$getMFolioPageFragmentAdapter$p(this.this$0);
                    if (folioPageFragmentAdapter == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((folioPageFragment = (FolioPageFragment)folioPageFragmentAdapter.getItem(position - 1)) != null) {
                        folioPageFragment.scrollToLast();
                        if (folioPageFragment.getMWebview() != null) {
                            FolioWebView folioWebView = folioPageFragment.getMWebview();
                            if (folioWebView == null) {
                                Intrinsics.throwNpe();
                            }
                            folioWebView.dismissPopupWindow();
                        }
                    }
                    FolioPageFragmentAdapter folioPageFragmentAdapter2 = FolioActivity.access$getMFolioPageFragmentAdapter$p(this.this$0);
                    if (folioPageFragmentAdapter2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((folioPageFragment = (FolioPageFragment)folioPageFragmentAdapter2.getItem(position + 1)) != null) {
                        folioPageFragment.scrollToFirst();
                        if (folioPageFragment.getMWebview() != null) {
                            FolioWebView folioWebView = folioPageFragment.getMWebview();
                            if (folioWebView == null) {
                                Intrinsics.throwNpe();
                            }
                            folioWebView.dismissPopupWindow();
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        DirectionalViewpager directionalViewpager2 = this.mFolioPageViewPager;
        if (directionalViewpager2 == null) {
            Intrinsics.throwNpe();
        }
        directionalViewpager2.setDirection(this.direction);
        this.mFolioPageFragmentAdapter = new FolioPageFragmentAdapter(this.getSupportFragmentManager(), this.spine, this.bookFileName, this.mBookId);
        DirectionalViewpager directionalViewpager3 = this.mFolioPageViewPager;
        if (directionalViewpager3 == null) {
            Intrinsics.throwNpe();
        }
        directionalViewpager3.setAdapter((PagerAdapter)this.mFolioPageFragmentAdapter);
        if (this.searchLocator != null) {
            SearchLocator searchLocator = this.searchLocator;
            if (searchLocator == null) {
                Intrinsics.throwNpe();
            }
            this.currentChapterIndex = this.getChapterIndex("href", searchLocator.getHref());
            DirectionalViewpager directionalViewpager4 = this.mFolioPageViewPager;
            if (directionalViewpager4 == null) {
                Intrinsics.throwNpe();
            }
            directionalViewpager4.setCurrentItem(this.currentChapterIndex);
            FolioPageFragment folioPageFragment = this.getCurrentFragment();
            if (folioPageFragment == null) {
                return;
            }
            FolioPageFragment folioPageFragment2 = folioPageFragment;
            SearchLocator searchLocator2 = this.searchLocator;
            if (searchLocator2 == null) {
                Intrinsics.throwNpe();
            }
            folioPageFragment2.highlightSearchLocator(searchLocator2);
            this.searchLocator = null;
        } else {
            ReadLocator readLocator;
            if (this.savedInstanceState == null) {
                this.entryReadLocator = readLocator = (ReadLocator)this.getIntent().getParcelableExtra(EXTRA_READ_LOCATOR);
            } else {
                Bundle bundle = this.savedInstanceState;
                if (bundle == null) {
                    Intrinsics.throwNpe();
                }
                this.lastReadLocator = readLocator = (ReadLocator)bundle.getParcelable(BUNDLE_READ_LOCATOR_CONFIG_CHANGE);
            }
            this.currentChapterIndex = this.getChapterIndex(readLocator);
            DirectionalViewpager directionalViewpager5 = this.mFolioPageViewPager;
            if (directionalViewpager5 == null) {
                Intrinsics.throwNpe();
            }
            directionalViewpager5.setCurrentItem(this.currentChapterIndex);
        }
        LocalBroadcastManager.getInstance((Context)((Context)this)).registerReceiver((BroadcastReceiver)this.searchReceiver, new IntentFilter(ACTION_SEARCH_CLEAR));
    }

    private final int getChapterIndex(ReadLocator readLocator) {
        if (readLocator == null) {
            return 0;
        }
        if (!TextUtils.isEmpty((CharSequence)readLocator.getHref())) {
            return this.getChapterIndex("href", readLocator.getHref());
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int getChapterIndex(String caseString, String value) {
        int n = 0;
        List<Link> list = this.spine;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        int n2 = ((Collection)list).size();
        while (n < n2) {
            void i;
            String string2 = caseString;
            switch (string2.hashCode()) {
                case 3211051: {
                    if (!string2.equals("href")) break;
                    List<Link> list2 = this.spine;
                    if (list2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!Intrinsics.areEqual((Object)list2.get((int)i).getHref(), (Object)value)) break;
                    return (int)i;
                }
            }
            ++i;
        }
        return 0;
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        Log.v((String)LOG_TAG, (String)"-> onSaveInstanceState");
        this.outState = outState;
        outState.putBoolean(BUNDLE_DISTRACTION_FREE_MODE, this.distractionFreeMode);
        outState.putBundle("DATA_BUNDLE", this.searchAdapterDataBundle);
        outState.putCharSequence("BUNDLE_SAVE_SEARCH_QUERY", this.searchQuery);
    }

    @Override
    public void storeLastReadLocator(@NotNull ReadLocator lastReadLocator) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)lastReadLocator), (String)"lastReadLocator");
        Log.v((String)LOG_TAG, (String)"-> storeLastReadLocator");
        this.lastReadLocator = lastReadLocator;
    }

    private final void setConfig(Bundle savedInstanceState) {
        Config intentConfig = (Config)this.getIntent().getParcelableExtra("config");
        boolean overrideConfig = this.getIntent().getBooleanExtra("com.folioreader.extra.OVERRIDE_CONFIG", false);
        Config savedConfig = AppUtil.Companion.getSavedConfig((Context)this);
        Config config = savedInstanceState != null ? savedConfig : (savedConfig == null ? (intentConfig == null ? new Config() : intentConfig) : (intentConfig != null && overrideConfig ? intentConfig : savedConfig));
        if (config == null) {
            config = new Config();
        }
        AppUtil.Companion.saveConfig((Context)this, config);
        Config.Direction direction = config.getDirection();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)direction), (String)"config.direction");
        this.direction = direction;
    }

    @Override
    public void play() {
        EventBus eventBus = EventBus.getDefault();
        List<Link> list = this.spine;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        eventBus.post((Object)new MediaOverlayPlayPauseEvent(list.get(this.currentChapterIndex).getHref(), true, false));
    }

    @Override
    public void pause() {
        EventBus eventBus = EventBus.getDefault();
        List<Link> list = this.spine;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        eventBus.post((Object)new MediaOverlayPlayPauseEvent(list.get(this.currentChapterIndex).getHref(), false, false));
    }

    public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
        Intrinsics.checkParameterIsNotNull((Object)permissions, (String)"permissions");
        Intrinsics.checkParameterIsNotNull((Object)grantResults, (String)"grantResults");
        switch (requestCode) {
            case 102: {
                if (grantResults[0] == 0) {
                    this.setupBook();
                    break;
                }
                Toast.makeText((Context)((Context)this), (CharSequence)this.getString(R.string.cannot_access_epub_message), (int)1).show();
                this.finish();
            }
        }
    }

    @Override
    @NotNull
    public Config.Direction getDirection() {
        return this.direction;
    }

    /*
     * WARNING - void declaration
     */
    private final void clearSearchLocator() {
        ArrayList<Fragment.SavedState> savedStateList;
        Log.v((String)LOG_TAG, (String)"-> clearSearchLocator");
        FolioPageFragmentAdapter folioPageFragmentAdapter = this.mFolioPageFragmentAdapter;
        if (folioPageFragmentAdapter == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<Fragment> fragments = folioPageFragmentAdapter.getFragments();
        int n = 0;
        ArrayList<Fragment> arrayList = fragments;
        Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"fragments");
        int n2 = ((Collection)arrayList).size();
        while (n < n2) {
            void i;
            FolioPageFragment folioPageFragment;
            FolioPageFragment folioPageFragment2 = folioPageFragment = (FolioPageFragment)fragments.get((int)i);
            if (folioPageFragment2 != null) {
                folioPageFragment2.clearSearchLocator();
            }
            ++i;
        }
        FolioPageFragmentAdapter folioPageFragmentAdapter2 = this.mFolioPageFragmentAdapter;
        if (folioPageFragmentAdapter2 == null) {
            Intrinsics.throwNpe();
        }
        if ((savedStateList = folioPageFragmentAdapter2.getSavedStateList()) != null) {
            n2 = 0;
            int n3 = ((Collection)savedStateList).size();
            while (n2 < n3) {
                Bundle bundle;
                void i;
                Fragment.SavedState savedState = savedStateList.get((int)i);
                Bundle bundle2 = bundle = FolioPageFragmentAdapter.getBundleFromSavedState(savedState);
                if (bundle2 != null) {
                    bundle2.putParcelable("BUNDLE_SEARCH_LOCATOR", null);
                }
                ++i;
            }
        }
    }

    static {
        Companion = new Companion(null);
        String string2 = FolioActivity.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FolioActivity::class.java.simpleName");
        LOG_TAG = string2;
    }

    public static final /* synthetic */ void access$hideSystemUI(FolioActivity $this) {
        $this.hideSystemUI();
    }

    @Nullable
    public static final /* synthetic */ List access$getSpine$p(FolioActivity $this) {
        return $this.spine;
    }

    public static final /* synthetic */ void access$setSpine$p(FolioActivity $this, @Nullable List list) {
        $this.spine = list;
    }

    public static final /* synthetic */ int access$getCurrentChapterIndex$p(FolioActivity $this) {
        return $this.currentChapterIndex;
    }

    public static final /* synthetic */ void access$setCurrentChapterIndex$p(FolioActivity $this, int n) {
        $this.currentChapterIndex = n;
    }

    @Nullable
    public static final /* synthetic */ MediaControllerFragment access$getMediaControllerFragment$p(FolioActivity $this) {
        return $this.mediaControllerFragment;
    }

    public static final /* synthetic */ void access$setMediaControllerFragment$p(FolioActivity $this, @Nullable MediaControllerFragment mediaControllerFragment) {
        $this.mediaControllerFragment = mediaControllerFragment;
    }

    @Nullable
    public static final /* synthetic */ DirectionalViewpager access$getMFolioPageViewPager$p(FolioActivity $this) {
        return $this.mFolioPageViewPager;
    }

    public static final /* synthetic */ void access$setMFolioPageViewPager$p(FolioActivity $this, @Nullable DirectionalViewpager directionalViewpager) {
        $this.mFolioPageViewPager = directionalViewpager;
    }

    @Nullable
    public static final /* synthetic */ FolioPageFragmentAdapter access$getMFolioPageFragmentAdapter$p(FolioActivity $this) {
        return $this.mFolioPageFragmentAdapter;
    }

    public static final /* synthetic */ void access$setMFolioPageFragmentAdapter$p(FolioActivity $this, @Nullable FolioPageFragmentAdapter folioPageFragmentAdapter) {
        $this.mFolioPageFragmentAdapter = folioPageFragmentAdapter;
    }

    public static final /* synthetic */ int access$getTaskImportance$p(FolioActivity $this) {
        return $this.taskImportance;
    }

    public static final /* synthetic */ void access$setTaskImportance$p(FolioActivity $this, int n) {
        $this.taskImportance = n;
    }

    public static final /* synthetic */ void access$clearSearchLocator(FolioActivity $this) {
        $this.clearSearchLocator();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/folioreader/ui/activity/FolioActivity$EpubSourceType;", "", "(Ljava/lang/String;I)V", "RAW", "ASSETS", "SD_CARD", "folioreader_release"})
    public static final class EpubSourceType
    extends Enum<EpubSourceType> {
        public static final /* enum */ EpubSourceType RAW;
        public static final /* enum */ EpubSourceType ASSETS;
        public static final /* enum */ EpubSourceType SD_CARD;
        private static final /* synthetic */ EpubSourceType[] $VALUES;

        static {
            EpubSourceType[] epubSourceTypeArray = new EpubSourceType[3];
            EpubSourceType[] epubSourceTypeArray2 = epubSourceTypeArray;
            epubSourceTypeArray[0] = RAW = new EpubSourceType();
            epubSourceTypeArray[1] = ASSETS = new EpubSourceType();
            epubSourceTypeArray[2] = SD_CARD = new EpubSourceType();
            $VALUES = epubSourceTypeArray;
        }

        public static EpubSourceType[] values() {
            return (EpubSourceType[])$VALUES.clone();
        }

        public static EpubSourceType valueOf(String string2) {
            return Enum.valueOf(EpubSourceType.class, string2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/folioreader/ui/activity/FolioActivity$RequestCode;", "", "value", "", "(Ljava/lang/String;II)V", "getValue$folioreader_release", "()I", "CONTENT_HIGHLIGHT", "SEARCH", "folioreader_release"})
    private static final class RequestCode
    extends Enum<RequestCode> {
        public static final /* enum */ RequestCode CONTENT_HIGHLIGHT;
        public static final /* enum */ RequestCode SEARCH;
        private static final /* synthetic */ RequestCode[] $VALUES;
        private final int value;

        static {
            RequestCode[] requestCodeArray = new RequestCode[2];
            RequestCode[] requestCodeArray2 = requestCodeArray;
            requestCodeArray[0] = CONTENT_HIGHLIGHT = new RequestCode(77);
            requestCodeArray[1] = SEARCH = new RequestCode(101);
            $VALUES = requestCodeArray;
        }

        public final int getValue$folioreader_release() {
            return this.value;
        }

        protected RequestCode(int value) {
            this.value = value;
        }

        public static RequestCode[] values() {
            return (RequestCode[])$VALUES.clone();
        }

        public static RequestCode valueOf(String string2) {
            return Enum.valueOf(RequestCode.class, string2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/folioreader/ui/activity/FolioActivity$Companion;", "", "()V", "ACTION_SEARCH_CLEAR", "", "BUNDLE_DISTRACTION_FREE_MODE", "BUNDLE_READ_LOCATOR_CONFIG_CHANGE", "EXTRA_READ_LOCATOR", "EXTRA_SEARCH_ITEM", "HIGHLIGHT_ITEM", "INTENT_EPUB_SOURCE_PATH", "INTENT_EPUB_SOURCE_TYPE", "LOG_TAG", "folioreader_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

