/*
 * Decompiled with CFR 0.152.
 */
package com.folioreader;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.folioreader.AppContext;
import com.folioreader.Config;
import com.folioreader.model.HighLight;
import com.folioreader.model.HighlightImpl;
import com.folioreader.model.locators.ReadLocator;
import com.folioreader.model.sqlite.DbAdapter;
import com.folioreader.network.QualifiedTypeConverterFactory;
import com.folioreader.network.R2StreamerApi;
import com.folioreader.ui.activity.FolioActivity;
import com.folioreader.ui.base.OnSaveHighlight;
import com.folioreader.ui.base.SaveReceivedHighlightTask;
import com.folioreader.util.OnHighlightListener;
import com.folioreader.util.ReadLocatorListener;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class FolioReader {
    @SuppressLint(value={"StaticFieldLeak"})
    private static FolioReader singleton = null;
    public static final String EXTRA_BOOK_ID = "com.folioreader.extra.BOOK_ID";
    public static final String EXTRA_READ_LOCATOR = "com.folioreader.extra.READ_LOCATOR";
    public static final String EXTRA_PORT_NUMBER = "com.folioreader.extra.PORT_NUMBER";
    public static final String ACTION_SAVE_READ_LOCATOR = "com.folioreader.action.SAVE_READ_LOCATOR";
    public static final String ACTION_CLOSE_FOLIOREADER = "com.folioreader.action.CLOSE_FOLIOREADER";
    public static final String ACTION_FOLIOREADER_CLOSED = "com.folioreader.action.FOLIOREADER_CLOSED";
    private Context context;
    private Config config;
    private boolean overrideConfig;
    private int portNumber = 8080;
    private OnHighlightListener onHighlightListener;
    private ReadLocatorListener readLocatorListener;
    private OnClosedListener onClosedListener;
    private ReadLocator readLocator;
    @Nullable
    public Retrofit retrofit;
    @Nullable
    public R2StreamerApi r2StreamerApi;
    private BroadcastReceiver highlightReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HighlightImpl highlightImpl = (HighlightImpl)intent.getParcelableExtra(HighlightImpl.INTENT);
            HighLight.HighLightAction action = (HighLight.HighLightAction)((Object)intent.getSerializableExtra(HighLight.HighLightAction.class.getName()));
            if (FolioReader.this.onHighlightListener != null && highlightImpl != null && action != null) {
                FolioReader.this.onHighlightListener.onHighlight(highlightImpl, action);
            }
        }
    };
    private BroadcastReceiver readLocatorReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ReadLocator readLocator = (ReadLocator)((Object)intent.getSerializableExtra(FolioReader.EXTRA_READ_LOCATOR));
            if (FolioReader.this.readLocatorListener != null) {
                FolioReader.this.readLocatorListener.saveReadLocator(readLocator);
            }
        }
    };
    private BroadcastReceiver closedReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (FolioReader.this.onClosedListener != null) {
                FolioReader.this.onClosedListener.onFolioReaderClosed();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FolioReader get() {
        if (singleton != null) return singleton;
        Class<FolioReader> clazz = FolioReader.class;
        synchronized (FolioReader.class) {
            if (singleton != null) return singleton;
            if (AppContext.get() == null) {
                throw new IllegalStateException("-> context == null");
            }
            singleton = new FolioReader(AppContext.get());
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    private FolioReader() {
    }

    private FolioReader(Context context) {
        this.context = context;
        DbAdapter.initialize(context);
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
        localBroadcastManager.registerReceiver(this.highlightReceiver, new IntentFilter("highlight_broadcast_event"));
        localBroadcastManager.registerReceiver(this.readLocatorReceiver, new IntentFilter(ACTION_SAVE_READ_LOCATOR));
        localBroadcastManager.registerReceiver(this.closedReceiver, new IntentFilter(ACTION_FOLIOREADER_CLOSED));
    }

    public FolioReader openBook(String assetOrSdcardPath) {
        Intent intent = this.getIntentFromUrl(assetOrSdcardPath, 0);
        this.context.startActivity(intent);
        return singleton;
    }

    public FolioReader openBook(int rawId) {
        Intent intent = this.getIntentFromUrl(null, rawId);
        this.context.startActivity(intent);
        return singleton;
    }

    public FolioReader openBook(String assetOrSdcardPath, String bookId) {
        Intent intent = this.getIntentFromUrl(assetOrSdcardPath, 0);
        intent.putExtra(EXTRA_BOOK_ID, bookId);
        this.context.startActivity(intent);
        return singleton;
    }

    public FolioReader openBook(int rawId, String bookId) {
        Intent intent = this.getIntentFromUrl(null, rawId);
        intent.putExtra(EXTRA_BOOK_ID, bookId);
        this.context.startActivity(intent);
        return singleton;
    }

    private Intent getIntentFromUrl(String assetOrSdcardPath, int rawId) {
        Intent intent = new Intent(this.context, FolioActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra("config", (Parcelable)this.config);
        intent.putExtra("com.folioreader.extra.OVERRIDE_CONFIG", this.overrideConfig);
        intent.putExtra(EXTRA_PORT_NUMBER, this.portNumber);
        intent.putExtra(EXTRA_READ_LOCATOR, (Parcelable)this.readLocator);
        if (rawId != 0) {
            intent.putExtra("com.folioreader.epub_asset_path", rawId);
            intent.putExtra("epub_source_type", (Serializable)((Object)FolioActivity.EpubSourceType.RAW));
        } else if (assetOrSdcardPath.contains("file:///android_asset/")) {
            intent.putExtra("com.folioreader.epub_asset_path", assetOrSdcardPath);
            intent.putExtra("epub_source_type", (Serializable)((Object)FolioActivity.EpubSourceType.ASSETS));
        } else {
            intent.putExtra("com.folioreader.epub_asset_path", assetOrSdcardPath);
            intent.putExtra("epub_source_type", (Serializable)((Object)FolioActivity.EpubSourceType.SD_CARD));
        }
        return intent;
    }

    public FolioReader setConfig(Config config, boolean overrideConfig) {
        this.config = config;
        this.overrideConfig = overrideConfig;
        return singleton;
    }

    public FolioReader setPortNumber(int portNumber) {
        this.portNumber = portNumber;
        return singleton;
    }

    public static void initRetrofit(String streamerUrl) {
        if (singleton == null || FolioReader.singleton.retrofit != null) {
            return;
        }
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).build();
        FolioReader.singleton.retrofit = new Retrofit.Builder().baseUrl(streamerUrl).addConverterFactory((Converter.Factory)new QualifiedTypeConverterFactory((Converter.Factory)JacksonConverterFactory.create(), (Converter.Factory)GsonConverterFactory.create())).client(client).build();
        FolioReader.singleton.r2StreamerApi = (R2StreamerApi)FolioReader.singleton.retrofit.create(R2StreamerApi.class);
    }

    public FolioReader setOnHighlightListener(OnHighlightListener onHighlightListener) {
        this.onHighlightListener = onHighlightListener;
        return singleton;
    }

    public FolioReader setReadLocatorListener(ReadLocatorListener readLocatorListener) {
        this.readLocatorListener = readLocatorListener;
        return singleton;
    }

    public FolioReader setOnClosedListener(OnClosedListener onClosedListener) {
        this.onClosedListener = onClosedListener;
        return singleton;
    }

    public FolioReader setReadLocator(ReadLocator readLocator) {
        this.readLocator = readLocator;
        return singleton;
    }

    public void saveReceivedHighLights(List<HighLight> highlights, OnSaveHighlight onSaveHighlight) {
        new SaveReceivedHighlightTask(onSaveHighlight, highlights).execute(new Void[0]);
    }

    public void close() {
        Intent intent = new Intent(ACTION_CLOSE_FOLIOREADER);
        LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
    }

    public static synchronized void clear() {
        if (singleton != null) {
            FolioReader.singleton.readLocator = null;
            FolioReader.singleton.onHighlightListener = null;
            FolioReader.singleton.readLocatorListener = null;
            FolioReader.singleton.onClosedListener = null;
        }
    }

    public static synchronized void stop() {
        if (singleton != null) {
            DbAdapter.terminate();
            singleton.unregisterListeners();
            singleton = null;
        }
    }

    private void unregisterListeners() {
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.context);
        localBroadcastManager.unregisterReceiver(this.highlightReceiver);
        localBroadcastManager.unregisterReceiver(this.readLocatorReceiver);
        localBroadcastManager.unregisterReceiver(this.closedReceiver);
    }

    public static interface OnClosedListener {
        public void onFolioReaderClosed();
    }
}

