/*
 * Decompiled with CFR 0.152.
 */
package com.ferfalk.simplesearchview.utils;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.util.TypedValue;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.ColorInt;
import com.ferfalk.simplesearchview.R;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/ferfalk/simplesearchview/utils/ContextUtils;", "", "()V", "getAccentColor", "", "context", "Landroid/content/Context;", "getPrimaryColor", "hideKeyboard", "", "view", "Landroid/view/View;", "scanForActivity", "Landroid/app/Activity;", "showKeyboard", "simplesearchview_release"})
public final class ContextUtils {
    public static final ContextUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final Activity scanForActivity(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context context2 = context;
        if (context2 instanceof Activity) {
            return (Activity)context;
        }
        if (context2 instanceof ContextWrapper) {
            Context context3 = ((ContextWrapper)context).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"context.baseContext");
            return ContextUtils.scanForActivity(context3);
        }
        return null;
    }

    @JvmStatic
    @ColorInt
    public static final int getPrimaryColor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorPrimary, value, true);
        return value.data;
    }

    @JvmStatic
    @ColorInt
    public static final int getAccentColor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorAccent, value, true);
        return value.data;
    }

    @JvmStatic
    public static final void showKeyboard(@NotNull View view) {
        block0: {
            InputMethodManager imm;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            view.requestFocus();
            InputMethodManager inputMethodManager = imm = (InputMethodManager)view.getContext().getSystemService("input_method");
            if (inputMethodManager == null) break block0;
            inputMethodManager.showSoftInput(view, 2);
        }
    }

    @JvmStatic
    public static final void hideKeyboard(@NotNull View view) {
        block0: {
            InputMethodManager imm;
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            InputMethodManager inputMethodManager = imm = (InputMethodManager)view.getContext().getSystemService("input_method");
            if (inputMethodManager == null) break block0;
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    private ContextUtils() {
    }

    static {
        ContextUtils contextUtils;
        INSTANCE = contextUtils = new ContextUtils();
    }
}

