/*
 * Decompiled with CFR 0.152.
 */
package com.eulerian.android.sdk;

import com.eulerian.android.sdk.EALog;
import com.eulerian.android.sdk.JSONUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Action {
    private static final String KEY_REF = "ref";
    private static final String KEY_IN = "in";
    private static final String KEY_OUT = "out";
    private JSONObject mJson;

    private Action(Builder builder) {
        this.mJson = builder.mainJson;
    }

    JSONObject getJson() {
        return this.mJson;
    }

    public static class Builder {
        private final JSONObject mainJson = new JSONObject();
        private final JSONArray outsJson = new JSONArray();

        public Builder setReference(String ref) {
            JSONUtils.put(this.mainJson, Action.KEY_REF, ref);
            return this;
        }

        public Builder setIn(String in) {
            JSONUtils.put(this.mainJson, Action.KEY_IN, in);
            return this;
        }

        public Builder addOut(String ... outs) {
            for (String out : outs) {
                this.outsJson.put((Object)out);
            }
            return this;
        }

        public Action build() {
            if (this.outsJson.length() != 0) {
                JSONUtils.put(this.mainJson, Action.KEY_OUT, this.outsJson);
            }
            if (!this.mainJson.has(Action.KEY_IN) && !this.mainJson.has(Action.KEY_OUT)) {
                EALog.w(Action.class.getSimpleName() + ": one of setIn() or addOut() method must be called to create a valid Action.");
            }
            return new Action(this);
        }
    }
}

