/*
 * Decompiled with CFR 0.152.
 */
package com.xcode.onboarding;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.ViewPager2;
import com.xcode.onboarding.MaterialGuidelinesViolationException;
import com.xcode.onboarding.OnBoardingPage;
import com.xcode.onboarding.OnFinishLastPage;
import com.xcode.onboarding.R;
import com.xcode.onboarding.ViewPagerAdapter;
import java.util.List;

public class OnBoarder {
    public static void startOnBoarding(final @NonNull Activity activity, final @NonNull List<OnBoardingPage> pages, final @Nullable OnFinishLastPage onFinishClick) {
        if (pages.size() < 3 || pages.size() > 6) {
            throw new MaterialGuidelinesViolationException("This library follows material design guidelines and according to that, On-boarding screen must be of at least 3 & at most 6 pages");
        }
        activity.setContentView(R.layout.activity_onbording);
        activity.getWindow().getDecorView().setSystemUiVisibility(4100);
        if (activity instanceof AppCompatActivity) {
            AppCompatActivity app = (AppCompatActivity)activity;
            if (app.getSupportActionBar() != null) {
                app.getSupportActionBar().hide();
            }
        } else if (activity.getActionBar() != null) {
            activity.getActionBar().hide();
        }
        final Button next = (Button)activity.findViewById(R.id.next);
        final ViewPager2 pager = (ViewPager2)activity.findViewById(R.id.viewpager);
        LinearLayout indicator = (LinearLayout)activity.findViewById(R.id.indicator);
        ViewPagerAdapter adapter = new ViewPagerAdapter(pages);
        final TextView[] dots = new TextView[pages.size()];
        for (int i = 0; i < dots.length; ++i) {
            dots[i] = new TextView((Context)activity);
            dots[i].setText((CharSequence)"\u2022");
            dots[i].setTextSize(40.0f);
            indicator.addView((View)dots[i]);
        }
        pager.setAdapter((RecyclerView.Adapter)adapter);
        pager.registerOnPageChangeCallback(new ViewPager2.OnPageChangeCallback(){

            public void onPageSelected(int position) {
                if (position != 0) {
                    dots[position - 1].setTextColor(-7829368);
                }
                if (position < pages.size() - 1) {
                    dots[position + 1].setTextColor(-7829368);
                }
                if (position == pages.size() - 1) {
                    next.setText((CharSequence)"Finish");
                } else {
                    next.setText((CharSequence)"Next");
                }
                dots[position].setTextColor(-16776961);
            }
        });
        next.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int currentPage = pager.getCurrentItem();
                if (currentPage == pages.size() - 1) {
                    if (onFinishClick != null) {
                        onFinishClick.onNext();
                    } else {
                        activity.finish();
                    }
                } else {
                    pager.setCurrentItem(currentPage + 1);
                }
            }
        });
    }
}

