/*
 * Decompiled with CFR 0.152.
 */
package com.dylanc.longan;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import com.dylanc.longan.ApplicationKt;
import com.dylanc.longan.LanguageManager;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0001\"$\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00018F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0003\u0010\u0004\"\u0004\b\u0005\u0010\u0006\"\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\b\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0004\u00a8\u0006\u0011"}, d2={"value", "Ljava/util/Locale;", "appLanguage", "getAppLanguage", "()Ljava/util/Locale;", "setAppLanguage", "(Ljava/util/Locale;)V", "appLanguageCache", "systemLanguage", "getSystemLanguage", "resetAppLanguage", "", "attachLanguage", "Landroid/content/ContextWrapper;", "Landroid/content/Context;", "wrap", "locale", "longan"})
public final class MultiLanguageKt {
    @Nullable
    private static Locale appLanguageCache;

    @NotNull
    public static final Locale getSystemLanguage() {
        Locale locale;
        if (Build.VERSION.SDK_INT >= 24) {
            Locale locale2 = ApplicationKt.getApplication().getResources().getConfiguration().getLocales().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"{\n    application.resour\u2026figuration.locales[0]\n  }");
            locale = locale2;
        } else {
            Locale locale3 = ApplicationKt.getApplication().getResources().getConfiguration().locale;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n    @Suppress(\"DEPRECA\u2026.configuration.locale\n  }");
            locale = locale3;
        }
        return locale;
    }

    @NotNull
    public static final Locale getAppLanguage() {
        if (appLanguageCache == null) {
            appLanguageCache = LanguageManager.INSTANCE.getAppLanguage();
        }
        Locale locale = appLanguageCache;
        Intrinsics.checkNotNull((Object)locale);
        return locale;
    }

    public static final void setAppLanguage(@NotNull Locale value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        appLanguageCache = value;
        LanguageManager.INSTANCE.setAppLanguage(value);
    }

    public static final void resetAppLanguage() {
        appLanguageCache = MultiLanguageKt.getSystemLanguage();
        LanguageManager.INSTANCE.reset();
    }

    @NotNull
    public static final ContextWrapper attachLanguage(@NotNull Context $this$attachLanguage) {
        Intrinsics.checkNotNullParameter((Object)$this$attachLanguage, (String)"<this>");
        return MultiLanguageKt.wrap($this$attachLanguage, MultiLanguageKt.getAppLanguage());
    }

    @NotNull
    public static final ContextWrapper wrap(@NotNull Context $this$wrap, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)$this$wrap, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        if (!Intrinsics.areEqual((Object)MultiLanguageKt.getSystemLanguage(), (Object)locale)) {
            Locale.setDefault(locale);
            if (Build.VERSION.SDK_INT >= 24) {
                $this$wrap.getResources().getConfiguration().setLocale(locale);
            } else {
                $this$wrap.getResources().getConfiguration().locale = locale;
            }
        }
        return new ContextWrapper($this$wrap.createConfigurationContext($this$wrap.getResources().getConfiguration()));
    }
}

