/*
 * Decompiled with CFR 0.152.
 */
package com.dylanc.activityresult.launcher;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityOptionsCompat;
import com.dylanc.activityresult.launcher.ActivityResultCallerKt;

public class BaseActivityResultLauncher<I, O> {
    private final ActivityResultLauncher<I> launcher;
    private final ActivityResultCaller caller;
    private ActivityResultCallback<O> callback;

    public BaseActivityResultLauncher(@NonNull ActivityResultCaller caller, @NonNull ActivityResultContract<I, O> contract) {
        this.caller = caller;
        this.launcher = caller.registerForActivityResult(contract, result -> {
            if (this.callback != null) {
                this.callback.onActivityResult(result);
                this.callback = null;
            }
        });
    }

    public void launch(@SuppressLint(value={"UnknownNullness"}) I input, @NonNull ActivityResultCallback<O> callback) {
        this.launch(input, null, callback);
    }

    public void launch(@SuppressLint(value={"UnknownNullness"}) I input, @Nullable ActivityOptionsCompat options, @NonNull ActivityResultCallback<O> callback) {
        this.callback = callback;
        this.launcher.launch(input, options);
    }

    protected Context getContext() {
        return ActivityResultCallerKt.getContext(this.caller);
    }
}

