/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimatemusicpicker.ui;

import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProviders;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.aprildown.ultimatemusicpicker.R;
import xyz.aprildown.ultimatemusicpicker.ui.MusicAdapter;
import xyz.aprildown.ultimatemusicpicker.ui.MusicListItem;
import xyz.aprildown.ultimatemusicpicker.ui.MusicPickerFragment;
import xyz.aprildown.ultimatemusicpicker.ui.PickerViewModel;
import xyz.aprildown.ultimatemusicpicker.ui.SoundItem;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00022\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0014\u0010 \u001a\u0004\u0018\u00010\u001e2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0004J\b\u0010#\u001a\u00020$H&J&\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020$H\u0016J\u001c\u0010.\u001a\u00020$2\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000300H\u0016J\u0010\u00101\u001a\u00020$2\u0006\u00102\u001a\u000203H\u0004J\b\u00104\u001a\u000205H&J\u0016\u00106\u001a\u00020$*\u00020\u00042\b\b\u0002\u00107\u001a\u000205H\u0004R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\n8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lxyz/aprildown/ultimatemusicpicker/ui/PickerBaseFragment;", "Landroidx/fragment/app/Fragment;", "Landroidx/loader/app/LoaderManager$LoaderCallbacks;", "", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicListItem;", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter$OnItemCLickedListener;", "()V", "_musicAdapter", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter;", "_recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "musicAdapter", "getMusicAdapter", "()Lxyz/aprildown/ultimatemusicpicker/ui/MusicAdapter;", "parent", "Lxyz/aprildown/ultimatemusicpicker/ui/MusicPickerFragment;", "getParent", "()Lxyz/aprildown/ultimatemusicpicker/ui/MusicPickerFragment;", "setParent", "(Lxyz/aprildown/ultimatemusicpicker/ui/MusicPickerFragment;)V", "recyclerView", "getRecyclerView", "()Landroidx/recyclerview/widget/RecyclerView;", "viewModel", "Lxyz/aprildown/ultimatemusicpicker/ui/PickerViewModel;", "getViewModel", "()Lxyz/aprildown/ultimatemusicpicker/ui/PickerViewModel;", "setViewModel", "(Lxyz/aprildown/ultimatemusicpicker/ui/PickerViewModel;)V", "getSelectedSoundItem", "Lxyz/aprildown/ultimatemusicpicker/ui/SoundItem;", "getSelectedSoundItem$library_release", "getSoundItem", "uri", "Landroid/net/Uri;", "init", "", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onDestroyView", "onLoaderReset", "loader", "Landroidx/loader/content/Loader;", "onMusicItemClicked", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "shouldShowContextMenu", "", "notifyItemChanged", "scrollTo", "library_release"})
public abstract class PickerBaseFragment
extends Fragment
implements LoaderManager.LoaderCallbacks<List<? extends MusicListItem>>,
MusicAdapter.OnItemCLickedListener {
    @NotNull
    protected PickerViewModel viewModel;
    @NotNull
    protected MusicPickerFragment parent;
    private RecyclerView _recyclerView;
    private MusicAdapter _musicAdapter;

    @NotNull
    protected final PickerViewModel getViewModel() {
        PickerViewModel pickerViewModel = this.viewModel;
        if (pickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        return pickerViewModel;
    }

    protected final void setViewModel(@NotNull PickerViewModel pickerViewModel) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)pickerViewModel), (String)"<set-?>");
        this.viewModel = pickerViewModel;
    }

    @NotNull
    protected final MusicPickerFragment getParent() {
        MusicPickerFragment musicPickerFragment = this.parent;
        if (musicPickerFragment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        return musicPickerFragment;
    }

    protected final void setParent(@NotNull MusicPickerFragment musicPickerFragment) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)musicPickerFragment), (String)"<set-?>");
        this.parent = musicPickerFragment;
    }

    @NotNull
    protected final RecyclerView getRecyclerView() {
        RecyclerView recyclerView = this._recyclerView;
        if (recyclerView == null) {
            throw (Throwable)new IllegalStateException("Accessing _recyclerView after onDestroyView");
        }
        return recyclerView;
    }

    @NotNull
    protected final MusicAdapter getMusicAdapter() {
        MusicAdapter musicAdapter = this._musicAdapter;
        if (musicAdapter == null) {
            throw (Throwable)new IllegalStateException("Accessing _musicAdapter after onDestroyView");
        }
        return musicAdapter;
    }

    public abstract void init();

    public abstract boolean shouldShowContextMenu();

    @Nullable
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkParameterIsNotNull((Object)inflater, (String)"inflater");
        Fragment fragment = this.getParentFragment();
        if (!(fragment instanceof MusicPickerFragment)) {
            fragment = null;
        }
        MusicPickerFragment musicPickerFragment = (MusicPickerFragment)fragment;
        if (musicPickerFragment == null) {
            throw (Throwable)new IllegalStateException("PickerBaseFragment should show in the MusicPickerActivity!");
        }
        MusicPickerFragment musicPickerFragment2 = this.parent = musicPickerFragment;
        if (musicPickerFragment2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        }
        ViewModel viewModel = ViewModelProviders.of((Fragment)musicPickerFragment2).get(PickerViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"ViewModelProviders.of(pa\u2026kerViewModel::class.java)");
        this.viewModel = (PickerViewModel)viewModel;
        View view = inflater.inflate(R.layout.layout_music_picker, container, false);
        this._recyclerView = (RecyclerView)view.findViewById(R.id.list);
        this._musicAdapter = new MusicAdapter(this, this.shouldShowContextMenu());
        this.getRecyclerView().setAdapter((RecyclerView.Adapter)this.getMusicAdapter());
        this.init();
        LoaderManager.getInstance((LifecycleOwner)((LifecycleOwner)this)).initLoader(0, null, (LoaderManager.LoaderCallbacks)this);
        return view;
    }

    public void onLoaderReset(@NotNull Loader<List<MusicListItem>> loader) {
        Intrinsics.checkParameterIsNotNull(loader, (String)"loader");
    }

    public void onDestroyView() {
        super.onDestroyView();
        this._recyclerView = null;
        this._musicAdapter = null;
    }

    @Nullable
    public final SoundItem getSelectedSoundItem$library_release() {
        PickerViewModel pickerViewModel = this.viewModel;
        if (pickerViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        return this.getSoundItem(pickerViewModel.getSelectedUri());
    }

    protected final void notifyItemChanged(@NotNull MusicListItem $this$notifyItemChanged, boolean scrollTo) {
        Intrinsics.checkParameterIsNotNull((Object)$this$notifyItemChanged, (String)"$this$notifyItemChanged");
        List<MusicListItem> data = this.getMusicAdapter().getData();
        int index = this.getMusicAdapter().getData().indexOf($this$notifyItemChanged);
        int n = index;
        if (0 <= n && data.size() > n) {
            this.getMusicAdapter().notifyItemChanged(index);
            if (scrollTo) {
                this.getRecyclerView().scrollToPosition(index);
            }
        }
    }

    public static /* synthetic */ void notifyItemChanged$default(PickerBaseFragment pickerBaseFragment, MusicListItem musicListItem, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: notifyItemChanged");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        pickerBaseFragment.notifyItemChanged(musicListItem, bl);
    }

    protected final void onMusicItemClicked(@NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        SoundItem old = this.getSelectedSoundItem$library_release();
        Object object = CollectionsKt.getOrNull(this.getMusicAdapter().getData(), (int)viewHolder.getAdapterPosition());
        if (!(object instanceof SoundItem)) {
            object = null;
        }
        SoundItem soundItem = (SoundItem)object;
        if (soundItem == null) {
            return;
        }
        SoundItem soundItem2 = soundItem;
        if (Intrinsics.areEqual((Object)old, (Object)soundItem2)) {
            if (soundItem2.isPlaying()) {
                MusicPickerFragment musicPickerFragment = this.parent;
                if (musicPickerFragment == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                }
                musicPickerFragment.stopPlayingMusic$library_release(soundItem2, false);
            } else {
                MusicPickerFragment musicPickerFragment = this.parent;
                if (musicPickerFragment == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
                }
                musicPickerFragment.startPlayingMusic$library_release(soundItem2);
            }
            PickerBaseFragment.notifyItemChanged$default(this, soundItem2, false, 1, null);
        } else {
            MusicPickerFragment musicPickerFragment = this.parent;
            if (musicPickerFragment == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
            }
            musicPickerFragment.stopPlayingMusic$library_release(old, true);
            SoundItem soundItem3 = old;
            if (soundItem3 != null) {
                PickerBaseFragment.notifyItemChanged$default(this, soundItem3, false, 1, null);
            }
            MusicPickerFragment musicPickerFragment2 = this.parent;
            if (musicPickerFragment2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
            }
            musicPickerFragment2.startPlayingMusic$library_release(soundItem2);
            PickerBaseFragment.notifyItemChanged$default(this, soundItem2, false, 1, null);
        }
    }

    @Nullable
    protected final SoundItem getSoundItem(@Nullable Uri uri) {
        SoundItem soundItem;
        if (uri == null) {
            soundItem = null;
        } else {
            Object v2;
            Object v1;
            block4: {
                Iterable iterable = this.getMusicAdapter().getData();
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    MusicListItem it = (MusicListItem)t;
                    boolean bl3 = false;
                    if (!(it instanceof SoundItem && Intrinsics.areEqual((Object)((SoundItem)it).getUri(), (Object)uri))) continue;
                    v1 = t;
                    break block4;
                }
                v1 = v2 = null;
            }
            if (!(v1 instanceof SoundItem)) {
                v2 = null;
            }
            soundItem = v2;
        }
        return soundItem;
    }
}

