/*
 * Decompiled with CFR 0.152.
 */
package xyz.aprildown.ultimatemusicpicker.data;

import android.content.SharedPreferences;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import xyz.aprildown.ultimatemusicpicker.UtilsKt;
import xyz.aprildown.ultimatemusicpicker.data.CustomMusic;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lxyz/aprildown/ultimatemusicpicker/data/CustomMusicDAO;", "", "prefs", "Landroid/content/SharedPreferences;", "(Landroid/content/SharedPreferences;)V", "addCustomMusic", "Lxyz/aprildown/ultimatemusicpicker/data/CustomMusic;", "uri", "Landroid/net/Uri;", "title", "", "getCustomMusics", "", "getMusicIds", "", "removeCustomMusic", "", "id", "", "Companion", "library_release"})
public final class CustomMusicDAO {
    private final SharedPreferences prefs;
    private static final String MUSIC_IDS = "music_ids";
    private static final String NEXT_MUSIC_ID = "next_music_id";
    private static final String MUSIC_URI = "music_uri_";
    private static final String MUSIC_TITLE = "music_title_";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CustomMusic addCustomMusic(@NotNull Uri uri, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        long id2 = this.prefs.getLong(NEXT_MUSIC_ID, 0L);
        Set<String> ids = this.getMusicIds();
        ids.add(String.valueOf(id2));
        this.prefs.edit().putString(MUSIC_URI + id2, uri.toString()).putString(MUSIC_TITLE + id2, title).putLong(NEXT_MUSIC_ID, id2 + 1L).putStringSet(MUSIC_IDS, ids).apply();
        return new CustomMusic(id2, uri, title);
    }

    public final void removeCustomMusic(long id2) {
        Set<String> ids = this.getMusicIds();
        ids.remove(String.valueOf(id2));
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.remove(MUSIC_URI + id2);
        editor.remove(MUSIC_TITLE + id2);
        if (ids.isEmpty()) {
            editor.remove(MUSIC_IDS);
            editor.remove(NEXT_MUSIC_ID);
        } else {
            editor.putStringSet(MUSIC_IDS, ids);
        }
        editor.apply();
    }

    @NotNull
    public final List<CustomMusic> getCustomMusics() {
        Set set = this.prefs.getStringSet(MUSIC_IDS, null);
        if (set == null) {
            boolean bl = false;
            return new ArrayList();
        }
        Set ids = set;
        ArrayList<CustomMusic> musics = new ArrayList<CustomMusic>(ids.size());
        Iterator iterator = ids.iterator();
        while (iterator.hasNext()) {
            String title;
            String id2;
            String string = id2 = (String)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
            Long l = StringsKt.toLongOrNull((String)string);
            if (l == null) {
                continue;
            }
            long idLong = l;
            String string2 = this.prefs.getString(MUSIC_URI + id2, null);
            if (string2 == null) {
                continue;
            }
            Uri uri = Uri.parse((String)string2);
            if (this.prefs.getString(MUSIC_TITLE + id2, null) == null) {
                continue;
            }
            Uri uri2 = uri;
            Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
            musics.add(new CustomMusic(idLong, uri2, title));
        }
        UtilsKt.sortWithCollator((List<CustomMusic>)musics);
        return musics;
    }

    private final Set<String> getMusicIds() {
        String string = MUSIC_IDS;
        SharedPreferences sharedPreferences = this.prefs;
        boolean bl = false;
        Set set = new LinkedHashSet();
        Set set2 = sharedPreferences.getStringSet(string, set);
        if (set2 == null) {
            bl = false;
            set2 = new LinkedHashSet();
        }
        return set2;
    }

    public CustomMusicDAO(@NotNull SharedPreferences prefs) {
        Intrinsics.checkParameterIsNotNull((Object)prefs, (String)"prefs");
        this.prefs = prefs;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lxyz/aprildown/ultimatemusicpicker/data/CustomMusicDAO$Companion;", "", "()V", "MUSIC_IDS", "", "MUSIC_TITLE", "MUSIC_URI", "NEXT_MUSIC_ID", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

