/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer.link;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.link.LinkHandler;
import com.github.barteksc.pdfviewer.model.LinkTapEvent;

public class DefaultLinkHandler
implements LinkHandler {
    private static final String TAG = DefaultLinkHandler.class.getSimpleName();
    private PDFView pdfView;

    public DefaultLinkHandler(PDFView pdfView) {
        this.pdfView = pdfView;
    }

    @Override
    public void handleLinkEvent(LinkTapEvent event) {
        String uri = event.getLink().getUri();
        Integer page = event.getLink().getDestPageIdx();
        if (uri != null && !uri.isEmpty()) {
            this.handleUri(uri);
        } else if (page != null) {
            this.handlePage(page);
        }
    }

    private void handleUri(String uri) {
        Context context;
        Uri parsedUri = Uri.parse((String)uri);
        Intent intent = new Intent("android.intent.action.VIEW", parsedUri);
        if (intent.resolveActivity((context = this.pdfView.getContext()).getPackageManager()) != null) {
            context.startActivity(intent);
        } else {
            Log.w((String)TAG, (String)("No activity found for URI: " + uri));
        }
    }

    private void handlePage(int page) {
        this.pdfView.jumpTo(page);
    }
}

