/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.value;

import java.util.List;
import me.coley.analysis.util.CollectUtils;
import me.coley.analysis.util.TypeUtil;
import me.coley.analysis.value.AbstractValue;
import me.coley.analysis.value.Unresolved;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;

public class PrimitiveValue
extends AbstractValue {
    protected PrimitiveValue(AbstractInsnNode insn, Type type, Object value) {
        super(insn, type, value);
    }

    public PrimitiveValue(AbstractInsnNode insn, Type type) {
        super(insn, type, null);
    }

    public PrimitiveValue(List<AbstractInsnNode> insns, Type type, Object value) {
        super(insns, type, value);
    }

    protected PrimitiveValue(List<AbstractInsnNode> insns, Type type) {
        super(insns, type, null);
    }

    public static AbstractValue ofInt(AbstractInsnNode insn, int value) {
        return new PrimitiveValue(insn, Type.INT_TYPE, (Object)value);
    }

    public static AbstractValue ofInt(List<AbstractInsnNode> insns, int value) {
        return new PrimitiveValue(insns, Type.INT_TYPE, (Object)value);
    }

    public static AbstractValue ofChar(AbstractInsnNode insn, char value) {
        return new PrimitiveValue(insn, Type.INT_TYPE, (Object)value);
    }

    public static AbstractValue ofChar(List<AbstractInsnNode> insns, char value) {
        return new PrimitiveValue(insns, Type.INT_TYPE, (Object)value);
    }

    public static AbstractValue ofByte(AbstractInsnNode insn, byte value) {
        return new PrimitiveValue(insn, Type.INT_TYPE, (Object)value);
    }

    public static AbstractValue ofByte(List<AbstractInsnNode> insns, byte value) {
        return new PrimitiveValue(insns, Type.INT_TYPE, (Object)value);
    }

    public static AbstractValue ofShort(AbstractInsnNode insn, short value) {
        return new PrimitiveValue(insn, Type.INT_TYPE, (Object)value);
    }

    public static AbstractValue ofShort(List<AbstractInsnNode> insns, short value) {
        return new PrimitiveValue(insns, Type.INT_TYPE, (Object)value);
    }

    public static AbstractValue ofBool(AbstractInsnNode insn, boolean value) {
        return new PrimitiveValue(insn, Type.INT_TYPE, (Object)(value ? 1 : 0));
    }

    public static AbstractValue ofBool(List<AbstractInsnNode> insns, boolean value) {
        return new PrimitiveValue(insns, Type.INT_TYPE, (Object)(value ? 1 : 0));
    }

    public static AbstractValue ofLong(AbstractInsnNode insn, long value) {
        return new PrimitiveValue(insn, Type.LONG_TYPE, (Object)value);
    }

    public static AbstractValue ofLong(List<AbstractInsnNode> insns, long value) {
        return new PrimitiveValue(insns, Type.LONG_TYPE, (Object)value);
    }

    public static AbstractValue ofFloat(AbstractInsnNode insn, float value) {
        return new PrimitiveValue(insn, Type.FLOAT_TYPE, (Object)Float.valueOf(value));
    }

    public static AbstractValue ofFloat(List<AbstractInsnNode> insns, float value) {
        return new PrimitiveValue(insns, Type.FLOAT_TYPE, (Object)Float.valueOf(value));
    }

    public static AbstractValue ofDouble(AbstractInsnNode insn, double value) {
        return new PrimitiveValue(insn, Type.DOUBLE_TYPE, (Object)value);
    }

    public static AbstractValue ofDouble(List<AbstractInsnNode> insns, double value) {
        return new PrimitiveValue(insns, Type.DOUBLE_TYPE, (Object)value);
    }

    public boolean getBooleanValue() {
        return ((Number)this.getValue()).intValue() > 1;
    }

    public int getIntValue() {
        return ((Number)this.getValue()).intValue();
    }

    public float getFloatValue() {
        return ((Number)this.getValue()).floatValue();
    }

    public double getDoubleValue() {
        return ((Number)this.getValue()).doubleValue();
    }

    public long getLongValue() {
        return ((Number)this.getValue()).longValue();
    }

    public PrimitiveValue add(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.addN((Number)this.value, (Number)other.value));
    }

    public PrimitiveValue sub(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.subN((Number)this.value, (Number)other.value));
    }

    public PrimitiveValue mul(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.mulN((Number)this.value, (Number)other.value));
    }

    public PrimitiveValue div(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        try {
            return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.divN((Number)this.value, (Number)other.value));
        }
        catch (ArithmeticException ex) {
            return new PrimitiveValue(mergedInsns, common);
        }
    }

    public PrimitiveValue rem(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        try {
            return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.remN((Number)this.value, (Number)other.value));
        }
        catch (ArithmeticException ex) {
            return new PrimitiveValue(mergedInsns, common);
        }
    }

    public PrimitiveValue shl(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (!common.equals((Object)Type.INT_TYPE) && !common.equals((Object)Type.LONG_TYPE)) {
            throw new IllegalStateException("Requires int/long types");
        }
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.shlN((Number)this.value, (Number)other.value));
    }

    public PrimitiveValue shr(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        if (!common.equals((Object)Type.INT_TYPE) && !common.equals((Object)Type.LONG_TYPE)) {
            throw new IllegalStateException("Requires int/long types");
        }
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.shrN((Number)this.value, (Number)other.value));
    }

    public PrimitiveValue ushr(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        if (!common.equals((Object)Type.INT_TYPE) && !common.equals((Object)Type.LONG_TYPE)) {
            throw new IllegalStateException("Requires int/long types");
        }
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.ushrN((Number)this.value, (Number)other.value));
    }

    public PrimitiveValue and(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        if (!common.equals((Object)Type.INT_TYPE) && !common.equals((Object)Type.LONG_TYPE)) {
            throw new IllegalStateException("Requires int/long types");
        }
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.andN((Number)this.value, (Number)other.value));
    }

    public PrimitiveValue or(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        if (!common.equals((Object)Type.INT_TYPE) && !common.equals((Object)Type.LONG_TYPE)) {
            throw new IllegalStateException("Requires int/long types");
        }
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.value == null || other.value == null) {
            return new PrimitiveValue(mergedInsns, common);
        }
        if (this.value instanceof Unresolved || other.value instanceof Unresolved) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.orN((Number)this.value, (Number)other.value));
    }

    public PrimitiveValue xor(AbstractInsnNode opInsn, AbstractValue other) {
        Type common = PrimitiveValue.commonMathType(this.type, other.type);
        if (!common.equals((Object)Type.INT_TYPE) && !common.equals((Object)Type.LONG_TYPE)) {
            throw new IllegalStateException("Requires int/long types");
        }
        List<AbstractInsnNode> mergedInsns = CollectUtils.combineAdd(this.insns, other.insns, opInsn);
        if (this.isValueUnresolved() || other.isValueUnresolved()) {
            return new PrimitiveValue(mergedInsns, common);
        }
        return new PrimitiveValue(mergedInsns, common, (Object)PrimitiveValue.xorN((Number)this.value, (Number)other.value));
    }

    @Override
    protected PrimitiveValue create(List<AbstractInsnNode> collection) {
        return new PrimitiveValue(collection, this.getType(), this.getValue());
    }

    @Override
    public boolean canMerge(AbstractValue other) {
        if (other == this) {
            return true;
        }
        if (!other.isPrimitive()) {
            return false;
        }
        return this.type.equals((Object)other.type) || ((PrimitiveValue)other).isPromotionOf(this);
    }

    @Override
    public boolean isReference() {
        return false;
    }

    @Override
    public boolean isValueResolved() {
        return this.value != null && !(this.value instanceof Unresolved);
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof PrimitiveValue) {
            PrimitiveValue pOther = (PrimitiveValue)other;
            if (this.isValueUnresolved() || pOther.isValueUnresolved()) {
                return this.type.equals((Object)pOther.type);
            }
            return this.type.equals((Object)pOther.type) && this.value.equals(pOther.value);
        }
        return false;
    }

    private boolean isPromotionOf(AbstractValue other) {
        int i2;
        int i1 = TypeUtil.getPromotionIndex(this.type.getSort());
        return i1 >= (i2 = TypeUtil.getPromotionIndex(other.getType().getSort()));
    }

    private static Number addN(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() + b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() + b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() + b.longValue();
        }
        return a.intValue() + b.intValue();
    }

    private static Number subN(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() - b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() - b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() - b.longValue();
        }
        return a.intValue() - b.intValue();
    }

    private static Number mulN(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() * b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() * b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() * b.longValue();
        }
        return a.intValue() * b.intValue();
    }

    private static Number divN(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() / b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() / b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() / b.longValue();
        }
        return a.intValue() / b.intValue();
    }

    private static Number remN(Number a, Number b) {
        if (a instanceof Double || b instanceof Double) {
            return a.doubleValue() % b.doubleValue();
        }
        if (a instanceof Float || b instanceof Float) {
            return Float.valueOf(a.floatValue() % b.floatValue());
        }
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() % b.longValue();
        }
        return a.intValue() % b.intValue();
    }

    private static Number shlN(Number a, Number b) {
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() << (int)b.longValue();
        }
        return a.intValue() << b.intValue();
    }

    private static Number shrN(Number a, Number b) {
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() >> (int)b.longValue();
        }
        return a.intValue() >> b.intValue();
    }

    private static Number ushrN(Number a, Number b) {
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() >>> (int)b.longValue();
        }
        return a.intValue() >>> b.intValue();
    }

    private static Number andN(Number a, Number b) {
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() & b.longValue();
        }
        return a.intValue() & b.intValue();
    }

    private static Number orN(Number a, Number b) {
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() | b.longValue();
        }
        return a.intValue() | b.intValue();
    }

    private static Number xorN(Number a, Number b) {
        if (a instanceof Long || b instanceof Long) {
            return a.longValue() ^ b.longValue();
        }
        return a.intValue() ^ b.intValue();
    }

    private static Type commonMathType(Type a, Type b) {
        int i2;
        if (a == null || b == null) {
            throw new IllegalStateException("Cannot find common type of a null type");
        }
        int i1 = TypeUtil.getPromotionIndex(a.getSort());
        int max = Math.max(i1, i2 = TypeUtil.getPromotionIndex(b.getSort()));
        if (max <= 8) {
            return max == i1 ? a : b;
        }
        throw new IllegalStateException("Cannot do math on non-primitive types: " + a.getDescriptor() + " & " + b.getDescriptor());
    }
}

