/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.util;

import me.coley.analysis.value.AbstractValue;
import org.objectweb.asm.tree.analysis.Frame;

public class FrameUtil {
    public static AbstractValue getTopStack(Frame<AbstractValue> frame) {
        return (AbstractValue)frame.getStack(frame.getStackSize() - 1);
    }

    public static <T> T getTopStackLiteral(Frame<AbstractValue> frame) {
        return (T)FrameUtil.getTopStack(frame).getValue();
    }

    public static AbstractValue getStackFromTop(Frame<AbstractValue> frame, int offset) {
        return (AbstractValue)frame.getStack(frame.getStackSize() - (1 + offset));
    }

    public static <T> T getStackLiteralFromTop(Frame<AbstractValue> frame, int offset) {
        return (T)FrameUtil.getStackFromTop(frame, offset).getValue();
    }

    public static Object[] getStackArgumentLiterals(Frame<AbstractValue> frame, int argCount) {
        Object[] args = new Object[argCount];
        for (int i = 0; i < argCount; ++i) {
            args[i] = FrameUtil.getStackLiteralFromTop(frame, argCount - i - 1);
        }
        return args;
    }
}

