/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class Block
implements Comparable<Block> {
    private final int key;
    private final int from;
    private final int to;
    private final List<AbstractInsnNode> insns;
    private final List<Block> subBlocks = new ArrayList<Block>();
    private Block parent;
    private int depth;

    private Block(int from, int to, List<AbstractInsnNode> insns) {
        this.from = from;
        this.to = to;
        this.insns = insns;
        this.key = Math.max(from, to);
    }

    public static Block create(MethodNode method, int from, int to) {
        ArrayList<AbstractInsnNode> insns = new ArrayList<AbstractInsnNode>();
        for (int i = from + 1; i < to - 1; ++i) {
            insns.add(method.instructions.get(i));
        }
        return new Block(from, to, insns);
    }

    public Block getBlockFromIndex(int insnIndex) {
        for (Block block : this.getSubBlocks()) {
            if (insnIndex <= block.getFrom() || insnIndex >= block.getTo()) continue;
            return block.getBlockFromIndex(insnIndex);
        }
        return this;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public Block getPriorAdjacent() {
        return this.getAdjacent(-1);
    }

    public Block getNextAdjacent() {
        return this.getAdjacent(1);
    }

    private Block getAdjacent(int offset) {
        if (this.parent == null) {
            return null;
        }
        int thisIndex = this.parent.getSubBlocks().indexOf(this);
        if (thisIndex == 0 || thisIndex == this.parent.getSubBlocks().size() - 1) {
            return null;
        }
        return this.parent.getSubBlocks().get(thisIndex + offset);
    }

    public List<AbstractInsnNode> getInsns() {
        return this.insns;
    }

    public AbstractInsnNode getFirst() {
        return this.insns.get(0);
    }

    public AbstractInsnNode getLast() {
        return this.insns.get(this.insns.size() - 1);
    }

    public List<Block> getSubBlocks() {
        return this.subBlocks;
    }

    public void addSubBlock(Block block) {
        Block found = null;
        for (Block sub : this.getSubBlocks()) {
            if (block.getFrom() < sub.getFrom() || block.getFrom() > sub.getTo()) continue;
            found = sub;
        }
        if (found != null) {
            found.addSubBlock(block);
            return;
        }
        ArrayList<Block> contained = new ArrayList<Block>();
        for (Block sub : this.getSubBlocks()) {
            if (sub.getFrom() < block.getFrom() || sub.getFrom() > block.getTo()) continue;
            contained.add(sub);
        }
        for (Block containedSub : contained) {
            if (containedSub == null) continue;
            this.subBlocks.remove(containedSub);
            block.addSubBlock(containedSub);
        }
        block.setParent(this);
        this.subBlocks.add(block);
        Collections.sort(this.subBlocks);
    }

    public Block getParent() {
        return this.parent;
    }

    public void setParent(Block parent) {
        this.parent = parent;
        int depth = 0;
        Block tmp = this;
        while (tmp.getParent() != null) {
            tmp = tmp.getParent();
            ++depth;
        }
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isRoot() {
        return this.depth == 0;
    }

    public String toString() {
        String prefix = "";
        if (this.getParent() == null) {
            prefix = "Root ";
        }
        return prefix + "(" + this.from + "," + this.to + ")";
    }

    @Override
    public int compareTo(Block other) {
        return Integer.compare(this.key, other.key);
    }
}

