/*
 * Decompiled with CFR 0.152.
 */
package me.coley.analysis;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.coley.analysis.ParameterFactory;
import me.coley.analysis.SimAnalyzer;
import me.coley.analysis.StaticGetFactory;
import me.coley.analysis.StaticInvokeFactory;
import me.coley.analysis.TypeChecker;
import me.coley.analysis.TypeResolver;
import me.coley.analysis.cfg.BlockHandler;
import me.coley.analysis.exception.ResolvableExceptionFactory;
import me.coley.analysis.exception.SimFailedException;
import me.coley.analysis.exception.TypeMismatchKind;
import me.coley.analysis.util.CollectUtils;
import me.coley.analysis.util.FlowUtil;
import me.coley.analysis.util.TypeUtil;
import me.coley.analysis.value.AbstractValue;
import me.coley.analysis.value.ExceptionValue;
import me.coley.analysis.value.NullConstantValue;
import me.coley.analysis.value.PrimitiveValue;
import me.coley.analysis.value.ReturnAddressValue;
import me.coley.analysis.value.UninitializedValue;
import me.coley.analysis.value.Unresolved;
import me.coley.analysis.value.VirtualValue;
import me.coley.analysis.value.simulated.AbstractSimulatedValue;
import me.coley.analysis.value.simulated.ReflectionSimulatedValue;
import me.coley.analysis.value.simulated.StringSimulatedValue;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class SimInterpreter
extends Interpreter<AbstractValue> {
    private final Map<AbstractInsnNode, AnalyzerException> badTypeInsns = new HashMap<AbstractInsnNode, AnalyzerException>();
    private final BlockHandler blockHandler = new BlockHandler();
    private ResolvableExceptionFactory exceptionFactory;
    private StaticInvokeFactory staticInvokeFactory;
    private StaticGetFactory staticGetFactory;
    private ParameterFactory parameterFactory;
    private TypeChecker typeChecker;
    private TypeResolver typeResolver;
    private SimAnalyzer analyzer;

    public SimInterpreter() {
        super(524288);
    }

    public void reset(String owner, MethodNode method) {
        this.badTypeInsns.clear();
        this.blockHandler.setMethod(method);
    }

    public Map<AbstractInsnNode, AnalyzerException> getProblemInsns() {
        return this.badTypeInsns;
    }

    public void setAnalyzer(SimAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public ResolvableExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    public void setExceptionFactory(ResolvableExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    public StaticInvokeFactory getStaticInvokeFactory() {
        return this.staticInvokeFactory;
    }

    public void setStaticInvokeFactory(StaticInvokeFactory staticInvokeFactory) {
        this.staticInvokeFactory = staticInvokeFactory;
    }

    public StaticGetFactory getStaticGetFactory() {
        return this.staticGetFactory;
    }

    public void setStaticGetFactory(StaticGetFactory staticGetFactory) {
        this.staticGetFactory = staticGetFactory;
    }

    public ParameterFactory getParameterFactory() {
        return this.parameterFactory;
    }

    public void setParameterFactory(ParameterFactory parameterFactory) {
        this.parameterFactory = parameterFactory;
    }

    public BlockHandler getBlockHandler() {
        return this.blockHandler;
    }

    public TypeChecker getTypeChecker() {
        return this.typeChecker;
    }

    public void setTypeChecker(TypeChecker typeChecker) {
        this.typeChecker = typeChecker;
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public boolean hasReportedProblems() {
        return !this.badTypeInsns.isEmpty();
    }

    private void handleOpaques(AbstractInsnNode insn, AbstractValue value) {
        if (value.isPrimitive() && value.isValueResolved()) {
            int p1 = ((PrimitiveValue)value).getIntValue();
            boolean gotoDestination = false;
            switch (insn.getOpcode()) {
                case 153: {
                    gotoDestination = p1 == 0;
                    break;
                }
                case 154: {
                    gotoDestination = p1 != 0;
                    break;
                }
                case 155: {
                    gotoDestination = p1 < 0;
                    break;
                }
                case 156: {
                    gotoDestination = p1 >= 0;
                    break;
                }
                case 157: {
                    gotoDestination = p1 > 0;
                    break;
                }
                case 158: {
                    gotoDestination = p1 <= 0;
                    break;
                }
            }
            this.analyzer.setOpaqueJump(insn, gotoDestination);
        }
    }

    private void handleOpaques(AbstractInsnNode insn, AbstractValue value1, AbstractValue value2) {
        if (value1.isPrimitive() && value1.isValueResolved() && value2.isPrimitive() && value2.isValueResolved()) {
            int p1 = ((PrimitiveValue)value1).getIntValue();
            int p2 = ((PrimitiveValue)value2).getIntValue();
            boolean gotoDestination = false;
            switch (insn.getOpcode()) {
                case 159: {
                    gotoDestination = p1 == p2;
                    break;
                }
                case 160: {
                    gotoDestination = p1 != p2;
                    break;
                }
                case 161: {
                    gotoDestination = p1 < p2;
                    break;
                }
                case 162: {
                    gotoDestination = p1 >= p2;
                    break;
                }
                case 163: {
                    gotoDestination = p1 > p2;
                    break;
                }
                case 164: {
                    gotoDestination = p1 <= p2;
                    break;
                }
            }
            this.analyzer.setOpaqueJump(insn, gotoDestination);
        }
    }

    private void markBad(AbstractInsnNode insn, AnalyzerException e) {
        this.badTypeInsns.put(insn, e);
    }

    private AbstractValue newValueOrVirtualized(AbstractInsnNode insn, Type type) {
        if (AbstractSimulatedValue.supported(type)) {
            return AbstractSimulatedValue.initialize(Collections.singletonList(insn), this.typeChecker, type);
        }
        return this.newValue(insn, type);
    }

    private AbstractValue newValue(AbstractInsnNode insn, Type type) {
        if (type == null) {
            return UninitializedValue.UNINITIALIZED_VALUE;
        }
        if (type == Type.VOID_TYPE) {
            return null;
        }
        if (type.getSort() <= 8) {
            return new PrimitiveValue(insn, type);
        }
        return VirtualValue.ofVirtual(insn, this.typeChecker, type);
    }

    private AbstractValue newValue(List<AbstractInsnNode> insns, Type type) {
        if (type == null) {
            return UninitializedValue.UNINITIALIZED_VALUE;
        }
        if (type == Type.VOID_TYPE) {
            return null;
        }
        if (type.getSort() <= 8) {
            return new PrimitiveValue(insns, type, null);
        }
        return VirtualValue.ofVirtual(insns, this.typeChecker, type);
    }

    public AbstractValue newValue(Type type) {
        throw new UnsupportedOperationException("Interpreter called default implementation of 'newValue'\nShould use more expressive call instead.");
    }

    public AbstractValue newReturnTypeValue(Type type) {
        return this.newValue((List<AbstractInsnNode>)null, type);
    }

    public AbstractValue newEmptyValue(int local) {
        return UninitializedValue.UNINITIALIZED_VALUE;
    }

    public AbstractValue newParameterValue(boolean isInstanceMethod, int local, Type type) {
        AbstractValue value;
        if (this.parameterFactory != null && (value = this.parameterFactory.createParameterValue(isInstanceMethod, local, type)) != null) {
            return value;
        }
        return this.newValue((List<AbstractInsnNode>)null, type);
    }

    public AbstractValue newExceptionValue(TryCatchBlockNode tryCatch, Frame<AbstractValue> handlerFrame, Type exceptionType) {
        return ExceptionValue.ofHandledException((AbstractInsnNode)tryCatch.handler, this.typeChecker, exceptionType);
    }

    public AbstractValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 1: {
                return NullConstantValue.newNull(insn);
            }
            case 2: {
                return PrimitiveValue.ofInt(insn, -1);
            }
            case 3: {
                return PrimitiveValue.ofInt(insn, 0);
            }
            case 4: {
                return PrimitiveValue.ofInt(insn, 1);
            }
            case 5: {
                return PrimitiveValue.ofInt(insn, 2);
            }
            case 6: {
                return PrimitiveValue.ofInt(insn, 3);
            }
            case 7: {
                return PrimitiveValue.ofInt(insn, 4);
            }
            case 8: {
                return PrimitiveValue.ofInt(insn, 5);
            }
            case 9: {
                return PrimitiveValue.ofLong(insn, 0L);
            }
            case 10: {
                return PrimitiveValue.ofLong(insn, 1L);
            }
            case 11: {
                return PrimitiveValue.ofFloat(insn, 0.0f);
            }
            case 12: {
                return PrimitiveValue.ofFloat(insn, 1.0f);
            }
            case 13: {
                return PrimitiveValue.ofFloat(insn, 2.0f);
            }
            case 14: {
                return PrimitiveValue.ofDouble(insn, 0.0);
            }
            case 15: {
                return PrimitiveValue.ofDouble(insn, 1.0);
            }
            case 16: 
            case 17: {
                return PrimitiveValue.ofInt(insn, ((IntInsnNode)insn).operand);
            }
            case 18: {
                Object value = ((LdcInsnNode)insn).cst;
                if (value instanceof Integer) {
                    return PrimitiveValue.ofInt(insn, (int)((Integer)value));
                }
                if (value instanceof Float) {
                    return PrimitiveValue.ofFloat(insn, ((Float)value).floatValue());
                }
                if (value instanceof Long) {
                    return PrimitiveValue.ofLong(insn, (long)((Long)value));
                }
                if (value instanceof Double) {
                    return PrimitiveValue.ofDouble(insn, (double)((Double)value));
                }
                if (value instanceof String) {
                    return StringSimulatedValue.of(insn, this.typeChecker, (String)value);
                }
                if (value instanceof Type) {
                    Type type = (Type)value;
                    int sort = type.getSort();
                    if (sort == 10 || sort == 9) {
                        return VirtualValue.ofClass(insn, this.typeChecker, type);
                    }
                    if (sort == 11) {
                        return this.newValue(insn, Type.getObjectType((String)"java/lang/invoke/MethodType"));
                    }
                    throw new AnalyzerException(insn, "Illegal LDC value " + value);
                }
                if (value instanceof Handle) {
                    return this.newValue(insn, Type.getObjectType((String)"java/lang/invoke/MethodHandle"));
                }
                if (value instanceof ConstantDynamic) {
                    return this.newValue(insn, Type.getType((String)((ConstantDynamic)value).getDescriptor()));
                }
                throw new AnalyzerException(insn, "Illegal LDC value " + value);
            }
            case 168: {
                return ReturnAddressValue.newRet(insn);
            }
            case 178: {
                FieldInsnNode fin = (FieldInsnNode)insn;
                Type type = Type.getType((String)fin.desc);
                if (this.staticGetFactory != null) {
                    return this.staticGetFactory.getStatic(fin);
                }
                return this.newValue(insn, type);
            }
            case 187: {
                return this.newValueOrVirtualized(insn, Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
        }
        throw new IllegalStateException();
    }

    public AbstractValue copyOperation(AbstractInsnNode insn, AbstractValue value) throws AnalyzerException {
        Type insnType = null;
        boolean load = false;
        switch (insn.getOpcode()) {
            case 21: {
                load = true;
            }
            case 54: {
                insnType = Type.INT_TYPE;
                break;
            }
            case 22: {
                load = true;
            }
            case 55: {
                insnType = Type.LONG_TYPE;
                break;
            }
            case 23: {
                load = true;
            }
            case 56: {
                insnType = Type.FLOAT_TYPE;
                break;
            }
            case 24: {
                load = true;
            }
            case 57: {
                insnType = Type.DOUBLE_TYPE;
                break;
            }
            case 25: {
                load = true;
                if (value != UninitializedValue.UNINITIALIZED_VALUE && !value.isReference()) {
                    throw new AnalyzerException(insn, "Expected a reference type.");
                }
                insnType = value.getType();
                break;
            }
            case 58: {
                if (!value.isReference() && !(value instanceof ReturnAddressValue)) {
                    throw new AnalyzerException(insn, "Expected a reference or return-address type.");
                }
                insnType = value.getType();
                break;
            }
        }
        Type argType = value.getType();
        if (insnType != null && argType != null) {
            if (!load && insnType.getSort() < argType.getSort()) {
                throw new AnalyzerException(insn, "Cannot store wider type (" + argType.getDescriptor() + ") into narrower type: " + insnType.getDescriptor());
            }
            if (insnType.getSort() == 10 && TypeUtil.isPrimitive(argType)) {
                throw new AnalyzerException(insn, "Cannot mix primitive value with type-variable instruction");
            }
            if (argType.getSort() == 10 && TypeUtil.isPrimitive(insnType)) {
                throw new AnalyzerException(insn, "Cannot mix type value with primitive-variable instruction");
            }
        }
        if (load && insnType != value.getType()) {
            return this.newValue(CollectUtils.add(value.getInsns(), insn), insnType);
        }
        return value.copy(insn);
    }

    public AbstractValue unaryOperation(AbstractInsnNode insn, AbstractValue value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 116: {
                if (this.isValueUnknown(value)) {
                    return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.INT_TYPE);
                }
                return PrimitiveValue.ofInt(CollectUtils.add(value.getInsns(), insn), -this.toInt(value));
            }
            case 132: {
                return PrimitiveValue.ofInt(CollectUtils.add(value.getInsns(), insn), ((IincInsnNode)insn).incr);
            }
            case 136: 
            case 139: 
            case 142: 
            case 145: 
            case 146: 
            case 147: {
                if (this.isValueUnknown(value)) {
                    return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.INT_TYPE);
                }
                return PrimitiveValue.ofInt(CollectUtils.add(value.getInsns(), insn), this.toInt(value));
            }
            case 118: {
                if (this.isValueUnknown(value)) {
                    return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.FLOAT_TYPE);
                }
                return PrimitiveValue.ofFloat(CollectUtils.add(value.getInsns(), insn), -this.toFloat(value));
            }
            case 134: 
            case 137: 
            case 144: {
                if (this.isValueUnknown(value)) {
                    return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.FLOAT_TYPE);
                }
                return PrimitiveValue.ofFloat(CollectUtils.add(value.getInsns(), insn), this.toFloat(value));
            }
            case 117: {
                if (this.isValueUnknown(value)) {
                    return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.LONG_TYPE);
                }
                return PrimitiveValue.ofLong(CollectUtils.add(value.getInsns(), insn), -this.toLong(value));
            }
            case 133: 
            case 140: 
            case 143: {
                if (this.isValueUnknown(value)) {
                    return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.LONG_TYPE);
                }
                return PrimitiveValue.ofLong(CollectUtils.add(value.getInsns(), insn), this.toLong(value));
            }
            case 119: {
                if (this.isValueUnknown(value)) {
                    return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.DOUBLE_TYPE);
                }
                return PrimitiveValue.ofDouble(CollectUtils.add(value.getInsns(), insn), -this.toDouble(value));
            }
            case 135: 
            case 138: 
            case 141: {
                if (this.isValueUnknown(value)) {
                    return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.DOUBLE_TYPE);
                }
                return PrimitiveValue.ofDouble(CollectUtils.add(value.getInsns(), insn), this.toDouble(value));
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.handleOpaques(insn, value);
            }
            case 170: 
            case 171: {
                if (!TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), Type.INT_TYPE) && !TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), Type.BOOLEAN_TYPE)) {
                    throw new AnalyzerException(insn, "Expected int type.");
                }
                return null;
            }
            case 172: {
                if (!TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), Type.INT_TYPE) && !TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), Type.BOOLEAN_TYPE)) {
                    throw new AnalyzerException(insn, "Expected int return type.");
                }
                return null;
            }
            case 173: {
                if (!TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), Type.LONG_TYPE)) {
                    throw new AnalyzerException(insn, "Expected long return type.");
                }
                return null;
            }
            case 174: {
                if (!TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), Type.FLOAT_TYPE)) {
                    throw new AnalyzerException(insn, "Expected float return type.");
                }
                return null;
            }
            case 175: {
                if (!TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), Type.DOUBLE_TYPE)) {
                    throw new AnalyzerException(insn, "Expected double return type.");
                }
                return null;
            }
            case 176: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, "Expected reference return type");
                }
                return null;
            }
            case 179: {
                FieldInsnNode fin = (FieldInsnNode)insn;
                Type fieldType = Type.getType((String)fin.desc);
                if (!TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), fieldType)) {
                    this.markBad(insn, this.exceptionFactory.unexpectedType(fieldType, value.getType(), insn, value, TypeMismatchKind.PUTSTATIC));
                }
                return null;
            }
            case 180: {
                FieldInsnNode fin = (FieldInsnNode)insn;
                Type ownerType = Type.getObjectType((String)fin.owner);
                if (!TypeUtil.isSubTypeOf(this.typeChecker, value.getType(), ownerType)) {
                    this.markBad(insn, this.exceptionFactory.unexpectedType(Type.getObjectType((String)fin.owner), value.getType(), insn, value, TypeMismatchKind.GETFIELD));
                }
                Type type = Type.getType((String)fin.desc);
                return this.newValue(CollectUtils.add(value.getInsns(), insn), type);
            }
            case 188: {
                switch (((IntInsnNode)insn).operand) {
                    case 4: {
                        return this.newValue(CollectUtils.add(value.getInsns(), insn), TypeUtil.BOOLEAN_ARRAY_TYPE);
                    }
                    case 5: {
                        return this.newValue(CollectUtils.add(value.getInsns(), insn), TypeUtil.CHAR_ARRAY_TYPE);
                    }
                    case 8: {
                        return this.newValue(CollectUtils.add(value.getInsns(), insn), TypeUtil.BYTE_ARRAY_TYPE);
                    }
                    case 9: {
                        return this.newValue(CollectUtils.add(value.getInsns(), insn), TypeUtil.SHORT_ARRAY_TYPE);
                    }
                    case 10: {
                        return this.newValue(CollectUtils.add(value.getInsns(), insn), TypeUtil.INT_ARRAY_TYPE);
                    }
                    case 6: {
                        return this.newValue(CollectUtils.add(value.getInsns(), insn), TypeUtil.FLOAT_ARRAY_TYPE);
                    }
                    case 7: {
                        return this.newValue(CollectUtils.add(value.getInsns(), insn), TypeUtil.DOUBLE_ARRAY_TYPE);
                    }
                    case 11: {
                        return this.newValue(CollectUtils.add(value.getInsns(), insn), TypeUtil.LONG_ARRAY_TYPE);
                    }
                }
                throw new AnalyzerException(insn, "Invalid array type specified in instruction");
            }
            case 189: {
                return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.getType((String)("[" + Type.getObjectType((String)((TypeInsnNode)insn).desc))));
            }
            case 190: {
                if (value.getValue() instanceof Unresolved && !((Unresolved)value.getValue()).isArray()) {
                    this.markBad(insn, new AnalyzerException(insn, "Expected an array type."));
                }
                return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.INT_TYPE);
            }
            case 191: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, "Expected reference type on stack for ATHROW.");
                }
                return null;
            }
            case 192: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, "Expected reference type on stack for CHECKCAST.");
                }
                return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.getObjectType((String)((TypeInsnNode)insn).desc));
            }
            case 193: {
                return this.newValue(CollectUtils.add(value.getInsns(), insn), Type.INT_TYPE);
            }
            case 194: 
            case 195: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, "Expected a reference type for monitor.");
                }
                return null;
            }
            case 198: 
            case 199: {
                if (!value.isReference()) {
                    throw new AnalyzerException(insn, "Expected a reference type ifnull/nonnull.");
                }
                value.setNullCheckedBy((JumpInsnNode)insn);
                return null;
            }
        }
        throw new IllegalStateException();
    }

    public AbstractValue binaryOperation(AbstractInsnNode insn, AbstractValue value1, AbstractValue value2) {
        Type expected2;
        Type expected1;
        boolean wasAALOAD = false;
        switch (insn.getOpcode()) {
            case 46: {
                expected1 = TypeUtil.INT_ARRAY_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 51: {
                expected1 = TypeUtil.isSubTypeOf(this.typeChecker, value1.getType(), TypeUtil.BOOLEAN_ARRAY_TYPE) ? TypeUtil.BOOLEAN_ARRAY_TYPE : TypeUtil.BYTE_ARRAY_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 52: {
                expected1 = TypeUtil.CHAR_ARRAY_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 53: {
                expected1 = TypeUtil.SHORT_ARRAY_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 47: {
                expected1 = TypeUtil.LONG_ARRAY_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 48: {
                expected1 = TypeUtil.FLOAT_ARRAY_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 49: {
                expected1 = TypeUtil.DOUBLE_ARRAY_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 50: {
                expected1 = Type.getType((String)"[Ljava/lang/Object;");
                expected2 = Type.INT_TYPE;
                wasAALOAD = true;
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                this.handleOpaques(insn, value1, value2);
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                expected1 = Type.INT_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 149: 
            case 150: {
                expected1 = Type.FLOAT_TYPE;
                expected2 = Type.FLOAT_TYPE;
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: 
            case 148: {
                expected1 = Type.LONG_TYPE;
                expected2 = Type.LONG_TYPE;
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                expected1 = Type.LONG_TYPE;
                expected2 = Type.INT_TYPE;
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 151: 
            case 152: {
                expected1 = Type.DOUBLE_TYPE;
                expected2 = Type.DOUBLE_TYPE;
                break;
            }
            case 165: 
            case 166: {
                expected1 = TypeUtil.OBJECT_TYPE;
                expected2 = TypeUtil.OBJECT_TYPE;
                break;
            }
            case 181: {
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                expected1 = Type.getObjectType((String)fieldInsn.owner);
                expected2 = Type.getType((String)fieldInsn.desc);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (!wasAALOAD || value1 == UninitializedValue.UNINITIALIZED_VALUE || !value1.isArray() || value1.getType().getDimensions() <= 1) {
            if (value1 != UninitializedValue.UNINITIALIZED_VALUE && value2 != UninitializedValue.UNINITIALIZED_VALUE) {
                if (!TypeUtil.isSubTypeOfOrNull(this.typeChecker, value1, expected1)) {
                    this.markBad(insn, new AnalyzerException(insn, "First argument not of expected type", (Object)expected1, (Value)value1));
                } else if (!TypeUtil.isSubTypeOfOrNull(this.typeChecker, value2, expected2)) {
                    this.markBad(insn, new AnalyzerException(insn, "Second argument not of expected type", (Object)expected2, (Value)value2));
                }
            } else {
                this.markBad(insn, new AnalyzerException(insn, "Cannot act on uninitialized values", (Object)expected2, (Value)value2));
            }
        }
        switch (insn.getOpcode()) {
            case 48: {
                return this.newValue(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), Type.FLOAT_TYPE);
            }
            case 47: {
                return this.newValue(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), Type.LONG_TYPE);
            }
            case 49: {
                return this.newValue(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), Type.DOUBLE_TYPE);
            }
            case 50: {
                if (value1.getType() == null) {
                    return this.newValue(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), TypeUtil.OBJECT_TYPE);
                }
                return this.newValue(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), Type.getType((String)value1.getType().getDescriptor().substring(1)));
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                return this.newValue(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), Type.INT_TYPE);
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        PrimitiveValue p1 = (PrimitiveValue)value1;
        PrimitiveValue p2 = (PrimitiveValue)value2;
        switch (insn.getOpcode()) {
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return p1.add(insn, p2);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return p1.sub(insn, p2);
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return p1.mul(insn, p2);
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return p1.div(insn, p2);
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return p1.rem(insn, p2);
            }
            case 120: 
            case 121: {
                return p1.shl(insn, p2);
            }
            case 122: 
            case 123: {
                return p1.shr(insn, p2);
            }
            case 124: 
            case 125: {
                return p1.ushr(insn, p2);
            }
            case 126: 
            case 127: {
                return p1.and(insn, p2);
            }
            case 128: 
            case 129: {
                return p1.or(insn, p2);
            }
            case 130: 
            case 131: {
                return p1.xor(insn, p2);
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                double v2;
                if (p1.getValue() == null || p2.getValue() == null || this.isValueUnknown(p1) || this.isValueUnknown(p2)) {
                    return this.newValue(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), Type.INT_TYPE);
                }
                double v1 = ((Number)value1.getValue()).doubleValue();
                if (v1 > (v2 = ((Number)value1.getValue()).doubleValue())) {
                    return PrimitiveValue.ofInt(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), 1);
                }
                if (v1 < v2) {
                    return PrimitiveValue.ofInt(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), -1);
                }
                return PrimitiveValue.ofInt(CollectUtils.combineAdd(value1.getInsns(), value2.getInsns(), insn), 0);
            }
        }
        throw new IllegalStateException();
    }

    public AbstractValue ternaryOperation(AbstractInsnNode insn, AbstractValue value1, AbstractValue value2, AbstractValue value3) {
        Type expected3;
        Type expected1;
        switch (insn.getOpcode()) {
            case 79: {
                expected1 = TypeUtil.INT_ARRAY_TYPE;
                expected3 = Type.INT_TYPE;
                break;
            }
            case 84: {
                expected1 = TypeUtil.isSubTypeOf(this.typeChecker, value1.getType(), TypeUtil.BOOLEAN_ARRAY_TYPE) ? TypeUtil.BOOLEAN_ARRAY_TYPE : TypeUtil.BYTE_ARRAY_TYPE;
                expected3 = Type.INT_TYPE;
                break;
            }
            case 85: {
                expected1 = TypeUtil.CHAR_ARRAY_TYPE;
                expected3 = Type.INT_TYPE;
                break;
            }
            case 86: {
                expected1 = TypeUtil.SHORT_ARRAY_TYPE;
                expected3 = Type.INT_TYPE;
                break;
            }
            case 80: {
                expected1 = TypeUtil.LONG_ARRAY_TYPE;
                expected3 = Type.LONG_TYPE;
                break;
            }
            case 81: {
                expected1 = TypeUtil.FLOAT_ARRAY_TYPE;
                expected3 = Type.FLOAT_TYPE;
                break;
            }
            case 82: {
                expected1 = TypeUtil.DOUBLE_ARRAY_TYPE;
                expected3 = Type.DOUBLE_TYPE;
                break;
            }
            case 83: {
                expected1 = value1.getType();
                expected3 = TypeUtil.OBJECT_TYPE;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (!TypeUtil.isSubTypeOf(this.typeChecker, value1.getType(), expected1)) {
            this.markBad(insn, new AnalyzerException(insn, "First argument not of expected type", (Object)expected1, (Value)value1));
        } else if (!Type.INT_TYPE.equals((Object)value2.getType())) {
            this.markBad(insn, new AnalyzerException(insn, "Second argument not an integer", (Object)BasicValue.INT_VALUE, (Value)value2));
        } else if (!TypeUtil.isSubTypeOf(this.typeChecker, value3.getType(), expected3)) {
            this.markBad(insn, new AnalyzerException(insn, "Second argument not of expected type", (Object)expected3, (Value)value3));
        }
        return null;
    }

    public AbstractValue naryOperation(AbstractInsnNode insn, List<? extends AbstractValue> values) throws AnalyzerException {
        Type retType;
        MethodInsnNode min;
        List argContributingInsns = values.stream().flatMap(value -> value.getInsns().stream()).distinct().collect(Collectors.toList());
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            for (AbstractValue abstractValue : values) {
                if (Type.INT_TYPE.equals((Object)abstractValue.getType())) continue;
                throw new AnalyzerException(insn, "MULTIANEWARRAY argument was not numeric!", (Object)this.newValue(insn, Type.INT_TYPE), (Value)abstractValue);
            }
            return this.newValue(CollectUtils.add(argContributingInsns, insn), Type.getType((String)((MultiANewArrayInsnNode)insn).desc));
        }
        String methodDescriptor = opcode == 186 ? ((InvokeDynamicInsnNode)insn).desc : ((MethodInsnNode)insn).desc;
        Type[] typeArray = Type.getArgumentTypes((String)methodDescriptor);
        int i = 0;
        int j = 0;
        if (opcode != 184 && opcode != 186) {
            AbstractValue actual;
            min = (MethodInsnNode)insn;
            Type owner = Type.getObjectType((String)min.owner);
            if (!(TypeUtil.isSubTypeOf(this.typeChecker, (actual = values.get(i++)).getType(), owner) || SimInterpreter.isMethodAddSuppressed(min) && actual instanceof NullConstantValue)) {
                this.markBad(insn, this.exceptionFactory.unexpectedMethodHostType(owner, actual.getType(), (MethodInsnNode)insn, actual, values, TypeMismatchKind.INVOKE_HOST_TYPE));
            }
        }
        while (i < values.size()) {
            AbstractValue actual;
            Type expected = typeArray[j++];
            if (TypeUtil.isSubTypeOfOrNull(this.typeChecker, actual = values.get(i++), expected)) continue;
            this.markBad(insn, this.exceptionFactory.unexpectedMethodArgType(expected, actual.getType(), insn, actual, values, j - 1, TypeMismatchKind.INVOKE_ARG_TYPE));
        }
        if (opcode == 186) {
            InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
            retType = Type.getReturnType((String)indy.desc);
            return this.newValue(CollectUtils.add(argContributingInsns, insn), retType);
        }
        if (opcode == 184) {
            min = (MethodInsnNode)insn;
            try {
                AbstractValue value3 = ReflectionSimulatedValue.ofStaticInvoke(this.staticInvokeFactory, min, values, this.typeChecker);
                if (value3 != null) {
                    value3.addContributing(CollectUtils.disjoint(argContributingInsns, value3.getInsns()));
                    return value3;
                }
            }
            catch (SimFailedException value3) {
                // empty catch block
            }
            retType = Type.getReturnType((String)((MethodInsnNode)insn).desc);
            return this.newValue(CollectUtils.add(argContributingInsns, insn), retType);
        }
        min = (MethodInsnNode)insn;
        AbstractValue ownerValue = values.get(0);
        if (ownerValue == UninitializedValue.UNINITIALIZED_VALUE) {
            throw new AnalyzerException(insn, "Cannot call method on uninitialized reference");
        }
        if (ownerValue instanceof NullConstantValue && !SimInterpreter.isMethodAddSuppressed(min) && !FlowUtil.isNullChecked(this.getBlockHandler(), ownerValue, insn)) {
            this.markBad(insn, this.exceptionFactory.unexpectedNullReference(min, ownerValue, values, TypeMismatchKind.INVOKE_HOST_NULL));
            return this.newValue(insn, Type.getMethodType((String)min.desc).getReturnType());
        }
        if (ownerValue instanceof NullConstantValue && SimInterpreter.isMethodAddSuppressed(min)) {
            return null;
        }
        if (opcode == 183 && min.name.equals("<init>")) {
            ownerValue.addContributing((AbstractInsnNode)min);
        }
        if (ownerValue instanceof AbstractSimulatedValue) {
            AbstractSimulatedValue simObject = (AbstractSimulatedValue)ownerValue;
            List<? extends AbstractValue> arguments = values.subList(1, values.size());
            try {
                AbstractValue refValue = simObject.ofVirtualInvoke(min, arguments);
                if (refValue != null) {
                    refValue.addContributing(CollectUtils.disjoint(argContributingInsns, refValue.getInsns()));
                }
                return refValue;
            }
            catch (SimFailedException simFailedException) {
                // empty catch block
            }
        }
        if (ownerValue instanceof VirtualValue) {
            VirtualValue virtualOwner = (VirtualValue)ownerValue;
            AbstractValue refValue = virtualOwner.ofMethodRef(insn, this.typeChecker, Type.getMethodType((String)((MethodInsnNode)insn).desc));
            if (refValue != null) {
                refValue.addContributing(CollectUtils.disjoint(argContributingInsns, refValue.getInsns()));
            }
            return refValue;
        }
        if (ownerValue instanceof NullConstantValue && FlowUtil.isNullChecked(this.getBlockHandler(), ownerValue, insn)) {
            AbstractValue refValue = this.newValue(insn, Type.getMethodType((String)min.desc).getReturnType());
            if (refValue != null) {
                refValue.addContributing(CollectUtils.disjoint(argContributingInsns, refValue.getInsns()));
            }
            return refValue;
        }
        throw new AnalyzerException(insn, "Virtual method context could not be resolved");
    }

    public void returnOperation(AbstractInsnNode insn, AbstractValue value, AbstractValue expected) {
        if (!TypeUtil.isSubTypeOfOrNull(this.typeChecker, value, expected)) {
            this.markBad(insn, this.exceptionFactory.unexpectedType(expected.getType(), value.getType(), insn, value, TypeMismatchKind.RETURN));
        }
    }

    public AbstractValue merge(AbstractValue value1, AbstractValue value2) {
        if (value2 == UninitializedValue.UNINITIALIZED_VALUE) {
            return value1;
        }
        if (value1.equals(value2)) {
            return value1;
        }
        List<AbstractInsnNode> merged = CollectUtils.distinct(CollectUtils.combine(value1.getInsns(), value2.getInsns()));
        if (value2 instanceof NullConstantValue) {
            return value1.isNull() ? AbstractValue.ofDefault(null, this.typeChecker, value1.getType()) : this.newValue(merged, value1.getType());
        }
        if (value1 instanceof NullConstantValue) {
            return value2.isNull() ? AbstractValue.ofDefault(null, this.typeChecker, value2.getType()) : this.newValue(merged, value2.getType());
        }
        if (value1.canMerge(value2)) {
            return this.newValue(merged, value1.getType());
        }
        if (value2.canMerge(value1)) {
            return this.newValue(merged, value2.getType());
        }
        if (value1 instanceof ExceptionValue && value2 instanceof ExceptionValue) {
            return ExceptionValue.ofHandledException(merged.get(0), this.typeChecker, this.typeResolver.commonException(value1.getType(), value2.getType()));
        }
        if (value1 instanceof VirtualValue && value2 instanceof VirtualValue) {
            return this.newValue(merged, this.typeResolver.common(value1.getType(), value2.getType()));
        }
        return UninitializedValue.UNINITIALIZED_VALUE;
    }

    private boolean isValueUnknown(AbstractValue value) {
        return value.getValue() == null || value.getValue() instanceof Unresolved;
    }

    private float toFloat(AbstractValue value) {
        return ((Number)value.getValue()).floatValue();
    }

    private double toDouble(AbstractValue value) {
        return ((Number)value.getValue()).doubleValue();
    }

    private int toInt(AbstractValue value) {
        return ((Number)value.getValue()).intValue();
    }

    private long toLong(AbstractValue value) {
        return ((Number)value.getValue()).longValue();
    }

    private static boolean isMethodAddSuppressed(MethodInsnNode insn) {
        return insn.owner.equals("java/lang/Throwable") && insn.name.equals("addSuppressed") && insn.desc.equals("(Ljava/lang/Throwable;)V");
    }
}

