/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.ModuleAttribute;
import software.coley.cafedude.classfile.attribute.ModuleMainClassAttribute;
import software.coley.cafedude.classfile.attribute.ModulePackagesAttribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpModule;
import software.coley.cafedude.classfile.constant.CpPackage;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.tree.visitor.ModuleVisitor;
import software.coley.cafedude.tree.visitor.writer.Symbols;
import software.coley.cafedude.util.Optional;

public class ModuleWriter
implements ModuleVisitor {
    private final CpModule name;
    private final int flags;
    private final CpUtf8 version;
    private final Symbols symbols;
    private final List<ModuleAttribute.Exports> exports = new ArrayList<ModuleAttribute.Exports>();
    private final List<ModuleAttribute.Opens> opens = new ArrayList<ModuleAttribute.Opens>();
    private final List<ModuleAttribute.Provides> provides = new ArrayList<ModuleAttribute.Provides>();
    private final List<ModuleAttribute.Requires> requires = new ArrayList<ModuleAttribute.Requires>();
    private final List<CpClass> uses = new ArrayList<CpClass>();
    private final List<CpPackage> modulePackages = new ArrayList<CpPackage>();
    private final List<Attribute> attributes = new ArrayList<Attribute>();
    private final Consumer<List<Attribute>> callback;

    ModuleWriter(Symbols symbols, CpModule name, int access, CpUtf8 version, Consumer<List<Attribute>> callback) {
        this.symbols = symbols;
        this.callback = callback;
        this.name = name;
        this.flags = access;
        this.version = version;
    }

    @Override
    public void visitExports(@Nonnull String exportPackage, int flags, String ... modules) {
        CpPackage packageEntry = this.symbols.newPackage(exportPackage);
        ArrayList<CpModule> moduleIndexes = new ArrayList<CpModule>();
        for (String module : modules) {
            moduleIndexes.add(this.symbols.newModule(module));
        }
        this.exports.add(new ModuleAttribute.Exports(packageEntry, flags, moduleIndexes));
    }

    @Override
    public void visitOpens(@Nonnull String openPackage, int flags, String ... modules) {
        CpPackage packageEntry = this.symbols.newPackage(openPackage);
        ArrayList<CpModule> moduleIndexes = new ArrayList<CpModule>();
        for (String module : modules) {
            moduleIndexes.add(this.symbols.newModule(module));
        }
        this.opens.add(new ModuleAttribute.Opens(packageEntry, flags, moduleIndexes));
    }

    @Override
    public void visitProvides(@Nonnull String service, String ... providers) {
        CpClass serviceEntry = this.symbols.newClass(service);
        ArrayList<CpClass> providerIndexes = new ArrayList<CpClass>();
        for (String provider : providers) {
            providerIndexes.add(this.symbols.newClass(provider));
        }
        this.provides.add(new ModuleAttribute.Provides(serviceEntry, providerIndexes));
    }

    @Override
    public void visitUses(@Nonnull String service) {
        this.uses.add(this.symbols.newClass(service));
    }

    @Override
    public void visitRequires(@Nonnull String module, int flags, @Nullable String version) {
        CpModule moduleRef = this.symbols.newModule(module);
        CpUtf8 versionRef = (CpUtf8)Optional.orNull((Object)module, this.symbols::newUtf8);
        this.requires.add(new ModuleAttribute.Requires(moduleRef, flags, versionRef));
    }

    @Override
    public void visitMainClass(@Nonnull String mainClass) {
        this.attributes.add((Attribute)new ModuleMainClassAttribute(this.symbols.newUtf8("ModuleMainClass"), this.symbols.newClass(mainClass)));
    }

    @Override
    public void visitPackage(@Nonnull String packageName) {
        this.modulePackages.add(this.symbols.newPackage(packageName));
    }

    @Override
    public void visitModuleEnd() {
        this.attributes.add((Attribute)new ModulePackagesAttribute(this.symbols.newUtf8("ModulePackages"), this.modulePackages));
        this.attributes.add((Attribute)new ModuleAttribute(this.symbols.newUtf8("Module"), this.name, this.flags, this.version, this.requires, this.exports, this.opens, this.uses, this.provides));
        this.callback.accept(this.attributes);
    }
}

