/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.function.Consumer;
import software.coley.cafedude.InvalidCodeException;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.instruction.Opcodes;
import software.coley.cafedude.tree.Code;
import software.coley.cafedude.tree.visitor.CodeDataVisitor;
import software.coley.cafedude.tree.visitor.CodeVisitor;
import software.coley.cafedude.tree.visitor.writer.CodeConverter;
import software.coley.cafedude.tree.visitor.writer.Symbols;

public class CodeWriter
implements CodeVisitor,
Opcodes {
    private final Symbols symbols;
    private final CodeDataVisitor converter = new CodeDataVisitor();
    private final Consumer<CodeAttribute> callback;

    CodeWriter(Symbols symbols, Consumer<CodeAttribute> callback) {
        this.symbols = symbols;
        this.callback = callback;
    }

    @Override
    public CodeVisitor codeDelegate() {
        return this.converter;
    }

    @Override
    public void visitCodeEnd() throws InvalidCodeException {
        Code code = this.converter.getCode();
        this.callback.accept(new CodeConverter(code, this.symbols).convertToAttribute());
    }
}

