/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import software.coley.cafedude.InvalidCodeException;
import software.coley.cafedude.UnresolvedLabelException;
import software.coley.cafedude.classfile.attribute.BootstrapMethodsAttribute;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.LineNumberTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTableAttribute;
import software.coley.cafedude.classfile.attribute.LocalVariableTypeTableAttribute;
import software.coley.cafedude.classfile.constant.CpEntry;
import software.coley.cafedude.classfile.constant.CpFieldRef;
import software.coley.cafedude.classfile.constant.CpInvokeDynamic;
import software.coley.cafedude.classfile.constant.CpMethodHandle;
import software.coley.cafedude.classfile.constant.CpMethodRef;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.instruction.BasicInstruction;
import software.coley.cafedude.classfile.instruction.CpRefInstruction;
import software.coley.cafedude.classfile.instruction.IincInstruction;
import software.coley.cafedude.classfile.instruction.Instruction;
import software.coley.cafedude.classfile.instruction.IntOperandInstruction;
import software.coley.cafedude.classfile.instruction.LookupSwitchInstruction;
import software.coley.cafedude.classfile.instruction.MultiANewArrayInstruction;
import software.coley.cafedude.classfile.instruction.Opcodes;
import software.coley.cafedude.classfile.instruction.TableSwitchInstruction;
import software.coley.cafedude.tree.Code;
import software.coley.cafedude.tree.Constant;
import software.coley.cafedude.tree.ExceptionHandler;
import software.coley.cafedude.tree.Handle;
import software.coley.cafedude.tree.Label;
import software.coley.cafedude.tree.Local;
import software.coley.cafedude.tree.insn.FieldInsn;
import software.coley.cafedude.tree.insn.FlowInsn;
import software.coley.cafedude.tree.insn.IIncInsn;
import software.coley.cafedude.tree.insn.Insn;
import software.coley.cafedude.tree.insn.IntInsn;
import software.coley.cafedude.tree.insn.InvokeDynamicInsn;
import software.coley.cafedude.tree.insn.LabelInsn;
import software.coley.cafedude.tree.insn.LdcInsn;
import software.coley.cafedude.tree.insn.LookupSwitchInsn;
import software.coley.cafedude.tree.insn.MethodInsn;
import software.coley.cafedude.tree.insn.MultiANewArrayInsn;
import software.coley.cafedude.tree.insn.TableSwitchInsn;
import software.coley.cafedude.tree.insn.TypeInsn;
import software.coley.cafedude.tree.insn.VarInsn;
import software.coley.cafedude.tree.visitor.writer.Symbols;

public class CodeConverter
implements Opcodes {
    private final Code code;
    private final Symbols symbols;

    CodeConverter(Code code, Symbols symbols) {
        this.code = code;
        this.symbols = symbols;
    }

    CodeAttribute convertToAttribute() throws InvalidCodeException {
        State state = new State();
        ArrayList<Instruction> converted = new ArrayList<Instruction>();
        TreeMap<Integer, Insn> insnMap = new TreeMap<Integer, Insn>();
        this.prepass(this.code.getInstructions());
        for (Insn insn : this.code.getInstructions()) {
            insnMap.put(state.offset, insn);
            Instruction convertedInsn = this.convertToInstruction(insn, state);
            if (convertedInsn == null) continue;
            converted.add(convertedInsn);
            state.offset += convertedInsn.computeSize();
        }
        ArrayList<LocalVariableTableAttribute.VarEntry> localVariables = new ArrayList<LocalVariableTableAttribute.VarEntry>();
        ArrayList<LocalVariableTypeTableAttribute.VarTypeEntry> localVariableTypes = new ArrayList<LocalVariableTypeTableAttribute.VarTypeEntry>();
        for (Local local : this.code.getLocals()) {
            this.checkLabel(local.getStart(), "local <" + local.getIndex() + "> start");
            this.checkLabel(local.getEnd(), "local <" + local.getIndex() + "> end");
            int startPc = local.getStart().getOffset();
            int endPc = local.getEnd().getOffset();
            int length = endPc - startPc;
            LocalVariableTableAttribute.VarEntry var = new LocalVariableTableAttribute.VarEntry(startPc, length, this.symbols.newUtf8(local.getName()), this.symbols.newUtf8(local.getDesc().getDescriptor()), local.getIndex());
            localVariables.add(var);
            if (local.getSignature() == null) continue;
            LocalVariableTypeTableAttribute.VarTypeEntry type = new LocalVariableTypeTableAttribute.VarTypeEntry(startPc, length, this.symbols.newUtf8(local.getName()), this.symbols.newUtf8(local.getSignature()), local.getIndex());
            localVariableTypes.add(type);
        }
        ArrayList<BootstrapMethodsAttribute.BootstrapMethod> bootstrapMethods = new ArrayList<BootstrapMethodsAttribute.BootstrapMethod>();
        for (BsmEntry bsmEntry : state.bsmEntries) {
            CpMethodHandle bsm = this.symbols.newHandle(bsmEntry.handle);
            ArrayList<CpEntry> args = new ArrayList<CpEntry>();
            for (Constant constant : bsmEntry.args) {
                args.add(this.symbols.newConstant(constant));
            }
            bootstrapMethods.add(new BootstrapMethodsAttribute.BootstrapMethod(bsm, args));
        }
        ArrayList<CodeAttribute.ExceptionTableEntry> arrayList = new ArrayList<CodeAttribute.ExceptionTableEntry>();
        for (ExceptionHandler handler : this.code.getHandlers()) {
            String catchType = handler.getType();
            String catchTypeRep = catchType == null ? "*" : catchType;
            this.checkLabel(handler.getStart(), "handler <" + catchTypeRep + "> start");
            this.checkLabel(handler.getEnd(), "handler <" + catchTypeRep + "> end");
            this.checkLabel(handler.getHandler(), "handler <" + catchTypeRep + "> handler");
            arrayList.add(new CodeAttribute.ExceptionTableEntry(handler.getStart().getOffset(), handler.getEnd().getOffset(), handler.getHandler().getOffset(), catchType == null ? null : this.symbols.newClass(catchType)));
        }
        ArrayList<Object> attributes = new ArrayList<Object>();
        if (!localVariables.isEmpty()) {
            attributes.add(new LocalVariableTableAttribute(this.symbols.newUtf8("LocalVariableTable"), localVariables));
        }
        if (!localVariableTypes.isEmpty()) {
            attributes.add(new LocalVariableTypeTableAttribute(this.symbols.newUtf8("LocalVariableTypeTable"), localVariableTypes));
        }
        if (!bootstrapMethods.isEmpty()) {
            attributes.add(new BootstrapMethodsAttribute(this.symbols.newUtf8("BootstrapMethods"), bootstrapMethods));
        }
        if (!state.lineEntries.isEmpty()) {
            ArrayList<LineNumberTableAttribute.LineEntry> sorted = new ArrayList<LineNumberTableAttribute.LineEntry>(state.lineEntries);
            sorted.sort(Comparator.comparingInt(LineNumberTableAttribute.LineEntry::getStartPc));
            attributes.add(new LineNumberTableAttribute(this.symbols.newUtf8("LineNumberTable"), sorted));
        }
        return new CodeAttribute(this.symbols.newUtf8("Code"), this.code.getMaxStack(), this.code.getMaxLocals(), converted, arrayList, attributes);
    }

    private void prepass(List<Insn> insns) {
        int offset = 0;
        for (Insn insn : insns) {
            int size = insn.size();
            switch (insn.getKind()) {
                case LDC: {
                    LdcInsn ldcInsn = (LdcInsn)insn;
                    CpEntry constant = this.symbols.newConstant(ldcInsn.getConstant());
                    if (constant.getIndex() <= 255 && !constant.isWide() || ldcInsn.getOpcode() != 18) break;
                    ++size;
                    break;
                }
                case VAR: {
                    VarInsn varInsn = (VarInsn)insn;
                    if (!varInsn.supportsSingleOpInsn()) break;
                    --size;
                    break;
                }
                case TABLE_SWITCH: 
                case LOOKUP_SWITCH: {
                    offset += 4 - (offset + 1) & 3;
                    break;
                }
                case LABEL: {
                    LabelInsn labelInsn = (LabelInsn)insn;
                    labelInsn.getLabel().setOffset(offset);
                    break;
                }
            }
            offset += size;
        }
    }

    Instruction convertToInstruction(Insn insn, State state) throws InvalidCodeException {
        int opcode = insn.getOpcode();
        switch (insn.getKind()) {
            case ARITHMETIC: 
            case ARRAY: 
            case CONSTANT: 
            case RETURN: 
            case STACK: 
            case NOP: 
            case MONITOR: 
            case THROW: {
                return new BasicInstruction(opcode);
            }
            case FIELD: {
                FieldInsn fieldInsn = (FieldInsn)insn;
                CpFieldRef fieldRef = this.symbols.newField(fieldInsn.getOwner(), fieldInsn.getName(), fieldInsn.getDescriptor());
                return new CpRefInstruction(opcode, (CpEntry)fieldRef);
            }
            case METHOD: {
                MethodInsn methodInsn = (MethodInsn)insn;
                CpMethodRef methodRef = this.symbols.newMethod(methodInsn.getOwner(), methodInsn.getName(), methodInsn.getDescriptor());
                return new CpRefInstruction(opcode, (CpEntry)methodRef);
            }
            case LDC: {
                LdcInsn ldcInsn = (LdcInsn)insn;
                CpEntry constant = this.symbols.newConstant(ldcInsn.getConstant());
                int ldcOpcode = 18;
                if (constant.getIndex() > 255) {
                    ldcOpcode = 19;
                }
                if (constant.isWide()) {
                    ldcOpcode = 20;
                }
                return new CpRefInstruction(ldcOpcode, this.symbols.newConstant(ldcInsn.getConstant()));
            }
            case MULTI_ANEWARRAY: {
                MultiANewArrayInsn manai = (MultiANewArrayInsn)insn;
                return new MultiANewArrayInstruction(this.symbols.newClass(manai.getOwner()), manai.getDimensions());
            }
            case TYPE: {
                TypeInsn typeInsn = (TypeInsn)insn;
                return new CpRefInstruction(opcode, (CpEntry)this.symbols.newClass(typeInsn.getDescriptor().getDescriptor()));
            }
            case FLOW: {
                FlowInsn flowInsn = (FlowInsn)insn;
                this.checkLabel(flowInsn.getLabel(), insn, state);
                int target = flowInsn.getLabel().getOffset();
                int offset = target - state.offset;
                return new IntOperandInstruction(opcode, offset);
            }
            case INT: {
                IntInsn intInsn = (IntInsn)insn;
                return new IntOperandInstruction(opcode, intInsn.getOperand());
            }
            case LOOKUP_SWITCH: {
                LookupSwitchInsn lsi = (LookupSwitchInsn)insn;
                this.checkLabel(lsi.getDefaultLabel(), insn, state);
                int defaultOffset = lsi.getDefaultLabel().getOffset() - state.offset;
                List<Integer> keys = lsi.getKeys();
                ArrayList<Integer> offsets = new ArrayList<Integer>();
                for (Label label : lsi.getLabels()) {
                    offsets.add(label.getOffset() - state.offset);
                }
                LookupSwitchInstruction lswitch = new LookupSwitchInstruction(defaultOffset, keys, offsets);
                lswitch.notifyStartPosition(state.offset);
                return lswitch;
            }
            case TABLE_SWITCH: {
                TableSwitchInsn tsi = (TableSwitchInsn)insn;
                this.checkLabel(tsi.getDefaultLabel(), insn, state);
                int defaultOffset = tsi.getDefaultLabel().getOffset() - state.offset;
                int low = tsi.getMin();
                int high = tsi.getMax();
                ArrayList<Integer> offsets = new ArrayList<Integer>();
                for (Label label : tsi.getLabels()) {
                    offsets.add(label.getOffset() - state.offset);
                }
                TableSwitchInstruction tswitch = new TableSwitchInstruction(defaultOffset, low, high, offsets);
                tswitch.notifyStartPosition(state.offset);
                return tswitch;
            }
            case INVOKE_DYNAMIC: {
                InvokeDynamicInsn idi = (InvokeDynamicInsn)insn;
                Handle handle = idi.getBootstrapMethod();
                int index = state.findBsm(handle, idi.getBootstrapArguments());
                CpNameType nameType = this.symbols.newNameType(idi.getName(), idi.getDescriptor());
                CpInvokeDynamic invokeDynamic = this.symbols.newInvokeDynamic(index, nameType);
                return new CpRefInstruction(opcode, (CpEntry)invokeDynamic);
            }
            case VAR: {
                VarInsn varInsn = (VarInsn)insn;
                int var = varInsn.getIndex();
                if (var < 4) {
                    if (opcode >= 21 && opcode <= 25) {
                        opcode = 26 + (opcode - 21) * 4 + var;
                    } else if (opcode >= 54 && opcode <= 58) {
                        opcode = 59 + (opcode - 54) * 4 + var;
                    }
                    --state.offset;
                    return new BasicInstruction(opcode);
                }
                return new IntOperandInstruction(opcode, var);
            }
            case LABEL: {
                LabelInsn labelInsn = (LabelInsn)insn;
                for (Integer line : labelInsn.getLabel().getLines()) {
                    state.lineEntries.add(new LineNumberTableAttribute.LineEntry(state.offset, line.intValue()));
                }
                return null;
            }
            case IINC: {
                IIncInsn iincInsn = (IIncInsn)insn;
                return new IincInstruction(iincInsn.getIndex(), iincInsn.getIncrement());
            }
        }
        throw new IllegalArgumentException("Unknown instruction: " + insn);
    }

    private void checkLabel(Label label, Insn insn, State state) throws InvalidCodeException {
        if (!label.isResolved()) {
            throw new UnresolvedLabelException(label, state.offset, insn);
        }
    }

    private void checkLabel(Label label, String where) throws InvalidCodeException {
        if (!label.isResolved()) {
            throw new UnresolvedLabelException(label, where);
        }
    }

    static class State {
        Set<BsmEntry> bsmEntries = new HashSet<BsmEntry>();
        Set<LineNumberTableAttribute.LineEntry> lineEntries = new HashSet<LineNumberTableAttribute.LineEntry>();
        int offset = 0;

        State() {
        }

        int findBsm(Handle handle, List<Constant> args) {
            BsmEntry entry = null;
            int index = 0;
            for (BsmEntry bsmEntry : this.bsmEntries) {
                if (bsmEntry.handle.equals(handle) && bsmEntry.args.equals(args)) {
                    entry = bsmEntry;
                    break;
                }
                ++index;
            }
            if (entry == null) {
                entry = new BsmEntry(handle, args);
                this.bsmEntries.add(entry);
                index = this.bsmEntries.size() - 1;
            }
            return index;
        }
    }

    static class BsmEntry {
        final Handle handle;
        final List<Constant> args;

        BsmEntry(Handle handle, List<Constant> args) {
            this.handle = handle;
            this.args = args;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BsmEntry bsmEntry = (BsmEntry)o;
            if (!this.handle.equals(bsmEntry.handle)) {
                return false;
            }
            return this.args.equals(bsmEntry.args);
        }

        public int hashCode() {
            int result = this.handle.hashCode();
            result = 31 * result + this.args.hashCode();
            return result;
        }
    }
}

