/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.writer;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.InvalidClassException;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.ConstPool;
import software.coley.cafedude.classfile.Descriptor;
import software.coley.cafedude.classfile.attribute.Attribute;
import software.coley.cafedude.classfile.attribute.EnclosingMethodAttribute;
import software.coley.cafedude.classfile.attribute.InnerClassesAttribute;
import software.coley.cafedude.classfile.attribute.RecordAttribute;
import software.coley.cafedude.classfile.attribute.SourceDebugExtensionAttribute;
import software.coley.cafedude.classfile.attribute.SourceFileAttribute;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.classfile.constant.CpNameType;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.io.ClassBuilder;
import software.coley.cafedude.io.ClassFileWriter;
import software.coley.cafedude.tree.visitor.ClassVisitor;
import software.coley.cafedude.tree.visitor.FieldVisitor;
import software.coley.cafedude.tree.visitor.MethodVisitor;
import software.coley.cafedude.tree.visitor.ModuleVisitor;
import software.coley.cafedude.tree.visitor.RecordComponentVisitor;
import software.coley.cafedude.tree.visitor.writer.DeclarationWriter;
import software.coley.cafedude.tree.visitor.writer.FieldWriter;
import software.coley.cafedude.tree.visitor.writer.MethodWriter;
import software.coley.cafedude.tree.visitor.writer.ModuleWriter;
import software.coley.cafedude.tree.visitor.writer.RecordComponentWriter;
import software.coley.cafedude.tree.visitor.writer.Symbols;
import software.coley.cafedude.util.Optional;

public class ClassWriter
extends DeclarationWriter
implements ClassVisitor {
    final ClassBuilder builder;
    private final List<InnerClassesAttribute.InnerClass> innerClasses = new ArrayList<InnerClassesAttribute.InnerClass>();
    private final List<RecordAttribute.RecordComponent> recordComponents = new ArrayList<RecordAttribute.RecordComponent>();

    public ClassWriter(int versionMajor, int versionMinor) {
        super(new Symbols(new ConstPool()));
        this.builder = new ClassBuilder();
        this.builder.setVersionMajor(versionMajor);
        this.builder.setVersionMinor(versionMinor);
        this.builder.setConstPool(this.symbols.pool);
    }

    @Override
    public void visitClass(@Nonnull String name, int access, @Nullable String superName, String ... interfaces) {
        this.builder.setThisClass(this.symbols.newClass(name));
        this.builder.setAccess(access);
        this.builder.setSuperClass((CpClass)Optional.orNull((Object)superName, s -> this.symbols.newClass((String)s)));
        for (String anInterface : interfaces) {
            this.builder.addInterface(this.symbols.newClass(anInterface));
        }
    }

    @Override
    @Nonnull
    public MethodVisitor visitMethod(@Nonnull String name, int access, @Nonnull Descriptor descriptor) {
        return new MethodWriter(this.symbols, access, this.symbols.newUtf8(name), this.symbols.newUtf8(descriptor.getDescriptor()), arg_0 -> ((ClassBuilder)this.builder).addMethod(arg_0));
    }

    @Override
    @Nonnull
    public FieldVisitor visitField(@Nonnull String name, int access, @Nonnull Descriptor descriptor) {
        return new FieldWriter(this.symbols, access, this.symbols.newUtf8(name), this.symbols.newUtf8(descriptor.getDescriptor()), arg_0 -> ((ClassBuilder)this.builder).addField(arg_0));
    }

    @Override
    public void visitOuterClass(@Nonnull String owner, @Nullable String name, @Nullable Descriptor descriptor) {
        this.attributes.add(new EnclosingMethodAttribute(this.symbols.newUtf8("EnclosingMethod"), this.symbols.newClass(owner), (CpNameType)Optional.orNull((Object)name, n -> this.symbols.newNameType(name, descriptor))));
    }

    @Override
    public void visitInnerClass(String name, @Nullable String outerName, @Nullable String innerName, int access) {
        this.innerClasses.add(new InnerClassesAttribute.InnerClass(this.symbols.newClass(name), (CpClass)Optional.orNull((Object)outerName, this.symbols::newClass), (CpUtf8)Optional.orNull((Object)innerName, this.symbols::newUtf8), access));
    }

    @Override
    public void visitSource(@Nullable String source, @Nullable byte[] debug) {
        if (source != null) {
            this.attributes.add(new SourceFileAttribute(this.symbols.newUtf8("SourceFile"), this.symbols.newUtf8(source)));
        }
        if (debug != null) {
            this.attributes.add(new SourceDebugExtensionAttribute(this.symbols.newUtf8("SourceDebugExtension"), debug));
        }
    }

    @Override
    public ModuleVisitor visitModule(@Nonnull String name, int access, @Nullable String version) {
        return new ModuleWriter(this.symbols, this.symbols.newModule(name), access, (CpUtf8)Optional.orNull((Object)version, this.symbols::newUtf8), this.attributes::addAll);
    }

    @Override
    public RecordComponentVisitor visitRecordComponent(@Nonnull String name, @Nonnull Descriptor descriptor) {
        return new RecordComponentWriter(this.symbols, this.symbols.newUtf8(name), this.symbols.newUtf8(descriptor.getDescriptor()), this.recordComponents::add);
    }

    @Override
    public void visitClassEnd() {
        super.visitDeclarationEnd();
        if (!this.innerClasses.isEmpty()) {
            this.attributes.add(new InnerClassesAttribute(this.symbols.newUtf8("InnerClasses"), this.innerClasses));
        }
        if (!this.recordComponents.isEmpty()) {
            this.attributes.add(new RecordAttribute(this.symbols.newUtf8("Record"), this.recordComponents));
        }
        for (Attribute attribute : this.attributes) {
            this.builder.addAttribute(attribute);
        }
    }

    public byte[] toByteArray() throws InvalidClassException {
        this.builder.setConstPool(this.symbols.pool);
        ClassFile file = this.builder.build();
        ClassFileWriter writer = new ClassFileWriter();
        return writer.write(file);
    }
}

