/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.reader;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.cafedude.InvalidClassException;
import software.coley.cafedude.InvalidCodeException;
import software.coley.cafedude.classfile.ClassFile;
import software.coley.cafedude.classfile.Method;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.TypeAnnotation;
import software.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import software.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.CodeAttribute;
import software.coley.cafedude.classfile.attribute.ConstantValueAttribute;
import software.coley.cafedude.classfile.attribute.DeprecatedAttribute;
import software.coley.cafedude.classfile.attribute.ExceptionsAttribute;
import software.coley.cafedude.classfile.attribute.MethodParametersAttribute;
import software.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;
import software.coley.cafedude.classfile.attribute.SignatureAttribute;
import software.coley.cafedude.classfile.attribute.SyntheticAttribute;
import software.coley.cafedude.classfile.behavior.AttributeHolder;
import software.coley.cafedude.classfile.constant.CpClass;
import software.coley.cafedude.transform.LabelTransformer;
import software.coley.cafedude.tree.visitor.AnnotationDefaultVisitor;
import software.coley.cafedude.tree.visitor.AnnotationVisitor;
import software.coley.cafedude.tree.visitor.CodeVisitor;
import software.coley.cafedude.tree.visitor.DeclarationVisitor;
import software.coley.cafedude.tree.visitor.FieldVisitor;
import software.coley.cafedude.tree.visitor.MethodVisitor;
import software.coley.cafedude.tree.visitor.reader.AnnotationReader;
import software.coley.cafedude.tree.visitor.reader.CodeReader;
import software.coley.cafedude.util.ConstantUtil;

public class MemberReader {
    private final ClassFile classFile;
    private final LabelTransformer transformer;

    MemberReader(@Nonnull ClassFile file, @Nonnull LabelTransformer transformer) {
        this.transformer = transformer;
        this.classFile = file;
    }

    static void visitDeclaration(@Nonnull DeclarationVisitor visitor, @Nonnull AttributeHolder member) {
        SignatureAttribute signature;
        AnnotationsAttribute annotations = (AnnotationsAttribute)member.getAttribute(AnnotationsAttribute.class);
        if (annotations != null) {
            boolean visible = annotations.isVisible();
            for (Annotation annotation : annotations.getAnnotations()) {
                AnnotationVisitor av;
                String type = annotation.getType().getText();
                if (annotation instanceof TypeAnnotation) {
                    TypeAnnotation ta = (TypeAnnotation)annotation;
                    av = visitor.visitTypeAnnotation(type, ta.getTargetInfo(), ta.getTypePath(), visible);
                } else {
                    av = visitor.visitAnnotation(type, visible);
                }
                if (av == null) continue;
                AnnotationReader.visitAnnotation(annotation, av);
                av.visitAnnotationEnd();
            }
        }
        if ((signature = (SignatureAttribute)member.getAttribute(SignatureAttribute.class)) != null) {
            visitor.visitSignature(signature.getSignature().getText());
        }
        visitor.visitDeprecated(member.getAttribute(DeprecatedAttribute.class) != null);
        visitor.visitSynthetic(member.getAttribute(SyntheticAttribute.class) != null);
    }

    void visitMethod(@Nullable MethodVisitor mv, @Nonnull AttributeHolder member) throws InvalidClassException {
        AnnotationDefaultAttribute annotationDefault;
        MethodParametersAttribute methodParameters;
        ParameterAnnotationsAttribute parameterAnnotations;
        if (mv == null) {
            return;
        }
        MemberReader.visitDeclaration(mv, member);
        this.visitCode(mv.visitCode(), (Method)member);
        ExceptionsAttribute exceptions = (ExceptionsAttribute)member.getAttribute(ExceptionsAttribute.class);
        if (exceptions != null) {
            for (CpClass exception : exceptions.getExceptionTable()) {
                mv.visitThrows(exception.getName().getText());
            }
        }
        if ((parameterAnnotations = (ParameterAnnotationsAttribute)member.getAttribute(ParameterAnnotationsAttribute.class)) != null) {
            boolean visible = parameterAnnotations.isVisible();
            for (Map.Entry entry : parameterAnnotations.getParameterAnnotations().entrySet()) {
                int parameter = (Integer)entry.getKey();
                for (Annotation annotation : (List)entry.getValue()) {
                    String type = annotation.getType().getText();
                    AnnotationVisitor av = mv.visitParameterAnnotation(parameter, type, visible);
                    if (av == null) continue;
                    AnnotationReader.visitAnnotation(annotation, av);
                    av.visitAnnotationEnd();
                }
            }
        }
        if ((methodParameters = (MethodParametersAttribute)member.getAttribute(MethodParametersAttribute.class)) != null) {
            for (MethodParametersAttribute.Parameter parameter : methodParameters.getParameters()) {
                String name = parameter.getName().getText();
                mv.visitParameter(name, parameter.getAccessFlags());
            }
        }
        if ((annotationDefault = (AnnotationDefaultAttribute)member.getAttribute(AnnotationDefaultAttribute.class)) != null) {
            AnnotationDefaultVisitor adv = mv.visitAnnotationDefault();
            if (adv == null) {
                return;
            }
            AnnotationReader.visitAnnotationDefaultElement(annotationDefault.getElementValue(), adv);
        }
        mv.visitMethodEnd();
    }

    void visitField(FieldVisitor fv, AttributeHolder member) {
        if (fv == null) {
            return;
        }
        MemberReader.visitDeclaration(fv, member);
        ConstantValueAttribute constant = (ConstantValueAttribute)member.getAttribute(ConstantValueAttribute.class);
        if (constant != null) {
            fv.visitConstantValue(ConstantUtil.from(constant.getConstantValue()));
        }
        fv.visitFieldEnd();
    }

    private void visitCode(CodeVisitor cv, Method method) throws InvalidCodeException {
        if (cv == null) {
            return;
        }
        CodeAttribute code = (CodeAttribute)method.getAttribute(CodeAttribute.class);
        if (code == null) {
            return;
        }
        CodeReader cr = new CodeReader(this.classFile, code, cv, method, this.transformer.getLabels(method), this.transformer.getInstructions(method));
        cr.accept();
    }
}

