/*
 * Decompiled with CFR 0.152.
 */
package software.coley.cafedude.tree.visitor.reader;

import java.util.Map;
import javax.annotation.Nonnull;
import software.coley.cafedude.classfile.annotation.Annotation;
import software.coley.cafedude.classfile.annotation.AnnotationElementValue;
import software.coley.cafedude.classfile.annotation.ArrayElementValue;
import software.coley.cafedude.classfile.annotation.ElementValue;
import software.coley.cafedude.classfile.annotation.EnumElementValue;
import software.coley.cafedude.classfile.constant.CpUtf8;
import software.coley.cafedude.tree.visitor.AnnotationArrayVisitor;
import software.coley.cafedude.tree.visitor.AnnotationDefaultVisitor;
import software.coley.cafedude.tree.visitor.AnnotationVisitor;
import software.coley.cafedude.util.ConstantUtil;

class AnnotationReader {
    AnnotationReader() {
    }

    static void visitAnnotation(@Nonnull Annotation annotation, @Nonnull AnnotationVisitor av) {
        for (Map.Entry entry : annotation.getValues().entrySet()) {
            AnnotationReader.visitAnnotationElement(((CpUtf8)entry.getKey()).getText(), (ElementValue)entry.getValue(), av);
        }
    }

    static void visitAnnotationElement(@Nonnull String key, @Nonnull ElementValue value, @Nonnull AnnotationVisitor av) {
        if (value.getTag() == '[' || value.getTag() == '@' || value.getTag() == 'e') {
            if (value instanceof ArrayElementValue) {
                ArrayElementValue array = (ArrayElementValue)value;
                AnnotationArrayVisitor aav = av.visitArray(key);
                if (aav == null) {
                    return;
                }
                for (ElementValue elementValue : array.getArray()) {
                    AnnotationReader.visitArrayElement(elementValue, aav);
                }
                aav.visitArrayEnd();
            } else if (value instanceof EnumElementValue) {
                EnumElementValue enumValue = (EnumElementValue)value;
                av.visitEnum(key, enumValue.getType().getText(), enumValue.getName().getText());
            } else if (value instanceof AnnotationElementValue) {
                AnnotationElementValue annotationValue = (AnnotationElementValue)value;
                Annotation annotation = annotationValue.getAnnotation();
                AnnotationVisitor annotationVisitor = av.visitAnnotation(key, annotation.getType().getText());
                if (annotationVisitor == null) {
                    return;
                }
                AnnotationReader.visitAnnotation(annotationValue.getAnnotation(), annotationVisitor);
                annotationVisitor.visitAnnotationEnd();
            }
        } else {
            av.visitValue(key, ConstantUtil.from(value));
        }
    }

    static void visitArrayElement(@Nonnull ElementValue value, @Nonnull AnnotationArrayVisitor aav) {
        if (value.getTag() == '[' || value.getTag() == '@' || value.getTag() == 'e') {
            if (value instanceof ArrayElementValue) {
                ArrayElementValue array = (ArrayElementValue)value;
                AnnotationArrayVisitor aav2 = aav.visitSubArray();
                if (aav2 == null) {
                    return;
                }
                for (ElementValue elementValue : array.getArray()) {
                    AnnotationReader.visitArrayElement(elementValue, aav2);
                }
                aav2.visitArrayEnd();
            } else if (value instanceof EnumElementValue) {
                EnumElementValue enumValue = (EnumElementValue)value;
                aav.visitArrayEnum(enumValue.getType().getText(), enumValue.getName().getText());
            } else if (value instanceof AnnotationElementValue) {
                AnnotationElementValue annotationValue = (AnnotationElementValue)value;
                Annotation annotation = annotationValue.getAnnotation();
                AnnotationVisitor annotationVisitor = aav.visitArrayAnnotation(annotation.getType().getText());
                if (annotationVisitor == null) {
                    return;
                }
                AnnotationReader.visitAnnotation(annotationValue.getAnnotation(), annotationVisitor);
                annotationVisitor.visitAnnotationEnd();
            }
        } else {
            aav.visitArrayValue(ConstantUtil.from(value));
        }
    }

    static void visitAnnotationDefaultElement(@Nonnull ElementValue value, @Nonnull AnnotationDefaultVisitor adv) {
        if (value.getTag() == '[' || value.getTag() == '@' || value.getTag() == 'e') {
            if (value instanceof ArrayElementValue) {
                ArrayElementValue array = (ArrayElementValue)value;
                AnnotationArrayVisitor aav = adv.visitDefaultArray();
                if (aav == null) {
                    return;
                }
                for (ElementValue elementValue : array.getArray()) {
                    AnnotationReader.visitArrayElement(elementValue, aav);
                }
                aav.visitArrayEnd();
            } else if (value instanceof EnumElementValue) {
                EnumElementValue enumValue = (EnumElementValue)value;
                adv.visitDefaultEnum(enumValue.getType().getText(), enumValue.getName().getText());
            } else if (value instanceof AnnotationElementValue) {
                AnnotationElementValue annotationValue = (AnnotationElementValue)value;
                Annotation annotation = annotationValue.getAnnotation();
                AnnotationVisitor annotationVisitor = adv.visitDefaultAnnotation(annotation.getType().getText());
                if (annotationVisitor == null) {
                    return;
                }
                AnnotationReader.visitAnnotation(annotationValue.getAnnotation(), annotationVisitor);
                annotationVisitor.visitAnnotationEnd();
            }
        } else {
            adv.visitDefaultValue(ConstantUtil.from(value));
        }
    }
}

