/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.io;

import java.io.IOException;
import java.util.ArrayList;
import me.coley.cafedude.InvalidClassException;
import me.coley.cafedude.classfile.ClassFile;
import me.coley.cafedude.classfile.Field;
import me.coley.cafedude.classfile.Method;
import me.coley.cafedude.classfile.attribute.Attribute;
import me.coley.cafedude.classfile.constant.ConstPoolEntry;
import me.coley.cafedude.classfile.constant.CpClass;
import me.coley.cafedude.classfile.constant.CpDouble;
import me.coley.cafedude.classfile.constant.CpDynamic;
import me.coley.cafedude.classfile.constant.CpFieldRef;
import me.coley.cafedude.classfile.constant.CpFloat;
import me.coley.cafedude.classfile.constant.CpInt;
import me.coley.cafedude.classfile.constant.CpInterfaceMethodRef;
import me.coley.cafedude.classfile.constant.CpInvokeDynamic;
import me.coley.cafedude.classfile.constant.CpLong;
import me.coley.cafedude.classfile.constant.CpMethodHandle;
import me.coley.cafedude.classfile.constant.CpMethodRef;
import me.coley.cafedude.classfile.constant.CpMethodType;
import me.coley.cafedude.classfile.constant.CpModule;
import me.coley.cafedude.classfile.constant.CpNameType;
import me.coley.cafedude.classfile.constant.CpPackage;
import me.coley.cafedude.classfile.constant.CpString;
import me.coley.cafedude.classfile.constant.CpUtf8;
import me.coley.cafedude.io.AttributeContext;
import me.coley.cafedude.io.AttributeReader;
import me.coley.cafedude.io.ClassBuilder;
import me.coley.cafedude.io.IndexableByteStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassFileReader {
    private static final Logger logger = LoggerFactory.getLogger(ClassFileReader.class);
    private IndexableByteStream is;
    private boolean dropForwardVersioned = true;
    private boolean dropEofAttributes = true;
    private boolean dropDupeAnnotations = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassFile read(byte[] code) throws InvalidClassException {
        ClassBuilder builder = new ClassBuilder();
        try {
            try (IndexableByteStream is = new IndexableByteStream(code);){
                this.is = is;
                if (is.readInt() != -889275714) {
                    throw new InvalidClassException("Does not start with 0xCAFEBABE");
                }
                builder.setVersionMinor(is.readUnsignedShort());
                builder.setVersionMajor(is.readUnsignedShort());
                int numConstants = is.readUnsignedShort();
                for (int i = 1; i < numConstants; ++i) {
                    ConstPoolEntry entry = this.readPoolEntry();
                    builder.getPool().add(entry);
                    if (!entry.isWide()) continue;
                    ++i;
                }
                builder.setAccess(is.readUnsignedShort());
                builder.setClassIndex(is.readUnsignedShort());
                builder.setSuperIndex(is.readUnsignedShort());
                int numInterfaces = is.readUnsignedShort();
                for (int i = 0; i < numInterfaces; ++i) {
                    builder.addInterface(is.readUnsignedShort());
                }
                int numFields = is.readUnsignedShort();
                for (int i = 0; i < numFields; ++i) {
                    builder.addField(this.readField(builder));
                }
                int numMethods = is.readUnsignedShort();
                for (int i = 0; i < numMethods; ++i) {
                    builder.addMethod(this.readMethod(builder));
                }
                int numAttributes = is.readUnsignedShort();
                for (int i = 0; i < numAttributes; ++i) {
                    Attribute attr = new AttributeReader(this, builder, is).readAttribute(AttributeContext.CLASS);
                    if (attr == null) continue;
                    builder.addAttribute(attr);
                }
                ClassFile classFile = builder.build();
                return classFile;
            }
            catch (IOException ex) {
                logger.debug("IO error reading class", (Throwable)ex);
                throw new InvalidClassException(ex);
            }
        }
        catch (Throwable t) {
            logger.debug("Error reading class", t);
            throw new InvalidClassException(t);
        }
    }

    private ConstPoolEntry readPoolEntry() throws IOException, InvalidClassException {
        int tag = this.is.readUnsignedByte();
        switch (tag) {
            case 1: {
                return new CpUtf8(this.is.readUTF());
            }
            case 3: {
                return new CpInt(this.is.readInt());
            }
            case 4: {
                return new CpFloat(this.is.readFloat());
            }
            case 5: {
                return new CpLong(this.is.readLong());
            }
            case 6: {
                return new CpDouble(this.is.readDouble());
            }
            case 8: {
                return new CpString(this.is.readUnsignedShort());
            }
            case 7: {
                return new CpClass(this.is.readUnsignedShort());
            }
            case 9: {
                return new CpFieldRef(this.is.readUnsignedShort(), this.is.readUnsignedShort());
            }
            case 10: {
                return new CpMethodRef(this.is.readUnsignedShort(), this.is.readUnsignedShort());
            }
            case 11: {
                return new CpInterfaceMethodRef(this.is.readUnsignedShort(), this.is.readUnsignedShort());
            }
            case 12: {
                return new CpNameType(this.is.readUnsignedShort(), this.is.readUnsignedShort());
            }
            case 17: {
                return new CpDynamic(this.is.readUnsignedShort(), this.is.readUnsignedShort());
            }
            case 15: {
                return new CpMethodHandle(this.is.readByte(), this.is.readUnsignedShort());
            }
            case 16: {
                return new CpMethodType(this.is.readUnsignedShort());
            }
            case 18: {
                return new CpInvokeDynamic(this.is.readUnsignedShort(), this.is.readUnsignedShort());
            }
            case 19: {
                return new CpModule(this.is.readUnsignedShort());
            }
            case 20: {
                return new CpPackage(this.is.readUnsignedShort());
            }
        }
        throw new InvalidClassException("Unknown constant-pool tag: " + tag);
    }

    private Field readField(ClassBuilder builder) throws IOException {
        int access = this.is.readUnsignedShort();
        int nameIndex = this.is.readUnsignedShort();
        int typeIndex = this.is.readUnsignedShort();
        int numAttributes = this.is.readUnsignedShort();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < numAttributes; ++i) {
            Attribute attr = new AttributeReader(this, builder, this.is).readAttribute(AttributeContext.FIELD);
            if (attr == null) continue;
            attributes.add(attr);
        }
        return new Field(attributes, access, nameIndex, typeIndex);
    }

    private Method readMethod(ClassBuilder builder) throws IOException {
        int access = this.is.readUnsignedShort();
        int nameIndex = this.is.readUnsignedShort();
        int typeIndex = this.is.readUnsignedShort();
        int numAttributes = this.is.readUnsignedShort();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (int i = 0; i < numAttributes; ++i) {
            Attribute attr = new AttributeReader(this, builder, this.is).readAttribute(AttributeContext.METHOD);
            if (attr == null) continue;
            attributes.add(attr);
        }
        return new Method(attributes, access, nameIndex, typeIndex);
    }

    public boolean doDropForwardVersioned() {
        return this.dropForwardVersioned;
    }

    public void setDropForwardVersioned(boolean dropForwardVersioned) {
        this.dropForwardVersioned = dropForwardVersioned;
    }

    public boolean doDropEofAttributes() {
        return this.dropEofAttributes;
    }

    public void setDropEofAttributes(boolean dropEofAttributes) {
        this.dropEofAttributes = dropEofAttributes;
    }

    public boolean doDropDupeAnnotations() {
        return this.dropDupeAnnotations;
    }

    public void setDropDupeAnnotations(boolean dropDupeAnnotations) {
        this.dropDupeAnnotations = dropDupeAnnotations;
    }
}

