/*
 * Decompiled with CFR 0.152.
 */
package me.coley.cafedude.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import me.coley.cafedude.classfile.annotation.Annotation;
import me.coley.cafedude.classfile.annotation.AnnotationElementValue;
import me.coley.cafedude.classfile.annotation.ArrayElementValue;
import me.coley.cafedude.classfile.annotation.ClassElementValue;
import me.coley.cafedude.classfile.annotation.ElementValue;
import me.coley.cafedude.classfile.annotation.EnumElementValue;
import me.coley.cafedude.classfile.annotation.PrimitiveElementValue;
import me.coley.cafedude.classfile.annotation.TargetInfo;
import me.coley.cafedude.classfile.annotation.TypeAnnotation;
import me.coley.cafedude.classfile.annotation.TypePath;
import me.coley.cafedude.classfile.annotation.TypePathElement;
import me.coley.cafedude.classfile.annotation.Utf8ElementValue;
import me.coley.cafedude.classfile.attribute.AnnotationDefaultAttribute;
import me.coley.cafedude.classfile.attribute.AnnotationsAttribute;
import me.coley.cafedude.classfile.attribute.ParameterAnnotationsAttribute;

public class AnnotationWriter {
    private final DataOutputStream out;

    public AnnotationWriter(DataOutputStream out) {
        this.out = out;
    }

    public void writeAnnotationDefault(AnnotationDefaultAttribute annoDefault) throws IOException {
        this.writeElementValue(annoDefault.getElementValue());
    }

    public void writeAnnotations(AnnotationsAttribute annos) throws IOException {
        this.out.writeShort(annos.getAnnotations().size());
        for (Annotation annotation : annos.getAnnotations()) {
            this.writeAnnotation(annotation);
        }
    }

    public void writeTypeAnnotations(AnnotationsAttribute annos) throws IOException {
        this.out.writeShort(annos.getAnnotations().size());
        for (Annotation annotation : annos.getAnnotations()) {
            this.writeTypeAnnotation((TypeAnnotation)annotation);
        }
    }

    public void writeParameterAnnotations(ParameterAnnotationsAttribute annos) throws IOException {
        this.out.writeByte(annos.getParameterAnnotations().size());
        for (Map.Entry<Integer, List<Annotation>> parameterAnnotations : annos.getParameterAnnotations().entrySet()) {
            List<Annotation> annotations = parameterAnnotations.getValue();
            this.out.writeShort(annotations.size());
            for (Annotation annotation : annotations) {
                this.writeAnnotation(annotation);
            }
        }
    }

    private void writeAnnotation(Annotation annotation) throws IOException {
        this.out.writeShort(annotation.getTypeIndex());
        this.writeElementPairs(annotation.getValues());
    }

    private void writeTypeAnnotation(TypeAnnotation annotation) throws IOException {
        TargetInfo info = annotation.getTargetInfo();
        this.out.writeByte(info.getTargetType());
        switch (info.getTargetTypeKind()) {
            case TYPE_PARAMETER_TARGET: {
                TargetInfo.TypeParameterTargetInfo typeParameterTargetInfo = (TargetInfo.TypeParameterTargetInfo)info;
                this.out.writeByte(typeParameterTargetInfo.getTypeParameterIndex());
                break;
            }
            case SUPERTYPE_TARGET: {
                TargetInfo.SuperTypeTargetInfo superTypeTargetInfo = (TargetInfo.SuperTypeTargetInfo)info;
                this.out.writeShort(superTypeTargetInfo.getSuperTypeIndex());
                break;
            }
            case TYPE_PARAMETER_BOUND_TARGET: {
                TargetInfo.TypeParameterBoundTargetInfo typeParameterBoundTargetInfo = (TargetInfo.TypeParameterBoundTargetInfo)info;
                this.out.writeByte(typeParameterBoundTargetInfo.getTypeParameterIndex());
                this.out.writeByte(typeParameterBoundTargetInfo.getBoundIndex());
                break;
            }
            case EMPTY_TARGET: {
                break;
            }
            case FORMAL_PARAMETER_TARGET: {
                TargetInfo.FormalParameterTargetInfo formalParameterTargetInfo = (TargetInfo.FormalParameterTargetInfo)info;
                this.out.writeByte(formalParameterTargetInfo.getFormalParameterIndex());
                break;
            }
            case THROWS_TARGET: {
                TargetInfo.ThrowsTargetInfo throwsTargetInfo = (TargetInfo.ThrowsTargetInfo)info;
                this.out.writeShort(throwsTargetInfo.getThrowsTypeIndex());
                break;
            }
            case LOCALVAR_TARGET: {
                TargetInfo.LocalVarTargetInfo localVarTargetInfo = (TargetInfo.LocalVarTargetInfo)info;
                this.out.writeShort(localVarTargetInfo.getVariableTable().size());
                for (TargetInfo.LocalVarTargetInfo.Variable variable : localVarTargetInfo.getVariableTable()) {
                    this.out.writeShort(variable.getStartPc());
                    this.out.writeShort(variable.getLength());
                    this.out.writeShort(variable.getIndex());
                }
                break;
            }
            case CATCH_TARGET: {
                TargetInfo.CatchTargetInfo catchTargetInfo = (TargetInfo.CatchTargetInfo)info;
                this.out.writeShort(catchTargetInfo.getExceptionTableIndex());
                break;
            }
            case OFFSET_TARGET: {
                TargetInfo.OffsetTargetInfo offsetTargetInfo = (TargetInfo.OffsetTargetInfo)info;
                this.out.writeShort(offsetTargetInfo.getOffset());
                break;
            }
            case TYPE_ARGUMENT_TARGET: {
                TargetInfo.TypeArgumentTargetInfo typeArgumentTargetInfo = (TargetInfo.TypeArgumentTargetInfo)info;
                this.out.writeShort(typeArgumentTargetInfo.getOffset());
                this.out.writeByte(typeArgumentTargetInfo.getTypeArgumentIndex());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type argument target");
            }
        }
        this.writeTypePath(annotation.getTypePath());
        this.writeAnnotation(annotation);
    }

    private void writeTypePath(TypePath typePath) throws IOException {
        this.out.writeByte(typePath.getPath().size());
        for (TypePathElement element : typePath.getPath()) {
            this.out.writeByte(element.getKind().getValue());
            this.out.writeByte(element.getArgIndex());
        }
    }

    private void writeElementPairs(Map<Integer, ElementValue> values) throws IOException {
        this.out.writeShort(values.size());
        for (Map.Entry<Integer, ElementValue> elementValueEntry : values.entrySet()) {
            int nameIndex = elementValueEntry.getKey();
            this.out.writeShort(nameIndex);
            ElementValue value = elementValueEntry.getValue();
            this.writeElementValue(value);
        }
    }

    private void writeElementValue(ElementValue elementValue) throws IOException {
        this.out.writeByte(elementValue.getTag());
        switch (elementValue.getTag()) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                PrimitiveElementValue primitiveElementValue = (PrimitiveElementValue)elementValue;
                this.out.writeShort(primitiveElementValue.getValueIndex());
                break;
            }
            case 's': {
                Utf8ElementValue utf8ElementValue = (Utf8ElementValue)elementValue;
                this.out.writeShort(utf8ElementValue.getUtfIndex());
                break;
            }
            case 'e': {
                EnumElementValue enumElementValue = (EnumElementValue)elementValue;
                this.out.writeShort(enumElementValue.getTypeIndex());
                this.out.writeShort(enumElementValue.getNameIndex());
                break;
            }
            case 'c': {
                ClassElementValue classElementValue = (ClassElementValue)elementValue;
                this.out.writeShort(classElementValue.getClassIndex());
                break;
            }
            case '@': {
                AnnotationElementValue annotationElementValue = (AnnotationElementValue)elementValue;
                this.writeAnnotation(annotationElementValue.getAnnotation());
                break;
            }
            case '[': {
                ArrayElementValue arrayElementValue = (ArrayElementValue)elementValue;
                this.out.writeShort(arrayElementValue.getArray().size());
                for (ElementValue arrayValue : arrayElementValue.getArray()) {
                    this.writeElementValue(arrayValue);
                }
                break;
            }
        }
    }
}

